#include "mbed.h"
#include "eeprom.h"
# include "DigitDisplay.h"
#include "my8x8RGB.h"
#include "Servo.h"
Timer t;
/*



//ถึง 8192 //255 //16
// SET ค่า เก็บไว้ใน address 0
// เก็บค่า address ที่ไรท์ไปถึง ไว้ address ที่ 1

*/



InterruptIn countone(PA_13);
InterruptIn counttwo(PA_14);
InterruptIn countfive(PC_10);
InterruptIn countten(PC_12);

EEPROM memory(I2C_SDA,I2C_SCL,0);//PB9 , PB8
Serial pc(PA_15,PB_7);
//Serial pc(SERIAL_TX, SERIAL_RX);

DigitDisplay dis(PC_8,PA_12);//PC8,PA12 = 7,8

InterruptIn ok(PB_2);

AnalogIn button1(PC_5);
Servo servo(PC_6);//PC6 = LED1
int cfall = 0;
uint8_t state_menu=0;
uint8_t state_show=0;
uint8_t state_exit =0;
uint8_t data;

float value;
int position1;
int position2;
int position3;
int position4;
int valueint;
int userset= 0;
int limit=0;
int mode_set;
int display_RGB=-1;

void printone();
void printtwo();
void printfive();
void printten();
int sumAll();
void lock_pot_motor();

void LevelMatrix(int,int);
void LevelNumber(int);

int cone=0;
int ctwo=0;
int cfive=0;
int cten=0;
int value_from_eeprom;
int current_a=3;
int current_v;
int l=0 ;
int data_final = 'f';
int state_final = 0;

float level_0,level_1,level_2,level_3,level_4,level_5,level_6,level_7;

void LevelMatrix(int get,int x)//แสดงเปอร์เซนต์ตามเป้าหมาย get = ค่าเป้าหมายที่ใส่มา , แสดงที่ด้านขวาของ dot
{
    level_0=get/8;
    level_1=level_0 + level_0;
    level_2=level_1 + level_0;
    level_3=level_2 + level_0;
    level_4=level_3 + level_0;
    level_5=level_4 + level_0;
    level_6=level_5 + level_0;
    level_7=level_6 + level_0;

    if( 0 <= x && x <= level_0 ) {
        rgb_point(0,7,0,255,125);
        rgb_point(1,7,0,255,125);
        rgb_point(2,7,0,255,125);
        rgb_point(3,7,255,255,255);
    }
    if( level_0 < x && x <= level_1) {
        rgb_point(0,6,0,255,255);
        rgb_point(1,6,0,255,255);
        rgb_point(2,6,0,255,255);
        rgb_point(3,6,255,255,255);

        rgb_point(0,7,0,255,125);
        rgb_point(1,7,0,255,125);
        rgb_point(2,7,0,255,125);
        rgb_point(3,7,255,255,255);

    }
    if( level_1 < x && x <= level_2) {
        rgb_point(0,5,0,125,255);
        rgb_point(1,5,0,125,255);
        rgb_point(2,5,0,125,255);
        rgb_point(3,5,255,255,255);

        rgb_point(0,6,0,255,255);
        rgb_point(1,6,0,255,255);
        rgb_point(2,6,0,255,255);
        rgb_point(3,6,255,255,255);

        rgb_point(0,7,0,255,125);
        rgb_point(1,7,0,255,125);
        rgb_point(2,7,0,255,125);
        rgb_point(3,7,255,255,255);
    }
    if( level_2 < x && x <= level_3) {
        rgb_point(0,4,0,0,255);
        rgb_point(1,4,0,0,255);
        rgb_point(2,4,0,0,255);
        rgb_point(3,4,255,255,255);

        rgb_point(0,5,0,125,255);
        rgb_point(1,5,0,125,255);
        rgb_point(2,5,0,125,255);
        rgb_point(3,5,255,255,255);

        rgb_point(0,6,0,255,255);
        rgb_point(1,6,0,255,255);
        rgb_point(2,6,0,255,255);
        rgb_point(3,6,255,255,255);

        rgb_point(0,7,0,255,125);
        rgb_point(1,7,0,255,125);
        rgb_point(2,7,0,255,125);
        rgb_point(3,7,255,255,255);
    }
    if( level_3 < x && x <= level_4) {
        rgb_point(0,3,80,0,255);
        rgb_point(1,3,80,0,255);
        rgb_point(2,3,80,0,255);
        rgb_point(3,3,255,255,255);

        rgb_point(0,4,0,0,255);
        rgb_point(1,4,0,0,255);
        rgb_point(2,4,0,0,255);
        rgb_point(3,4,255,255,255);

        rgb_point(0,5,0,125,255);
        rgb_point(1,5,0,125,255);
        rgb_point(2,5,0,125,255);
        rgb_point(3,5,255,255,255);

        rgb_point(0,6,0,255,255);
        rgb_point(1,6,0,255,255);
        rgb_point(2,6,0,255,255);
        rgb_point(3,6,255,255,255);

        rgb_point(0,7,0,255,125);
        rgb_point(1,7,0,255,125);
        rgb_point(2,7,0,255,125);
        rgb_point(3,7,255,255,255);
    }
    if( level_4 < x && x <= level_5) {
        rgb_point(0,2,255,0,255);
        rgb_point(1,2,255,0,255);
        rgb_point(2,2,255,0,255);
        rgb_point(3,2,255,255,255);

        rgb_point(0,3,80,0,255);
        rgb_point(1,3,80,0,255);
        rgb_point(2,3,80,0,255);
        rgb_point(3,3,255,255,255);

        rgb_point(0,4,0,0,255);
        rgb_point(1,4,0,0,255);
        rgb_point(2,4,0,0,255);
        rgb_point(3,4,255,255,255);

        rgb_point(0,5,0,125,255);
        rgb_point(1,5,0,125,255);
        rgb_point(2,5,0,125,255);
        rgb_point(3,5,255,255,255);

        rgb_point(0,6,0,255,255);
        rgb_point(1,6,0,255,255);
        rgb_point(2,6,0,255,255);
        rgb_point(3,6,255,255,255);

        rgb_point(0,7,0,255,125);
        rgb_point(1,7,0,255,125);
        rgb_point(2,7,0,255,125);
        rgb_point(3,7,255,255,255);
    }
    if( level_5 < x && x <= level_6) {
        rgb_point(0,1,255,0,40);
        rgb_point(1,1,255,0,40);
        rgb_point(2,1,255,0,40);
        rgb_point(3,1,255,255,255);

        rgb_point(0,2,255,0,255);
        rgb_point(1,2,255,0,255);
        rgb_point(2,2,255,0,255);
        rgb_point(3,2,255,255,255);

        rgb_point(0,3,80,0,255);
        rgb_point(1,3,80,0,255);
        rgb_point(2,3,80,0,255);
        rgb_point(3,3,255,255,255);

        rgb_point(0,4,0,0,255);
        rgb_point(1,4,0,0,255);
        rgb_point(2,4,0,0,255);
        rgb_point(3,4,255,255,255);

        rgb_point(0,5,0,125,255);
        rgb_point(1,5,0,125,255);
        rgb_point(2,5,0,125,255);
        rgb_point(3,5,255,255,255);

        rgb_point(0,6,0,255,255);
        rgb_point(1,6,0,255,255);
        rgb_point(2,6,0,255,255);
        rgb_point(3,6,255,255,255);

        rgb_point(0,7,0,255,125);
        rgb_point(1,7,0,255,125);
        rgb_point(2,7,0,255,125);
        rgb_point(3,7,255,255,255);
    }
    if( level_6 < x && x <= level_7) {
        rgb_point(0,0,255,0,0);
        rgb_point(1,0,255,0,0);
        rgb_point(2,0,255,0,0);
        rgb_point(3,0,255,255,255);

        rgb_point(0,1,255,0,40);
        rgb_point(1,1,255,0,40);
        rgb_point(2,1,255,0,40);
        rgb_point(3,1,255,255,255);

        rgb_point(0,2,255,0,255);
        rgb_point(1,2,255,0,255);
        rgb_point(2,2,255,0,255);
        rgb_point(3,2,255,255,255);

        rgb_point(0,3,80,0,255);
        rgb_point(1,3,80,0,255);
        rgb_point(2,3,80,0,255);
        rgb_point(3,3,255,255,255);

        rgb_point(0,4,0,0,255);
        rgb_point(1,4,0,0,255);
        rgb_point(2,4,0,0,255);
        rgb_point(3,4,255,255,255);

        rgb_point(0,5,0,125,255);
        rgb_point(1,5,0,125,255);
        rgb_point(2,5,0,125,255);
        rgb_point(3,5,255,255,255);

        rgb_point(0,6,0,255,255);
        rgb_point(1,6,0,255,255);
        rgb_point(2,6,0,255,255);
        rgb_point(3,6,255,255,255);

        rgb_point(0,7,0,255,125);
        rgb_point(1,7,0,255,125);
        rgb_point(2,7,0,255,125);
        rgb_point(3,7,255,255,255);
    }
}

void LevelNumber(int x)//แสดงจำนวนเงินในกระปุก แสดงที่ฝั่งซ้ายของ dot
{
    //  printf("\n%d",x);
    if( 0 <= x && x <= 125 ) {
        rgb_point(4,7,255,255,255);
        rgb_point(5,7,0,125,255);
        rgb_point(6,7,0,125,255);
        rgb_point(7,7,0,125,255);
    }

    if( 125 < x && x <= 250) {
        rgb_point(4,6,255,255,255);
        rgb_point(5,6,0,255,255);
        rgb_point(6,6,0,255,255);
        rgb_point(7,6,0,255,255);

        rgb_point(4,7,255,255,255);
        rgb_point(5,7,0,125,255);
        rgb_point(6,7,0,125,255);
        rgb_point(7,7,0,125,255);
    }

    if( 250 < x && x <= 375) {
        rgb_point(4,5,255,255,255);
        rgb_point(5,5,0,255,125);
        rgb_point(6,5,0,255,125);
        rgb_point(7,5,0,255,125);

        rgb_point(4,6,255,255,255);
        rgb_point(5,6,0,255,255);
        rgb_point(6,6,0,255,255);
        rgb_point(7,6,0,255,255);

        rgb_point(4,7,255,255,255);
        rgb_point(5,7,0,125,255);
        rgb_point(6,7,0,125,255);
        rgb_point(7,7,0,125,255);
    }
    if( 375 < x && x <= 500) {
        rgb_point(4,4,255,255,255);
        rgb_point(5,4,0,255,0);
        rgb_point(6,4,0,255,0);
        rgb_point(7,4,0,255,0);

        rgb_point(4,5,255,255,255);
        rgb_point(5,5,0,255,125);
        rgb_point(6,5,0,255,125);
        rgb_point(7,5,0,255,125);

        rgb_point(4,6,255,255,255);
        rgb_point(5,6,0,255,255);
        rgb_point(6,6,0,255,255);
        rgb_point(7,6,0,255,255);

        rgb_point(4,7,255,255,255);
        rgb_point(5,7,0,125,255);
        rgb_point(6,7,0,125,255);
        rgb_point(7,7,0,125,255);
    }
    if( 500 < x && x <= 625) {
        rgb_point(4,3,255,255,255);
        rgb_point(5,3,125,255,0);
        rgb_point(6,3,125,255,0);
        rgb_point(7,3,125,255,0);

        rgb_point(4,4,255,255,255);
        rgb_point(5,4,0,255,0);
        rgb_point(6,4,0,255,0);
        rgb_point(7,4,0,255,0);

        rgb_point(4,5,255,255,255);
        rgb_point(5,5,0,255,125);
        rgb_point(6,5,0,255,125);
        rgb_point(7,5,0,255,125);

        rgb_point(4,6,255,255,255);
        rgb_point(5,6,0,255,255);
        rgb_point(6,6,0,255,255);
        rgb_point(7,6,0,255,255);

        rgb_point(4,7,255,255,255);
        rgb_point(5,7,0,125,255);
        rgb_point(6,7,0,125,255);
        rgb_point(7,7,0,125,255);
    }
    if( 625 < x && x <= 750) {
        rgb_point(4,2,255,255,255);
        rgb_point(5,2,255,255,0);
        rgb_point(6,2,255,255,0);
        rgb_point(7,2,255,255,0);

        rgb_point(4,3,255,255,255);
        rgb_point(5,3,125,255,0);
        rgb_point(6,3,125,255,0);
        rgb_point(7,3,125,255,0);

        rgb_point(4,4,255,255,255);
        rgb_point(5,4,0,255,0);
        rgb_point(6,4,0,255,0);
        rgb_point(7,4,0,255,0);

        rgb_point(4,5,255,255,255);
        rgb_point(5,5,0,255,125);
        rgb_point(6,5,0,255,125);
        rgb_point(7,5,0,255,125);

        rgb_point(4,6,255,255,255);
        rgb_point(5,6,0,255,255);
        rgb_point(6,6,0,255,255);
        rgb_point(7,6,0,255,255);

        rgb_point(4,7,255,255,255);
        rgb_point(5,7,0,125,255);
        rgb_point(6,7,0,125,255);
        rgb_point(7,7,0,125,255);
    }
    if( 750 < x && x <= 875) {
        rgb_point(4,1,255,255,255);
        rgb_point(5,1,255,125,0);
        rgb_point(6,1,255,125,0);
        rgb_point(7,1,255,125,0);

        rgb_point(4,2,255,255,255);
        rgb_point(5,2,255,255,0);
        rgb_point(6,2,255,255,0);
        rgb_point(7,2,255,255,0);

        rgb_point(4,3,255,255,255);
        rgb_point(5,3,125,255,0);
        rgb_point(6,3,125,255,0);
        rgb_point(7,3,125,255,0);

        rgb_point(4,4,255,255,255);
        rgb_point(5,4,0,255,0);
        rgb_point(6,4,0,255,0);
        rgb_point(7,4,0,255,0);

        rgb_point(4,5,255,255,255);
        rgb_point(5,5,0,255,125);
        rgb_point(6,5,0,255,125);
        rgb_point(7,5,0,255,125);

        rgb_point(4,6,255,255,255);
        rgb_point(5,6,0,255,255);
        rgb_point(6,6,0,255,255);
        rgb_point(7,6,0,255,255);

        rgb_point(4,7,255,255,255);
        rgb_point(5,7,0,125,255);
        rgb_point(6,7,0,125,255);
        rgb_point(7,7,0,125,255);
    }
    if( 875 < x && x <= 1000) {
        rgb_point(4,0,255,255,255);
        rgb_point(5,0,255,0,0);
        rgb_point(6,0,255,0,0);
        rgb_point(7,0,255,0,0);

        rgb_point(4,1,255,255,255);
        rgb_point(5,1,255,125,0);
        rgb_point(6,1,255,125,0);
        rgb_point(7,1,255,125,0);

        rgb_point(4,2,255,255,255);
        rgb_point(5,2,255,255,0);
        rgb_point(6,2,255,255,0);
        rgb_point(7,2,255,255,0);

        rgb_point(4,3,255,255,255);
        rgb_point(5,3,125,255,0);
        rgb_point(6,3,125,255,0);
        rgb_point(7,3,125,255,0);

        rgb_point(4,4,255,255,255);
        rgb_point(5,4,0,255,0);
        rgb_point(6,4,0,255,0);
        rgb_point(7,4,0,255,0);

        rgb_point(4,5,255,255,255);
        rgb_point(5,5,0,255,125);
        rgb_point(6,5,0,255,125);
        rgb_point(7,5,0,255,125);

        rgb_point(4,6,255,255,255);
        rgb_point(5,6,0,255,255);
        rgb_point(6,6,0,255,255);
        rgb_point(7,6,0,255,255);

        rgb_point(4,7,255,255,255);
        rgb_point(5,7,0,125,255);
        rgb_point(6,7,0,125,255);
        rgb_point(7,7,0,125,255);
    }
}


void happy()
{
    rgb_point(0,2,255,255,0);//ตาซ้าย
    rgb_point(1,1,255,255,0);//ตาซ้าย
    rgb_point(1,1,255,255,0);//ตาซ้าย
    rgb_point(2,2,255,255,0);//ตาซ้าย
    rgb_point(5,2,255,255,0);//ตาขวา
    rgb_point(6,1,255,255,0);//ตาซ้าย
    rgb_point(7,2,255,255,0);//ตาซ้าย
    rgb_point(2,4,255,255,0);//ปาก
    rgb_point(3,4,255,255,0);//ปาก
    rgb_point(4,4,255,255,0);//ปาก
    rgb_point(5,4,255,255,0);//ปาก
    rgb_point(6,4,255,255,0);//ปาก
    rgb_point(1,4,255,255,0);//ปาก
    rgb_point(2,5,255,255,0);//ปาก
    rgb_point(5,5,255,255,0);//ปาก
    rgb_point(3,6,255,255,0);//ปาก
    rgb_point(4,6,255,255,0);//ปาก
    rgb_point(3,5,255,255,0);//ปาก
    rgb_point(4,5,255,255,0);//ปาก
}


void smile()
{
    rgb_point(2,1,0,255,255);//ตาซ้าย
    rgb_point(2,2,0,255,255);//ตาซ้าย
    rgb_point(5,1,0,255,255);//ตาขวา
    rgb_point(5,2,0,255,255);//ตาขวา
    rgb_point(1,4,0,255,255);//ปาก
    rgb_point(6,4,0,255,255);//ปาก
    rgb_point(2,5,0,255,255);//ปาก
    rgb_point(5,5,0,255,255);//ปาก
    rgb_point(3,6,0,255,255);//ปาก
    rgb_point(4,6,0,255,255);//ปาก
}

void indifferent()
{

    rgb_point(2,1,255,125,0);//ตาซ้าย
    rgb_point(2,2,255,125,0);//ตาซ้าย
    rgb_point(1,1,255,125,0);//ตาซ้าย
    rgb_point(1,2,255,125,0);//ตาซ้าย
    rgb_point(5,1,255,125,0);//ตาขวา
    rgb_point(6,1,255,125,0);//ตาซ้าย
    rgb_point(6,2,255,125,0);//ตาซ้าย
    rgb_point(5,2,255,125,0);//ตาขวา
    rgb_point(1,5,255,125,0);//ปาก
    rgb_point(2,5,255,125,0);//ปาก
    rgb_point(3,5,255,125,0);//ปาก
    rgb_point(4,5,255,125,0);//ปาก
    rgb_point(5,5,255,125,0);//ปาก
    rgb_point(6,5,255,125,0);//ปาก
    rgb_point(1,5,255,125,0);//ปาก
    rgb_point(6,5,255,125,0);//ปาก
}

void frown()
{
    rgb_point(2,1,255,0,0);//ตาซ้าย
    rgb_point(2,2,255,0,0);//ตาซ้าย
    rgb_point(5,1,255,0,0);//ตาขวา
    rgb_point(5,2,255,0,0);//ตาขวา
    rgb_point(1,6,255,0,0);//ปาก
    rgb_point(2,5,255,0,0);//ปาก
    rgb_point(3,5,255,0,0);//ปาก
    rgb_point(4,5,255,0,0);//ปาก
    rgb_point(5,5,255,0,0);//ปาก
    rgb_point(6,6,255,0,0);//ปาก
}



void printone()
{
    cone++;

    wait_ms(200);
    pc.printf("one = %d\n",cone);

    sumAll();

    display_RGB=1;

    while(display_RGB==1) {
        t.start();
        screen_off();
        frown();
        displayRGB();
        if(t.read_ms()%1200==0)   {
            screen_off();
            display_RGB=-1;
        }

    }

}

void printtwo()
{
    ctwo++;

    wait_ms(200);
    pc.printf("two = %d\n",ctwo);
    //indifferent();
    sumAll();

    display_RGB=2;

    while(display_RGB==2) {
        t.start();
        screen_off();
        indifferent();
        displayRGB();
        if(t.read_ms()%1200==0)   {
            screen_off();
            display_RGB=-1;
        }

    }
}
void printfive()
{
    cfive++;

    wait_ms(200);
    pc.printf("five = %d\n",cfive);
    // smile();
    sumAll();

    display_RGB=3;
    while(display_RGB==3) {
        t.start();
        screen_off();
        smile();
        displayRGB();
        if(t.read_ms()%1200==0)   {
            screen_off();
            display_RGB=-1;
        }

    }
}
void printten()
{
    cten++;

    wait_ms(200);
    pc.printf("ten = %d\n",cten);
    // happy();
    sumAll();

    display_RGB=4;
    while(display_RGB==4) {
        t.start();
        screen_off();
        happy();
        displayRGB();
        if(t.read_ms()%1200==0)   {
            screen_off();
            display_RGB=-1;
        }

    }
}



void current_address_eeprom_save()
{
    int c=0;

    memory.write(1,(int)current_a);
    wait_ms(10);
    memory.read(1,c);
    wait_ms(10);
    //pc.printf("current_address_eeprom_save1 = %d\n",current_a);
    // pc.printf("current_address_eeprom_save = %d\n",c);

}

void current_value_eeprom_save()
{

    //  pc.printf("current_cv = %d\n",current_v);
    // pc.printf("current_a_cv = %d\n",current_a);
    wait_ms(10);
    memory.write(current_a,(int)current_v);
    wait_ms(10);
    memory.read(current_a,current_v);
    // pc.printf("current_cv1 = %d\n",current_v);
    wait_ms(10);

}
/*
void current_address_target()
{
    int li,b;
    b = current_a+1;
    memory.write(b,(int)limit);
    wait_ms(10);
    memory.read(b,li);
    wait_ms(10);

    pc.printf("current_address_target = %d\n",limit);
    pc.printf("current_address_target = %d\n",li);
}
*/
int read_current_a_value_from_eeprom()
{
    int current_address;
    int x =0;

    memory.write(2,(int)x);
    wait_ms(10);
    memory.read(1,current_address);
    wait_ms(10);

    return current_address;
}
/*
int read_current_address_target_from_eeprom()
{
    int current_limit;
    int x =0,b;

    b = current_a+1;
    memory.write(2,(int)x);
    wait_ms(10);
    memory.read(b,current_limit);
    wait_ms(10);
    pc.printf("T target = %d\n\n",b);
    pc.printf("target = %d\n",current_limit);
    return current_limit;

}
*/
int read_pre_value_from_eeprom()
{
    int current_value;
    int a ;
    int x =0;
    a = current_a-1;
    //  a = current_a;
    memory.write(2,(int)x);
    wait_ms(10);
    memory.read(a,current_value);
    wait_ms(10);
//   pc.printf("P current_a = %d\n\n",a);
    //  pc.printf("current_v = %d\n",current_v);
    return current_value;

}





int sumAll()
{
    int sumvalue;
    int valueofone;
    int valueoftwo;
    int valueoffive;
    int valueoften;

    valueofone = cone * 1;
    valueoftwo = ctwo * 2;
    valueoffive = cfive * 5;
    valueoften = cten * 10;

    //  pc.printf("previous_v = %d\n",current_v);
    sumvalue = valueofone + valueoftwo + valueoffive + valueoften + current_v;

    pc.printf("Total = %d\n",sumvalue);

    cone = 0;
    ctwo = 0;
    cfive = 0;
    cten = 0;

//   pc.printf("save_target_1 = %d\n",limit);
    current_v = sumvalue ;
    current_value_eeprom_save();
//   pc.printf("save_target_2 = %d\n",limit);
    current_a = current_a +1;
    //current_a = current_a +2;
    /*  if(current_a> 8192){

          current_a = 3 ;
          }*/

    current_address_eeprom_save();
    //  current_address_target();
    //  pc.printf("save_target_3 = %d\n",limit);
  //  pc.printf("current_v = %d\n",current_v);
   // pc.printf("current_a = %d\n\n",current_a);

    return sumvalue;
}


void checkfall()
{
    wait_ms(200);
    if(mode_set == 1) {
        if(limit == 0)userset = valueint ;
        data = 'c';
        pc.printf("LIMIT IS %d\n\n",userset);
        pc.printf("**********////////*********\n\n");
        pc.printf("ARE YOU SURE ?\n");
        pc.printf("y.IF YOU SURE\n");
        pc.printf("n.IF YOU NOT SURE\n");

        state_menu = 1;
        do {
            if(pc.readable()) {
                
                    data = pc.getc();
                    pc.printf("\n");
                    state_menu=0;
                    state_exit =1;
                    switch(data) {

                        case 'y':

                            limit = userset;
                            //  pc.printf("CV IS1 %d\n",current_v);
                            current_value_eeprom_save();
                            // current_a = current_a +2;
                            current_a = current_a +1;
                            //   pc.printf("CV IS2 %d\n",current_v);
                            current_address_eeprom_save();
                            //  pc.printf("CV IS3 %d\n",current_v);
                            //current_address_target();
                              lock_pot_motor();
                            pc.printf("LIMIT IS %d\n",limit);
                            //      pc.printf("CV IS %d\n",current_v);

                            break;

                        case 'n':

                            state_show =1;
                            pc.printf("PLEASE PRESS RESET TO SET LIMIT");

                            break;



                        default:
                            pc.printf("PLEASE SELECT y OR n\n");
                            pc.printf("\n");
                            data = 'c';
                            state_menu = 1;
                            break;
                    }
                }
           
            
        } while(data == 'c');

    } else  if(mode_set == 2) {
        display_RGB==0;
        if(limit == 0) {

            pc.printf("PLEASE SELECT 1 TO SET AMOUNT OF MONEY\n");


        } else {
            //เอาจาก eeprom
            //แสดงค่าของเงินที่หยอด ว่าในกระปุกมีเงินเท่าไหร่

            int c;
            int percent_from_target;
            c = read_pre_value_from_eeprom();
            pc.printf("Value in the pot : %d\n",c);
            pc.printf("Your Target : %d\n",limit);
            percent_from_target = (c*100)/limit;
            pc.printf("Completed : %d\n",percent_from_target);



            while(display_RGB==0) {
                t.start();
                screen_off();;
                LevelMatrix(limit,current_v);
                LevelNumber(current_v);
                displayRGB();
                if(t.read_ms()%4000==0)   {
                    screen_off();
                    display_RGB=-1;
                }

            }


        }
    }

    else {
        pc.printf("PLEASE SELECT 1 OR 2\n");
        state_show =1;
    }
}

void lock_pot_motor()
{


    servo.write(0.1);

}


void unlock_pot_motor()
{

    servo.write(0.7);


}


void open_pot()
{

    //limit = read_target();
    current_v = read_pre_value_from_eeprom();



    current_v = 0 ;
    current_a = 3;
    limit = 0;
    current_value_eeprom_save();
    //current_a = current_a +2;
    current_a = current_a +1;
    current_address_eeprom_save();
    //current_address_target();


    unlock_pot_motor();



}


int main()
{

    current_a = read_current_a_value_from_eeprom();
    current_v = read_pre_value_from_eeprom();
    // limit = read_current_address_target_from_eeprom();
    

    //  pc.printf("limit : %d\n",limit);

    limit = 0;
    position1 = limit/1000;
    position2 = (limit % 1000)/100;
    position3 = (limit % 100)/10;
    position3 = (limit % 10);


    dis.write(0,position1);
    dis.write(1,position2);
    dis.write(2,position3);
    dis.write(3,position4);


    // current_v = 0;
    // current_a = 3;
    //pc.printf("current_v = %d\n",current_v);
    // pc.printf("current_a = %d\n\n",current_a);

    t.start();
    char xx[3]= {64,64,64};
    INITRGB(xx);

    //screen_off();

    countone.fall(&printone);
    counttwo.fall(&printtwo);
    countfive.fall(&printfive);
    countten.fall(&printten);
    ok.rise(&checkfall);


    while(1) {


        do {
            if(limit <= current_v && limit != 0) {

                pc.printf("You reach the target\n");
                pc.printf("1.END THE SAVE MONEY PROJECT\n");
                pc.printf("2.GO ON THE SAVE MONEY PROJECT\n");
                do {
                    if(pc.readable()) {
                        data_final = pc.getc();
                    }

                } while(data_final=='f');

                if(data_final == '1') {

                    open_pot();
                    state_final = 1;

                } else if(data_final == '2') {

                    pc.printf(" PLEASE SELECT THE NEW TARGET\n");
                    pc.printf("PLEASE ROTATE POTENTIOMETER AND PRESS THE BUTTON TO SET LIMIT\n\n");
                    do {

                        value = button1.read();
                        value = value * 1000;

                        if (0 <= value && value <= 100) {
                            value = 100;
                        }

                        else if (100 <= value && value <= 200) {
                            value = 200;
                        }

                        else  if (200 <= value && value <= 300) {
                            value = 300;
                        }

                        else if (300 <= value && value <= 400) {
                            value = 400;
                        }

                        else if (400 <= value && value <= 500) {
                            value = 500;
                        }

                        else if (500 <= value && value <= 600) {
                            value = 600;
                        }

                        else if (600 <= value && value <= 700) {
                            value = 700;
                        }

                        else if (700 <= value && value <= 800) {
                            value = 800;
                        }

                        else if (800 <= value && value <= 900) {
                            value = 900;
                        }

                        else if (900 <= value && value <= 1000) {
                            value = 1000;
                        }
                        wait(0.2);
                        //pc.printf("value = %f\n",value);
                        wait(0.5);

                        position1 = value/1000;
                        valueint = value;
                        position2 = (valueint % 1000)/100;
                        position3 = (valueint % 100)/10;
                        position3 = (valueint % 10);


                        dis.write(0,position1);
                        dis.write(1,position2);
                        dis.write(2,position3);
                        dis.write(3,position4);





                    } while(state_exit ==0);
                    pc.printf("\n\n");

                    state_final = 1;

                } else {

                    pc.printf(" PLEASE SELECT 1 OR 2\n");
                    state_final = 0;

                }

            }
        } while(state_final = 0 && limit <= current_v);


        if(state_show == 0) {
            pc.printf("Menu\n");
            pc.printf("1.SET AMOUNT OF MONEY\n");
            pc.printf("2.SHOW TOTAL OF MONEY\n");
            state_show =1;
            mode_set = 0;
        }


        if(pc.readable()) {
            data = pc.getc();
            pc.printf("\n");
            state_show =0;
            state_exit =0;
            switch(data) {
                case '1':
                    if(limit == 0) {
                        mode_set = 1;
                        pc.printf("PLEASE ROTATE POTENTIOMETER AND PRESS THE BUTTON TO SET LIMIT\n\n");
                        do {

                            value = button1.read();
                            value = value * 1000;

                            if (0 <= value && value <= 100) {
                                value = 100;
                            }

                            else if (100 <= value && value <= 200) {
                                value = 200;
                            }

                            else  if (200 <= value && value <= 300) {
                                value = 300;
                            }

                            else if (300 <= value && value <= 400) {
                                value = 400;
                            }

                            else if (400 <= value && value <= 500) {
                                value = 500;
                            }

                            else if (500 <= value && value <= 600) {
                                value = 600;
                            }

                            else if (600 <= value && value <= 700) {
                                value = 700;
                            }

                            else if (700 <= value && value <= 800) {
                                value = 800;
                            }

                            else if (800 <= value && value <= 900) {
                                value = 900;
                            }

                            else if (900 <= value && value <= 1000) {
                                value = 1000;
                            }
                            wait(0.2);
                            //pc.printf("value = %f\n",value);
                            wait(0.5);

                            position1 = value/1000;
                            valueint = value;
                            position2 = (valueint % 1000)/100;
                            position3 = (valueint % 100)/10;
                            position3 = (valueint % 10);


                            dis.write(0,position1);
                            dis.write(1,position2);
                            dis.write(2,position3);
                            dis.write(3,position4);





                        } while(state_exit ==0);
                        pc.printf("\n\n");

                    } else {

                        pc.printf("\nYou have set target already.\n");

                    }
                    break;


                case '2':

                    pc.printf("LIMIT IS %d\n",limit);

                    mode_set = 2;

                default:

                    //  mode_set != 1 && mode_set != 2;
                    checkfall();
                    break;
            }

            pc.printf("**********////////*********\n\n");
        }
    }
}
