/*#include "mbed.h"

//------------------------------------
// Hyperterminal configuration
// 9600 bauds, 8-bit data, no parity
//------------------------------------

Serial pc(SERIAL_TX, SERIAL_RX);

DigitalOut myled(LED1);

int main() {
  int i = 1;
  pc.printf("Hello World !\n");
  while(1) {
      wait(1);
      pc.printf("This program runs since %d seconds.\n", i++);
      myled = !myled;
  }
}
 */


#include "mbed.h"
#include "MFRC522.h"
#include "eeprom.h"
#include "LCD4884.h"
//KL25Z Pins for MFRC522 SPI interface
#define SPI_MOSI    PB_15
#define SPI_MISO    PB_14
#define SPI_CLK    PB_13
#define SPI_CS      PB_12
// KL25Z Pin for MFRC522 reset
#define MF_RESET    PH_1
// KL25Z Pins for Debug UART port
#define UART_RX     D0
#define UART_TX     D1

Serial device(D8,D2);
DigitalIn plusbutton(PA_11);
DigitalIn minusbutton(PA_12);
uint16_t command[7];
uint16_t re_command[7];
uint16_t ch;
int color ,clear ;
char random[4][4]={"x0","x1","x2","x3"};
int num_random[4] ;
int highb , lowb ; //Send Number of Bottle
int total ;
int t_score ;
Serial     pc(SERIAL_TX,SERIAL_RX);
MFRC522    RFID(SPI_MOSI, SPI_MISO, SPI_CLK,SPI_CS, MF_RESET);
EEPROM     memory(D14,D15,0);
AnalogIn LDR(PC_3);
DigitalOut red(PA_1);
DigitalOut green(PA_4);
DigitalOut blue(PB_0);
DigitalIn limitsw(PC_9);
DigitalOut redled(D10);
DigitalOut greenled(D9);
DigitalIn rightbutton(D11);
DigitalIn leftbutton(D12);
DigitalOut ln1(PA_13);
DigitalOut ln2(PA_14);
DigitalOut Ena(PC_8);
DigitalIn limitright(PC_10);
DigitalIn limitcenter(PC_12);
DigitalIn limitleft(PC_11);
LCD4884 lcd;
Timer t ;
Timer t2 ;
Timer t3 ;
int16_t recieve ;
int check;
int counttran = 0  , countcolor = 0 ;
float valuered,valueblue,valuegreen;

//MFRC522::MIFARE_Key key;
class USER
{
public:
    char Name[20] ;
    char Surname[20] ;
    char StudentID[11] ;
    uint16_t point;
    int place ;
    USER(char name[],char surname[],char id[],int p) {
        for(int i=0; name[i]!='\0'; i++) {
            Name[i] = name[i];
        }
        for(int i=0; surname[i]!='\0'; i++) {
            Surname[i] =surname[i];
        }
        for(int i=0; id[i]!='\0'; i++) {
            StudentID[i] =id[i];
        }
        place = p ;
        memory.read(place,recieve);
        wait_ms(2);
        point = recieve ;
    }
    int getPoint() {
        memory.read(place,recieve);
        wait_ms(2);
        point = recieve ;
        return point ;
    }
    void UpdatePoint(int16_t s) {
        memory.read(place,recieve);
        point = recieve ;
        s = point + s;
        point = s ;
        memory.write(place,(uint16_t)s);
        wait_ms(2);
    }
    void SetPoint() {
        memory.write(place,NULL);
        wait_ms(2);
    }
};


void reverse(char *s)
{
    char *j;
    int c;

    j = s + strlen(s) - 1;
    while(s < j) {
        c = *s;
        *s++ = *j;
        *j-- = c;
    }
}
void itoa(int n, char s[])
{
    int i, sign;

    if ((sign = n) < 0)  /* record sign */
        n = -n;          /* make n positive */
    i = 0;
    do {       /* generate digits in reverse order */
        s[i++] = n % 10 + '0';   /* get next digit */
    } while ((n /= 10) > 0);     /* delete it */
    if (sign < 0)
        s[i++] = '-';
    s[i] = '\0';
    reverse(s);
}
void ShowUser(USER user)
{
    char Sur[2] ;
    Sur[0] = user.Surname[0];
    Sur[1] = '.';
    char buff[50] ;
    itoa(user.point,buff);
    lcd.LCD_clear();
    lcd.LCD_write_string(0,0,user.Name,0);
    lcd.LCD_write_string(55,0,Sur,0);
    lcd.LCD_write_string(0,2,user.StudentID,0);
    lcd.LCD_write_string(0,3,"Point : ",0);
    lcd.LCD_write_string(44,3,buff,0); //buff=point

}
void motor()
{
    
    
    
}
void colorsensor(int &colors,int &clears)
{
    char buff[40] ;
    char buff2[40] ;
    red = 1;
    blue = 1;
    green = 1 ;
    redled = 0 ;
    greenled = 1 ;
    //1=low 0=high
    // GREEN
    if(limitsw == 1) {
        sprintf(buff,"Clear: %d x2",counttran);
        lcd.LCD_write_string(0,2,buff,0);
        sprintf(buff2,"Color: %d x1",countcolor);
        lcd.LCD_write_string(0,3,buff2,0);
        t2.reset();    //30sec
        redled = 1 ;
        greenled = 0 ;
        //GReen
        red = 1;
        blue = 1;
        green = 0 ;
        wait(1);
        valuegreen = LDR.read();
        valuegreen = valuegreen*10000;

        // BLUE
        red = 1;
        blue = 0;
        green = 1 ;
        wait(1);
        valueblue = LDR.read();
        valueblue = valueblue*10000;

        // RED
        red = 0;
        blue = 1 ;
        green = 1 ;
        wait(1);
        valuered = LDR.read();
        valuered = valuered*10000;

        pc.printf("%d %d %d\n",limitleft.read(),limitright.read(),limitcenter.read());
        pc.printf(" G = %f\n B = %f\nR = %f\n",valuegreen,valueblue,valuered);
        wait(1);
        if(valuegreen >= valuered && valuegreen >= valueblue  && (valuered+valueblue)<=valuegreen ||valueblue >= valuered || valueblue >= valuegreen )
            { 
                    pc.printf("\n color\n");
                    countcolor++ ;
                     sprintf(buff2,"Color: %d x1",countcolor);
                     lcd.LCD_write_string(0,3,buff2,0);
               do{
                ln1 = 0 ; // ทวนเข็ม
                ln2 = 1 ;
                Ena = 1 ;
                 
                }while(limitleft == 0 );
                pc.printf("checklimitleft");
                ln1 = 1 ;
                ln2 = 0 ;
                Ena = 1 ;
                wait(1.5); 
                
                ln1 = 0 ;
                ln2 = 0 ;
                Ena = 0 ; 
                pc.printf("color bottle\n %d",countcolor);
            
            }
            else 
            { 
                   if(valuegreen >300 ||valuegreen-valueblue > 80 || valueblue-valuegreen > 100 && valuered -((valuegreen+valueblue)/2)<170)
                   {
                       pc.printf("\ncolor\n");
                       
                    countcolor++ ;
                     sprintf(buff2,"Color: %d x1",countcolor);
                     lcd.LCD_write_string(0,3,buff2,0);
                   do{
                    ln1 = 0 ; // ทวนเข็ม
                    ln2 = 1 ;
                    Ena = 1 ;
                 
                     }while(limitleft == 0 );
                    pc.printf("checklimitleft2");
                    ln1 = 1 ;
                    ln2 = 0 ;
                    Ena = 1 ;
                    wait(1.5); 
                
                    ln1 = 0 ;
                    ln2 = 0 ;
                    Ena = 0 ; 
                    pc.printf("color bottle\n %d",countcolor);
                        
                   
                   
                    }
                   else if(valuegreen <300 ||valuegreen-valueblue < 80 || valueblue-valuegreen < 100 && valuered -((valuegreen+valueblue)/2)>170)
                   {
                    pc.printf("\nclear\n");}
                    counttran++ ;


                    sprintf(buff,"Clear: %d x2",counttran);
                    lcd.LCD_write_string(0,2,buff,0);
                     do{
                    ln1 = 1 ; //ตามเข็ม
                    ln2 = 0 ;
                    Ena = 1 ; 
                
                    }while(limitright == 0 );
                    pc.printf("checklimitright");
                    ln1 = 0 ;
                    ln2 = 1 ;
                    Ena = 1 ;
                    wait(1.5); 
                
                    ln1 = 0 ;
                    ln2 = 0 ;
                    Ena = 0 ; 
                
                    pc.printf("transparent bottle\n %d ",counttran);

                    }         

            
        }
        int total ;
            total = countcolor + (counttran * 2);
            colors = countcolor ;
            clears = counttran ;
            sprintf(buff2,"total: %d ",total);
            lcd.LCD_write_string(0,4,buff2,0);

        red = 1;
        blue = 1;
        green = 1 ;
        while(limitsw == 1) {

        }
        t2.reset();
    }

USER Jettanan("Jettanan","Homchanthanakul","57340500015",1);
USER Nutthaya("Nutthaya","Hankla","57340500025",5);
USER Kanokwan("Kanokwan","Toncheingsai","57340500001",9);
char welcome[40] = {"Welcome to pae-za-leng"};
char please[40] = {"please touch your card"};
char selectstart[20] = {"start"};
char selectcancel[20] = {"cancel"};

int main()
{
    int check =0 ;
    red = 1;
    blue = 1;
    green = 1 ;
    uint8_t data,card[4]= {0};
    pc.baud(115200);
    Nutthaya.UpdatePoint(1000);
    RFID.PCD_Reset();
    wait(1.0);
    RFID.PCD_Init();
    lcd.LCD_init();
    lcd.backlight(OFF);
    while(1) {//e
        counttran = 0;
        countcolor = 0;
        lcd.backlight(ON);
        lcd.LCD_write_string(0,0,welcome,0);
        lcd.LCD_write_string(0,3,please,0);
        // Look for new cards // Select one of the cards
        if ( ! RFID.PICC_IsNewCardPresent() || ! RFID.PICC_ReadCardSerial()) {
            continue;
        }

        // Print Card UID
        pc.printf("Card UID: ");
        for(int i=0; card[i]!='\0'; i++) {
            card[i] = 0;
        }
        for (uint8_t i = 0; RFID.uid.uidByte[i]!= '\0' ; i++) {
            card[i] = data = RFID.uid.uidByte[i] ;
            pc.printf(" %d",data);

        }


        //////data card\\\\\\\

        if(card[0] == 106 && card[1] == 230 && card[2] == 38 && card[3] == 231) {
            pc.printf("\n Name : Jettanan H. \n Student's ID : 57340500015 \n point : %d ",Jettanan.getPoint());
            ShowUser(Jettanan);
        }
        if(card[0] == 186 && card[1] == 151 && card[2] == 37 && card[3] == 231) {
            pc.printf("\n Name : Nutthaya H. \n Student's ID : 57340500025 \n point : %d ",Nutthaya.getPoint());
            ShowUser(Nutthaya);
        }
        if(card[0] == 199 && card[1] == 230 && card[2] == 46 ) {
            pc.printf("\n Name : Kanokwan T. \n Student's ID : 57340500001 \n point : %d ",Kanokwan.getPoint());
            ShowUser(Kanokwan);
        }
        lcd.LCD_write_string(55,5,selectstart,1);
        lcd.LCD_write_string(0,5,selectcancel,1);

        pc.printf("\n\r");
        
        t.start();
        t.reset();
        while(t.read_ms()<10000) {
            //5
            if( rightbutton == 1 && leftbutton == 0) {
                //2
                greenled = 1;


                
                while(rightbutton ==1)
                    {wait(0.1);}
                    
                wait(0.5);
                lcd.LCD_clear();
                
                t2.start();
                t2.reset();
                lcd.LCD_write_string(0,0,"insert bottle",0);
                //lcd.LCD_clear();
                while(t2.read_ms()<30000) {
                    //1
                    check = 1 ;
                    color = 0;
                    clear = 0;
                    colorsensor(color,clear);
                    t3.start();
                    t3.reset();
                    while(t3.read_ms()<500) {
                        lcd.LCD_write_string(44,5,"Submit",1);
                        if(rightbutton == 1) {
                            while(rightbutton ==1)
                                {wait(0.1);}
                            wait(0.5);
                            goto LAND ;
                        }
                    }
                    lcd.LCD_write_string(44,5,"      ",0);
                    greenled = 0 ;
                }//1


            }//2
            else if(leftbutton == 1){break;}
        
        }//5
LAND :
        while(rightbutton ==1)
            {wait(0.1);}
        wait(0.5);
        lcd.LCD_clear();
        while(check == 1) {

            lcd.LCD_write_string(10,0,"Do you want",0);
            lcd.LCD_write_string(14,1,"to play a",0);
            lcd.LCD_write_string(20,3,"GAME ?",0);
            lcd.LCD_write_string(5,5,"No",0);
            lcd.LCD_write_string(40,5,"Yes",0);
            if(rightbutton == 1 && leftbutton == 0) {
            //3
            while(rightbutton ==1)
                {wait(0.1);}
            
            lcd.LCD_write_string(0,3,"join the GAME!",0);
            wait(1);
            /*Extend*/
             lcd.backlight(ON);
             lcd.LCD_init();
                total = countcolor + (counttran*2);
                color = countcolor ;
                clear = counttran ;
                highb = color/256 ;
                lowb = color - (highb*256);
                command[3] = lowb ;
                command[2] = highb ;
                highb = clear/256 ;
                lowb = clear - (highb*256);
                command[5] = lowb ;
                command[4] = highb ;
                command[0] = 0x42 ;
                command[1] = 0x52 ;
                command[6] = 0x4D ;

                 for(int i=0;i<7;i++)
                {
                     wait(0.1);
                     device.putc(command[i]); 
                    pc.printf("%x\n",command[i]);
    
                }
  
                //After allow to play game
                if(total<=1)
                {
                    lcd.LCD_clear();
                    lcd.LCD_write_string(0,2,"Sorry you don't",0);
                    lcd.LCD_write_string(0,3,"have any point",0);
                    wait(3);
                    uint16_t sim ;
                    sim = total ;
                    if(card[0] == 106 && card[1] == 230 && card[2] == 38 && card[3] == 231) {
            Jettanan.UpdatePoint(sim);
            wait(1);
            ShowUser(Jettanan);
        }
        if(card[0] == 186 && card[1] == 151 && card[2] == 37 && card[3] == 231) {
            Nutthaya.UpdatePoint(sim);
            wait(1);
            ShowUser(Nutthaya);
        }
        if(card[0] == 199 && card[1] == 230 && card[2] == 46 ) {
            Kanokwan.UpdatePoint(sim);
            wait(1);
            ShowUser(Kanokwan);
        }
        wait(3);
                    goto EXIT;    
                }
  
  int totalsim;
  uint16_t credits;
  totalsim = total;
  credits = 0;
  pc.printf("Game mode");
  lcd.LCD_clear();
  
  while(1)//select credits
  {
    
    lcd.LCD_write_string(0,0,"total P :",0);
   lcd.LCD_write_string(10,1,"credits :",0);
   lcd.LCD_write_string(0,3,"2 Point = 1 Credits",0);
    char buff[4];
    sprintf(buff,"%d",totalsim);
    lcd.LCD_write_string(67,0,buff,0);
    
    char buff2[4];
    sprintf(buff2,"%d",credits);
    lcd.LCD_write_string(67,1,buff2,1);
    if(plusbutton ==1)
    {
      while(plusbutton==1)
      {wait(0.2);}
      if((totalsim-2)>=0)
      {
        credits = credits +1 ;
        totalsim = totalsim - 2;
        pc.printf("credits + 1");
        lcd.LCD_clear();   
      }  
    }
    if(minusbutton ==1)
    {
       while(minusbutton==1)
      {wait(0.2);} 
      if((credits-1)>=0)
      {
        credits = credits - 1 ;
        totalsim = totalsim + 2;
        pc.printf("credits - 1");
        lcd.LCD_clear();     
      }
    }
    if(leftbutton ==1)
    {
        uint16_t pointsim ;
        pointsim = total ;
        if(card[0] == 106 && card[1] == 230 && card[2] == 38 && card[3] == 231) {
            Jettanan.UpdatePoint(pointsim);
            wait(1);
            pc.printf("point sim = %d\n",pointsim);
            ShowUser(Jettanan);
        }
        if(card[0] == 186 && card[1] == 151 && card[2] == 37 && card[3] == 231) {
            Nutthaya.UpdatePoint(pointsim);
            wait(1);
            pc.printf("point sim = %d\n",pointsim);
            ShowUser(Nutthaya);
        }
        if(card[0] == 199 && card[1] == 230 && card[2] == 46 ) {
            Kanokwan.UpdatePoint(pointsim);
            wait(1);
            pc.printf("point sim = %d\n",pointsim);
            ShowUser(Kanokwan);
        }
        wait(3);
        pc.printf("left");  
        goto LEFT ;    
    }
    if(rightbutton ==1)
    {
        if(credits ==0)
        {
            pc.printf("continue");
            continue;    
        }
        else if(credits >=1)
        {
            command[0]=0x42;
            command[1]=0x50;
            command[2]=0x00;
            command[3]=0x00;
            command[4]=0x00;
            command[5]=credits;
            command[6]=0x4D;
            for(int i=0;i<7;i++)
            {
                wait(0.1);
                device.putc(command[i]); 
                pc.printf("%x\n",command[i]);
                
            }
            uint16_t simm ;
            simm = total-(credits*2) ;
        if(card[0] == 106 && card[1] == 230 && card[2] == 38 && card[3] == 231) {
            Jettanan.UpdatePoint(simm);
            wait(0.3);
            ShowUser(Jettanan);
        }
        if(card[0] == 186 && card[1] == 151 && card[2] == 37 && card[3] == 231) {
            Nutthaya.UpdatePoint(simm);
            wait(0.3);
            ShowUser(Nutthaya);
        }
        if(card[0] == 199 && card[1] == 230 && card[2] == 46 ) {
            Kanokwan.UpdatePoint(simm);
            wait(0.3);
            ShowUser(Kanokwan);
        }      
            pc.printf("left");
            break;    
        }    
    }
    
  }//select credits
  lcd.LCD_clear();
  for(int w=0;w<credits;w++)
  {
    lcd.LCD_clear();
    lcd.LCD_write_string(0,0,"Credits:",0);
    char buff[4];
    sprintf(buff,"%d",credits-w);
    for(int i=0;i<7;i++)
    {
        re_command[i]=device.getc();
        pc.printf("%x\n",re_command[i]);    
    }
    if(re_command[0]==0x42 && re_command[1]==0x45 && re_command[6]==0x4D)
    {
        pc.printf("command not found");
        break;    
    }
    lcd.LCD_write_string(46,0,buff,0);
    lcd.LCD_write_string(58,0,"1 :",0);
    lcd.LCD_write_string(66,0,"??",0);
    lcd.LCD_write_string(58,1,"2 :",0);
    lcd.LCD_write_string(66,1,"??",0);  
    lcd.LCD_write_string(58,2,"3 :",0);
    lcd.LCD_write_string(66,2,"??",0);  
    lcd.LCD_write_string(58,3,"4 :",0);
    lcd.LCD_write_string(66,3,"??",0);
    lcd.LCD_write_string(0,4,"Pick up ball",0);
    lcd.LCD_write_string(0,5,"Dropto Gripper",0);
    ch = device.getc();
    lcd.LCD_write_string(0,4,"            ",0);
    lcd.LCD_write_string(0,5,"              ",0);  
    ch = device.getc();
    if(ch == 0x53)
    {
        lcd.LCD_write_string(58,0,"1 :",0);
        lcd.LCD_write_string(66,0,random[re_command[2]],0);
        lcd.LCD_write_string(58,1,"2 :",0);
        lcd.LCD_write_string(66,1,random[re_command[3]],0);  
        lcd.LCD_write_string(58,2,"3 :",0);
        lcd.LCD_write_string(66,2,random[re_command[4]],0);  
        lcd.LCD_write_string(58,3,"4 :",0);
        lcd.LCD_write_string(66,3,random[re_command[5]],0);
        lcd.LCD_write_string(0,4,"            ",0);
        lcd.LCD_write_string(0,5,"              ",0);  
        pc.printf("Start");            
    }
    ch = device.getc();
    char checkc[4];
    //char random[4][4]={"x0","x1","x2","x3"};
    if(ch == 1)
    {
        lcd.LCD_write_string(58,0,"1 :",1);
        lcd.LCD_write_string(66,0,random[re_command[2]],1);
        sprintf(checkc,"%s",random[re_command[2]]) ;
        
    }
    else if(ch == 2)
    {
        lcd.LCD_write_string(58,1,"2 :",1);
        lcd.LCD_write_string(66,1,random[re_command[3]],1); 
        sprintf(checkc,"%s",random[re_command[3]]) ;  
    }
    else if(ch == 3)
    {
        lcd.LCD_write_string(58,2,"3 :",1);
        lcd.LCD_write_string(66,2,random[re_command[4]],1);  
        sprintf(checkc,"%s",random[re_command[4]]) ;  
    }
    else if(ch == 4)
    {
        lcd.LCD_write_string(58,3,"4 :",1);
        lcd.LCD_write_string(66,3,random[re_command[5]],1);  
        sprintf(checkc,"%s",random[re_command[5]]) ;
    }
    if(checkc[1] == '0')
    {
        t_score = t_score+0;
        pc.printf("t_t");            
    }
    else if(checkc[1] == '1')
    {
        t_score = t_score+2;
        pc.printf("t_t");             
    }
    else if(checkc[1] == '2')
    {
        t_score = t_score+4;
        pc.printf("t_t");             
    }
    else if(checkc[1] == '3')
    {
        t_score = t_score+6;
        pc.printf("t_t");             
    }
    uint16_t gg;
    gg = device.getc();             
  }
  
  lcd.LCD_clear();
  lcd.LCD_write_string(0,0,"Total Score :",0);
  char buff3[6];
  sprintf(buff3,"%d",t_score);
  lcd.LCD_write_string(0,1,buff3,1);
  LEFT :
  
  if(card[0] == 106 && card[1] == 230 && card[2] == 38 && card[3] == 231) {
            Jettanan.UpdatePoint(t_score);
            wait(0.3);
            ShowUser(Jettanan);
        }
        if(card[0] == 186 && card[1] == 151 && card[2] == 37 && card[3] == 231) {
            Nutthaya.UpdatePoint(t_score);
            wait(0.3);
            ShowUser(Nutthaya);
        }
        if(card[0] == 199 && card[1] == 230 && card[2] == 46 ) {
            Kanokwan.UpdatePoint(t_score);
            wait(0.3);
            ShowUser(Kanokwan);
        }
  wait(3);
  lcd.LCD_clear();
            /*End Extend*/
            EXIT :
            lcd.LCD_clear();
            break;
        }//3
        else if(leftbutton == 1) {
            //4
            while(leftbutton ==1)
                {wait(0.1);}
                total = countcolor + (counttran*2);
                color = countcolor ;
                clear = counttran ;
                highb = color/256 ;
                lowb = color - (highb*256);
                command[3] = lowb ;
                command[2] = highb ;
                highb = clear/256 ;
                lowb = clear - (highb*256);
                command[5] = lowb ;
                command[4] = highb ;
                command[0] = 0x42 ;
                command[1] = 0x52 ;
                command[6] = 0x4D ;

                 for(int i=0;i<7;i++)
                {
                     wait(0.1);
                     device.putc(command[i]); 
                    pc.printf("%x\n",command[i]);
    
                }
                uint16_t sim2 ;
                sim2 = total;
             if(card[0] == 106 && card[1] == 230 && card[2] == 38 && card[3] == 231) {
            Jettanan.UpdatePoint(sim2);
            wait(1);
            ShowUser(Jettanan);
        }
        if(card[0] == 186 && card[1] == 151 && card[2] == 37 && card[3] == 231) {
            Nutthaya.UpdatePoint(sim2);
            wait(1);
            ShowUser(Nutthaya);
        }
        if(card[0] == 199 && card[1] == 230 && card[2] == 46 ) {
            Kanokwan.UpdatePoint(sim2);
            wait(1);
            ShowUser(Kanokwan);
        }
        wait(3);   
            card[0] = 0;
            card[1] = 0;
            card[2] = 0;
            card[3] = 0;
            lcd.LCD_clear();
            break;
        }//4
        }
        
        
        lcd.LCD_clear();
        check = 0;
    }//e
}