#include "mbed.h"
#include "eeprom.h"

Serial device(D8,D2);
Serial pc(SERIAL_TX,SERIAL_RX);
EEPROM memory(D14,D15,0);
DigitalIn resetbt(D3);
DigitalOut led(LED2);
DigitalOut ln1(A0);
DigitalOut ln2(A1);
PwmOut ln3(PC_8);
PwmOut ln4(PC_6);
PwmOut ln11(PB_14);
PwmOut ln22(PB_15);
DigitalIn limitA(D4);
DigitalIn limitB(D5);
DigitalIn limitC(D6);
DigitalIn limitD(D7);
DigitalIn limit1(D9);
DigitalIn limit2(D10);
DigitalIn limit3(D11);
DigitalIn limit4(D12);
DigitalIn switchh(PB_13);
Timer t;
Timer t2;
Timer t3;
int credits ;
uint16_t score ;
int t_score ;
void MotorA(int a)//สายพาน
{
    if(a == 1)
    {
        ln1 = 1;
        ln2 = 0;    
    }
    if(a == -1)
    {
        ln1 = 0;
        ln2 = 1;    
    }
    if(a == 0)
    {
        ln1 = 0;
        ln2 = 0;    
    }    
}
void MotorB(int a)//Gripper
{
    if(a == 1)
    {
        ln3 = 1;
        ln4 = 0;    
    }
    if(a == -1)
    {
        ln3 = 0;
        ln4 = 1;    
    }
    if(a == 0)
    {
        ln3 = 0;
        ln4 = 0;    
    }    
}
void MotorC(int a)//Door
{
    if(a == 1)
    {
        ln11 = 1;
        ln22 = 0;    
    }
    if(a == -1)
    {
        ln11 = 0;
        ln22 = 1;    
    }
    if(a == 0)
    {
        ln11 = 0;
        ln22 = 0;    
    }    
}
uint16_t numb[4];//0=high byte color , 1 = low byte color , 2 = high byte clear , 3 = low byte clear
uint16_t command[7];
uint16_t rnumb[4];
uint16_t re_command[7];
uint16_t pattern[24][4]={{1,2,3,0},{1,2,0,3},{1,3,2,0},{1,3,0,2},{1,0,2,3},{1,0,3,2}
                        ,{2,1,3,0},{2,1,0,3},{2,3,1,0},{2,3,0,1},{2,0,1,3},{2,0,3,1}
                        ,{3,1,2,0},{3,1,0,2},{3,2,1,0},{3,2,0,1},{3,0,1,2},{3,0,2,1}
                        ,{0,1,2,3},{0,1,3,2},{0,2,1,3},{0,2,3,1},{0,3,1,2},{0,3,2,1}};
int color_num , clear_num ;
int colorb,clearb ;
int num1 , num2 ;
char ch ;
int main() {
   pc.baud(115200);
   t_score = 0;
   pc.printf("\nin program");
   while(1)
  {
    if(resetbt == 1)
    {
        uint16_t m[4]={0};
        memory.write(20,m,8);
        pc.printf("clear complete");
        led = 1;
        wait(1);
        led = 0;   
    }
    if(re_command[1] == 0x44)
    {
    uint16_t m[4]={0};
    memory.write(20,m,8);
    pc.printf("clear complete");
    }
    pc.printf("\nwait for serial");
    
    for(int i=0;i<7;i++)
    {
        re_command[i] = device.getc();
        pc.printf("%x ",re_command[i]);
    }
    if(re_command[0] != 0x42)
    {
        pc.printf("Wrong Pattern");
        continue ;  
    }
    pc.printf("\n%s\n",re_command);
    if(re_command[6] != 0x4D)
    {
        pc.printf("Wrong Pattern");
        continue ;    
    }
    if(re_command[1] == 0x52)//Record All Bottle
    {
        num1 = re_command[3];
        num2 = re_command[2];
        color_num = (num2*256) + num1 ;
        num1 = re_command[5];
        num2 = re_command[4];
        clear_num = (num2*256) + num1 ;
        pc.printf("color bottle = %d \nclear bottle = %d \n",color_num,clear_num); 
        memory.read(20,numb,8);
        colorb = ((numb[0]*256)+numb[1])+color_num;
        clearb = ((numb[2]*256)+numb[3])+clear_num;
        int highb , lowb ;
        highb = colorb/256 ;
        lowb = colorb - (highb*256);
        numb[1] = lowb ;
        numb[0] = highb ;
        highb = clearb/256 ;
        lowb = clearb - (highb*256);
        numb[3] = lowb ;
        numb[2] = highb ;
        memory.write (20,numb,8);
        memory.read(20,rnumb,8);
        colorb = (rnumb[0]*256) + rnumb[1] ;
        clearb = (rnumb[2]*256) + rnumb[3] ;
        pc.printf("Record Complete\nall color bottle = %d \nall clear bottle = %d \n",colorb,clearb);    
    }
    else if(re_command[1] == 0x43)
    {
        memory.read(20,numb,8);
        colorb = ((numb[0]*256)+numb[1]);
        clearb = ((numb[2]*256)+numb[3]);   
        pc.printf("color bottle : %d\n",colorb);
        pc.printf("clear bottle : %d\n",clearb); 
    }
    else if(re_command[1] == 0x50)
    {
        pc.printf("Game Mode");
        credits = re_command[5];
        pc.printf("Credits : %d\n",credits); 
         srand(time(NULL));
         int patternNum ;
         
        for(int i=1;i<=credits;i++)
        {
            patternNum = rand()%16 ;
            command[0] = 0x42 ;
            command[1] = 0x50 ;
            command[2] = pattern[patternNum][0];
            command[3] = pattern[patternNum][1];
            command[4] = pattern[patternNum][2];
            command[5] = pattern[patternNum][3];
            command[6] = 0x4D ;
            for(int j=0;j<7;j++)
            {
                wait(0.2);
                device.putc(command[j]);
                pc.printf("\n0x%x",command[j]);    
            }
            ln11 = 0 ;
            ln22 = 0.4 ;
            wait(1);
            ln11 = 0;
            ln22 = 0;
            wait(0.6);
            ln11 = 0;
            ln22 = 0;
            wait(0.4);
            ln11 = 0.4 ;
            ln22 = 0 ;
            wait(1);
            ln11 = 0;
            ln22 = 0;
            ln3 = 0.1;
            ln4 = 0;
            wait(0.1);
            ln3 = 0 ;
            ln4 = 0 ;
            while(limitA ==0)
            {
                    
            }
            pc.printf("\nPut the ball complete\n");
            device.putc(0x50);
            ln4 = 0.3 ;
            ln3 = 0 ;
            wait(0.5);
            MotorA(1);
            t.start();
            t.reset();
            int a;
            pc.printf("MotorA(a)"); 
            while(t.read_ms()<10000)
            {
                if(limitB==1)
                {
                    a=1;      
                }
                if(limitC==1)
                {
                    a=1;    
                }    
                if(limitD==1)
                {
                    a=-1;    
                }
                if(switchh==1)
                {
                    break;    
                }
                MotorA(a);
                
            }
            pc.printf("\nBall has fall\n");
            
            MotorA(0);
            ln3 = 0;
            ln4 = 0.3;
            wait(0.1);
            MotorB(0);
            MotorB(0);
            device.putc(0x53);
            wait(0.1);
           /* uint16_t pattern[24][4]={{1,2,3,4},{1,2,4,3},{1,3,2,4},{1,3,4,2},{1,4,2,3},{1,4,3,2}
                        ,{2,1,3,4},{2,1,4,3},{2,3,1,4},{2,3,4,1},{2,4,1,3},{2,4,3,1}
                        ,{3,1,2,4},{3,1,4,2},{3,2,1,4},{3,2,4,1},{3,4,1,2},{3,4,2,1}
                        ,{4,1,2,3},{4,1,3,2},{4,2,1,3},{4,2,3,1},{4,3,1,2},{4,3,2,1}};*/
            int checkp ;
            int checkst;
            while(1)
            {
                
                if(limit1 ==1)
                {
                    checkst = 1;
                    break;       
                }
                else if(limit2 ==1)
                {
                    checkst = 2; 
                    break;       
                }
                else if(limit3 ==1)
                {
                    checkst = 3;
                    break;        
                }
                else if(limit4 ==1)
                {
                    checkst = 4;
                    break;        
                }
                
            }
            device.putc(checkst);
            wait(0.1);
            while(1)
            {
            if(limitB ==0)
                {
                    MotorA(-1);    
                }
                else
                {
                    MotorA(0);
                    break;    
                }    
            }
            
            pc.printf("complete one tern checkp = %x\n",checkst);
            wait(2);
            device.putc(0x52);
        }   
    }
    
    
    
    
  }
}
//Test Slave
/*Serial device(D8,D2);
Serial pc(SERIAL_TX,SERIAL_RX);
uint16_t y=0;

int main()
{
    while(1)
    {
        y = device.getc();
        pc.printf("%d\n",y);            
    }
}*/