#include "mbed.h"
#include "MFRC522.h"
#include "HX711.h"
#include <cmath>
#define standard (float)0.001
Timer t_esp;
Serial pc(USBTX, USBRX);
Serial esp(D8, D2);
Timer t;
int  count,ended,timeout;
char buf[1024];
char snd[255];
char data1[3];
char data2[3];
char data3[3];
char data4[3];
char GET[255] = "GET /update?key=ICJ0ZF8N5NLYLW0B";
char length[255] = "AT+CIPSEND=74\r\n";
char ssid[32] = "KMUTT_WIFI";
char pwd [32] = "";
void SendCMD(),getreply(),ESPconfig(),ESPsetbaudrate();
MFRC522    RfChip(D11, D12, D13, D14,D7);
DigitalOut A4988STEP(D4);
DigitalOut A4988DIR(D3);
HX711 Balance(D5,D6);
int Case1;
int BeforeGram=0;
int AfterGram=0;
int ChangeG=0;
int TotalG = 0;
int TotalOG = 0;

void STEP()
{
    A4988DIR = 0;
    A4988STEP = 0;
    for (int i = 0 ; i<50 ; i++) {
        A4988STEP = 1;
        wait(0.03);
        A4988STEP = 0;
        wait(0.03);
    }
}

int Rfid()
{
    int i = 1,K;
    K=0;
    while(i == 1) {
        K=0;
        if ( ! RfChip.PICC_IsNewCardPresent()) {
            //pc.printf("IT IS UnReadable \n");
            wait_ms(500);
            break;
        }
        if (RfChip.PICC_ReadCardSerial()) {
            pc.printf("Readable \n");
            wait_ms(500);
            K = 1;
        }
        i=0;
    }
    return K;
}

int GetGram()
{
    long value;
    long valueTare;
    float kilo;
    float kilo2=0,condition;
    int gram = 0;
    int x = 0;
    int state,j=0;
    float diff_kilo;
    valueTare = 8960566; 
    for(int i = 0 ; i<1 ; i++) {
        wait_ms(1000);
        value = Balance.getValue();
        kilo = (((float)value-(float)valueTare)/143200);
        kilo= abs (kilo);
        diff_kilo=kilo - kilo2;
        diff_kilo = abs(diff_kilo);
        wait(0.5);
        //pc.printf("diff ; %f \n",diff_kilo && gram==0);

        if(kilo > standard) {
            gram = kilo* (float)70.4014 ;//convert to gram
        } else if(kilo < standard) {
            gram=0;
        } else if(kilo<kilo2 && diff_kilo > standard && state!=0) {
            pc.printf("kg old = %.2f\n",gram);
            gram = gram-condition ;
            j=0;
            pc.printf("kg new = %.2f\n",gram);
            pc.printf("condition  = %d\n",condition);
        } else if(diff_kilo > standard && gram !=0 && kilo>kilo2) {
            condition = gram;
            gram = condition + (diff_kilo* (float)70.4014) ;
            state=j+1;
            i++;
        }
        //pc.printf("Valeur : %ld          Poids : %.3f       RPoids : %.3f\n",value,kilo,kilo2);
        //pc.printf("Gram : %d g        \n",gram);
        x = gram;
        gram = 0;
        kilo2=kilo;
    }
    return x;
}

int main()
{
    pc.baud(9600);
   esp.baud(9600);
    RfChip.PCD_Init();
    int II;
    int GG=0;
    while(1) {
        II = Rfid();
        printf("II State =%d \n",II);
        printf("Main Gram = %d \n",GG);
        switch(II){
            case 1 :
            int OG = 0; 
            int SG=0;
            int count = 20;
            BeforeGram = GetGram(); // Memory First
            TotalOG = TotalG;
            do{
            OG = GG;
            GG = GetGram();
            SG = OG - GG ;
            if(SG == 0){ count--; }
            printf("SG = %d \n",SG);
            printf("count = %d \n",count);
            }while(count != 0);
            AfterGram = GG; // Memory Last
            ChangeG = BeforeGram - AfterGram;
            TotalOG = ChangeG + TotalOG;
            printf("Before gram :%d\n",BeforeGram);
            printf("After gram :%d\n",AfterGram);
            printf("Change gram :%d\n",ChangeG);
            pc.printf("B=%d,A=%d,C=%d,T=%d,",BeforeGram,AfterGram,ChangeG,TotalOG);
            ESPconfig();
            break;
       // }
            case 0 :
            printf("UnReadable \n");
         
       // else if(II == 0) {
            if(GG < 100) {
                printf("Step \n");
                STEP();
                break;}
         //   }
                
            
        }
       GG = GetGram();
       TotalG = TotalOG;
       printf("Total = %d \n",TotalG);
    }
}
void ESPconfig()
{
    
    wait(5);
    //wait(2);
    strcpy(snd,"AT\r\n");
    SendCMD();
    timeout=3;
    getreply();
    pc.printf(buf);
    
    wait(2);
    pc.printf("\f---------- Starting ESP Config ----------\r\n\n");

    pc.printf("---------- Reset & get Firmware ----------\r\n");
    strcpy(snd,"AT+RST\r\n");
    SendCMD();
    timeout=3;
    getreply();
    pc.printf(buf);

    wait(2);

    // set CWMODE to 1=Station,2=AP,3=BOTH, default mode 1 (Station)
    pc.printf("\n---------- Setting Mode ----------\r\n");
    strcpy(snd, "AT+CWMODE=1\r\n");
    SendCMD();
    timeout=5;
    getreply();
    pc.printf(buf);

    wait(2);

    // set CIPMUX to 0=Single,1=Multi
    pc.printf("\n---------- Setting Connection Mode ----------\r\n");
    strcpy(snd, "AT+CIPMUX=0\r\n");
    SendCMD();
    timeout=3;
    getreply();
    pc.printf(buf);

    wait(2);

    pc.printf("\n---------- Connecting to AP ----------\r\n");
    pc.printf("ssid = %s   pwd = %s\r\n",ssid,pwd);
    strcpy(snd, "AT+CWJAP=\"");
    strcat(snd, ssid);
    strcat(snd, "\",\"");
    strcat(snd, pwd);
    strcat(snd, "\"\r\n");
    SendCMD();
    timeout=10;
    getreply();
    pc.printf(buf);

    wait(2);

    pc.printf("\n---------- Get Connection Status ----------\r\n");
    strcpy(snd, "AT+CIPSTATUS\r\n");
    SendCMD();
    timeout=3;
    getreply();
    pc.printf(buf);

        pc.printf("\n---------- SEND COMMAND ----------\r\n");
        strcpy(snd,"AT+CIPSTART=\"TCP\",\"184.106.153.149\",80\r\n");
        SendCMD();
        timeout=5;
        getreply();
        pc.printf(buf);

        sprintf(data1, "%d",BeforeGram);
        strcat(GET,"&field1=");
        strcat(GET,data1);
        
        sprintf(data2, "%d",AfterGram);
        strcat(GET,"&field2=");
        strcat(GET,data2);
        
        sprintf(data3, "%d",ChangeG);
        strcat(GET,"&field3=");
        strcat(GET,data3);
        
        sprintf(data4, "%d",TotalOG);
        strcat(GET,"&field4=");
        strcat(GET,data4);
        
        
        strcat(GET,"\r\n");
        

        strcpy(snd,length);
        SendCMD();
        timeout=2;
        getreply();
        pc.printf(buf);
        
        strcpy(snd,GET);
        SendCMD();
        timeout=10;
        getreply();
        pc.printf(buf);   
        
        wait(60);

        pc.printf("\n---------- END ----------\r\n");
        
}
void SendCMD()
{
    esp.printf("%s", snd);
}

void getreply()
{
    memset(buf, '\0', sizeof(buf));
    t_esp.start();
    ended=0;
    count=0;
    while(!ended)
    {
        if(esp.readable()) 
        {
            buf[count] = esp.getc();
            count++;
        }
        if(t_esp.read() > timeout) {
            ended = 1;
            t_esp.stop();
            t_esp.reset();
        }
    }
}
