#include "mbed.h"
#include "HX711.h"
#include "LCD4884.h"
#include "string.h"
#include <cmath>
#define standard_poid (float)0.030
#define standard_kilo (float)0.2
LCD4884 lcd;
Serial pc(USBTX,USBRX);
Serial dataserial(PA_11,PA_12);
HX711 mudule1(PA_9, PC_7);
HX711 mudule2(PB_6, PA_7);
HX711 mudule3(PA_6, PA_5);
HX711 mudule4(PB_9, PB_8);
float find_kilo(float valeur,float valeurTare);
class Find_kg
{
public:
    Find_kg();
    ~Find_kg();
    float find_kilo(float valeur,float valeurTare);
private:
    float poid[2];
    float kilo;
    float diff_poids;
};

int main()
{

    lcd.LCD_init();
    lcd.backlight(ON);
    pc.baud(115200);
    Find_kg loadcell_1;
    Find_kg loadcell_2;
    Find_kg loadcell_3;
    Find_kg loadcell_4;
    long valeur1,valeurTare1;
    long valeur2,valeurTare2;
    long valeur3,valeurTare3;
    long valeur4,valeurTare4;
    valeurTare1 = mudule1.getValue();
    valeurTare2 = mudule2.getValue();
    valeurTare3 = mudule3.getValue();
    valeurTare4 = mudule4.getValue();
    Find_kg loadcell_5;
    Find_kg loadcell_6;
    Find_kg loadcell_7;
    Find_kg loadcell_8;
    uint8_t state_show=0;
    uint8_t state_exit =0;
    uint8_t data;
    float module1,module2,module3,module4;
    int check_data=0;
    int gram_output;
    int state_mass =0;
    int state_select=0;
    float kilo_output;
    float kilo_output1,kilo_output2;
    int state_output=0;
    int state_calibrate=0;
    int kilo_calibrate[4];
    int state_onemass=0,state_multiple_mass=0;
    char str[50];
    char str1[50];
    char str2[50];
    pc.printf("START Application !\n");
    lcd.LCD_write_string(0,0,"START Application !",0);
    wait(3);
    lcd.LCD_clear();
    while(1) {
                if(state_select==0) {
                    pc.printf("Please calibrate mass of each plate. \n");
                    lcd.LCD_write_string(0,0,"Please calibrate mass of each plate.",0);
                    state_select=1;
                }
                module1=0;
                module2=0;
                module3=0;
                module4=0;
               // wait_ms(1000);
                valeur1 = mudule1.getValue();
                valeur2 = mudule2.getValue();
                valeur3 = mudule3.getValue();
                valeur4 = mudule4.getValue();
                module1=loadcell_1.find_kilo(valeur1,valeurTare1);
                module2=loadcell_2.find_kilo(valeur2,valeurTare2);
                module3=loadcell_3.find_kilo(valeur3,valeurTare3);
                module4=loadcell_4.find_kilo(valeur4,valeurTare4);
                if(state_calibrate==0) {
                    if(module1>=1 || module2>=1 || module3>=1 || module4>=1) {
                        kilo_calibrate[0]=module1;
                        kilo_calibrate[1]=module2;
                        kilo_calibrate[2]=module3;
                        kilo_calibrate[3]=module4;
                        state_calibrate=1;
                    }
                }

                if     (kilo_calibrate[0]>=1 && kilo_calibrate[1]==0 && kilo_calibrate[2]==0 && kilo_calibrate[3]==0 && state_calibrate==1) {
                    state_onemass=1;
                } else if(kilo_calibrate[0]==0 && kilo_calibrate[1]>=1 && kilo_calibrate[2]==0 && kilo_calibrate[3]==0 && state_calibrate==1) {
                    state_onemass=1;
                } else if(kilo_calibrate[0]==0 && kilo_calibrate[1]==0 && kilo_calibrate[2]>=1 && kilo_calibrate[3]==0 && state_calibrate==1) {
                    state_onemass=1;
                } else if(kilo_calibrate[0]==0 && kilo_calibrate[1]==0 && kilo_calibrate[2]==0 && kilo_calibrate[3]>=1 && state_calibrate==1) {
                    state_onemass=1;
                } else {
                    state_onemass=0;
                }

                if     (kilo_calibrate[0]>=1 && kilo_calibrate[1]>=1 && kilo_calibrate[2]==0 &&kilo_calibrate[3]==0 && state_calibrate==1) {
                    state_multiple_mass=1;
                } else if(kilo_calibrate[0]==0 && kilo_calibrate[1]>=1 && kilo_calibrate[2]>=1 &&kilo_calibrate[3]==0 && state_calibrate==1) {
                    state_multiple_mass=1;
                } else if(kilo_calibrate[0]>=1 && kilo_calibrate[1]==0 && kilo_calibrate[2]>=1 &&kilo_calibrate[3]==0 && state_calibrate==1) {
                    state_multiple_mass=1;
                } else if(kilo_calibrate[0]>=1 && kilo_calibrate[1]==0 && kilo_calibrate[2]==0 &&kilo_calibrate[3]>=1 && state_calibrate==1) {
                    state_multiple_mass=1;
                } else if(kilo_calibrate[0]==0 && kilo_calibrate[1]>=1 && kilo_calibrate[2]==0 &&kilo_calibrate[3]>=1 && state_calibrate==1) {
                    state_multiple_mass=1;
                } else if(kilo_calibrate[0]==0 && kilo_calibrate[1]==0 && kilo_calibrate[2]>=1 &&kilo_calibrate[3]>=1 && state_calibrate==1) {
                    state_multiple_mass=1;
                } else {
                    state_multiple_mass=0;
                }

                if(state_onemass==1&&state_multiple_mass!=1) {

                    if(module1>standard_kilo && module2<standard_kilo && module3<standard_kilo && module4<standard_kilo) {
                        state_mass =1;
                        kilo_output = module1;
                        pc.printf("Mass of 5 plate.\n");
                        lcd.LCD_write_string(0,1,"On 5 plate.",0);
                    } else if(module1>standard_kilo && module2>standard_kilo && module3<standard_kilo && module4<standard_kilo) {
                        state_mass =2;
                        kilo_output = module1+module2;
                        pc.printf("Mass of 5 and 6 plate.\n");
                        lcd.LCD_write_string(0,1,"On 5 and 6 plate.",0);
                    } else if(module1>standard_kilo && module2<standard_kilo && module3>standard_kilo && module4<standard_kilo) {
                        state_mass =3;
                        kilo_output = module1+module3;
                        pc.printf("Mass of 5 and 7 plate.\n");
                        lcd.LCD_write_string(0,1,"On 5 and 7 plate.",0);
                    } else if(module1>standard_kilo && module2>standard_kilo && module3>standard_kilo && module4>standard_kilo) {
                        state_mass =4;
                        kilo_output = module1+module2+module3+module4;
                        pc.printf("Mass in the center of 5,6,7,8 plate.\n");
                        lcd.LCD_write_string(0,1,"Center of 5,6,7,8 plate.",0);
                    } else if(module1<standard_kilo && module2>standard_kilo && module3<standard_kilo && module4<standard_kilo) {
                        state_mass =5;
                        kilo_output = module2;
                        pc.printf("Mass of 6 plate.\n");
                        lcd.LCD_write_string(0,1,"On 6 plate.",0);
                    } else if(module1<standard_kilo && module2>standard_kilo && module3<standard_kilo && module4>standard_kilo) {
                        state_mass =6;
                        kilo_output = module2+module4;
                        pc.printf("Mass of 6 and 8 plate.\n");
                        lcd.LCD_write_string(0,1,"On 6 and 8 plate.",0);
                    } else if(module1<standard_kilo && module2<standard_kilo && module3>standard_kilo && module4<standard_kilo) {
                        state_mass =7;
                        kilo_output = module3;
                        pc.printf("Mass of 7 plate. \n");
                        lcd.LCD_write_string(0,1,"Mass of 7 plate.",0);
                    } else if(module1<standard_kilo && module2<standard_kilo && module3>standard_kilo && module4>standard_kilo) {
                        state_mass =8;
                        kilo_output = module3+module4;
                        pc.printf("Mass of 7 and 8 plate.\n");
                        lcd.LCD_write_string(0,1,"On 7 and 8 plate.",0);
                    } else if(module1<standard_kilo && module2<standard_kilo && module3<standard_kilo && module4>standard_kilo) {
                        state_mass =9;
                        kilo_output = module4;
                        pc.printf("Mass of 8 plate.\n");
                        lcd.LCD_write_string(0,1,"On 8 plate.",0);
                    } else {
                        kilo_output =0;
                        //pc.printf("Undetect mass of 4 plate.\n");
                    }

                    pc.printf("Kg : %.3f kg\n",kilo_output);
                    sprintf(str,"Kg : %.3f kg",kilo_output);
                    lcd.LCD_write_string(0,2,str,0);
                }
                //wait(1);
                //lcd.LCD_clear();
                else if (state_multiple_mass==1) {
                    if(module1>standard_kilo && module2>standard_kilo && module3<standard_kilo && module4<standard_kilo) {
                        kilo_output1=module1;
                        kilo_output2=module2;
                        pc.printf("Mass 1 on 5 plate  = %.3f kg.\n",kilo_output1);
                        sprintf(str1,"Mass 1 on 5 plate = %.3f kg",kilo_output1);
                        lcd.LCD_write_string(0,1,str1,0);
                        pc.printf("Mass 2 of 6 plate = %.3f kg.\n",kilo_output2);
                        sprintf(str2,"Mass 2 on 6 plate = %.3f kg",kilo_output2);
                        lcd.LCD_write_string(0,2,str2,0);
                    } else if(module1>standard_kilo && module2<standard_kilo && module3>standard_kilo && module4<standard_kilo) {
                        kilo_output1=module1;
                        kilo_output2=module3;
                        pc.printf("Mass 1 of 5 plate = %.3f kg.\n",kilo_output1);
                        sprintf(str1,"Mass 1 on 5 plate = %.3f kg",kilo_output1);
                        lcd.LCD_write_string(0,1,str1,0);
                        pc.printf("Mass 2 of 7 plate = %.3f kg.\n",kilo_output2);
                        sprintf(str2,"Mass 2 on 7 plate = %.3f kg",kilo_output2);
                        lcd.LCD_write_string(0,2,str2,0);
                    } else if(module1>standard_kilo && module2<standard_kilo && module3<standard_kilo && module4>standard_kilo) {
                        kilo_output1=module1;
                        kilo_output2=module4;
                        pc.printf("Mass 1 of 5 plate  = %.3f kg.\n",kilo_output1);
                        sprintf(str1,"Mass 1 on 5 plate = %.3f kg",kilo_output1);
                        lcd.LCD_write_string(0,1,str1,0);
                        pc.printf("Mass 2 of 8 plate = %.3f kg.\n",kilo_output2);
                        sprintf(str2,"Mass 2 on 8 plate = %.3f kg",kilo_output2);
                        lcd.LCD_write_string(0,2,str2,0);
                    } else if(module1<standard_kilo && module2>standard_kilo && module3>standard_kilo && module4<standard_kilo) {
                        kilo_output1=module2;
                        kilo_output2=module3;
                        pc.printf("Mass 1 of 6 plate = %.3f kg.\n",kilo_output1);
                        sprintf(str1,"Mass 1 on 6 plate = %.3f kg",kilo_output1);
                        lcd.LCD_write_string(0,1,str1,0);
                        pc.printf("Mass 2 of 7 plate  = %.3f kg.\n",kilo_output2);
                        sprintf(str2,"Mass 2 on 7 plate = %.3f kg",kilo_output2);
                        lcd.LCD_write_string(0,2,str2,0);
                    } else if(module1<standard_kilo && module2>standard_kilo && module3<standard_kilo && module4>standard_kilo) {
                        kilo_output1=module2;
                        kilo_output2=module4;
                        pc.printf("Mass 1 of 6 plate = %.3f kg.\n",kilo_output1);
                        sprintf(str1,"Mass 1 on 6 plate = %.3f kg",kilo_output1);
                        lcd.LCD_write_string(0,1,str1,0);
                        pc.printf("Mass 2 of 8 plate = %.3f kg.\n",kilo_output2);
                        sprintf(str2,"Mass 2 on 8 plate = %.3f kg",kilo_output2);
                        lcd.LCD_write_string(0,2,str2,0);
                    } else if(module1<standard_kilo && module2<standard_kilo && module3>standard_kilo && module4>standard_kilo) {
                        kilo_output1=module3;
                        kilo_output2=module4;
                        pc.printf("Mass 1 of 7 plate  = %.3f kg.\n",kilo_output1);
                        sprintf(str1,"Mass 1 on 7 plate = %.3f kg",kilo_output1);
                        lcd.LCD_write_string(0,1,str1,0);
                        pc.printf("Mass 2 of 8 plate = %.3f kg.\n",kilo_output2);
                        sprintf(str2,"Mass 2 on 8 plate = %.3f kg",kilo_output2);
                        lcd.LCD_write_string(0,2,str2,0);
                    } else if(module1>standard_kilo && module2>standard_kilo && module3>standard_kilo && module4<standard_kilo) {
                        if(module1>module2 && module1>module3) {
                            kilo_output1=module1;
                            kilo_output2=module2+module3;
                            pc.printf("Mass 1 of 5 plate  = %.3f kg.\n",kilo_output1);
                            sprintf(str1,"Mass 1 on 5 plate = %.3f kg",kilo_output1);
                            lcd.LCD_write_string(0,1,str1,0);
                            pc.printf("Mass 2 between 6 and 7 plate = %.3f kg.\n",kilo_output2);
                            sprintf(str2,"Mass 2 on 6,7 plate = %.3f kg",kilo_output2);
                            lcd.LCD_write_string(0,2,str2,0);
                        } else if(module2>module1 && module2>module3) {
                            kilo_output1=module2;
                            kilo_output2=module1+module3;
                            pc.printf("Mass 1 of 6 plate  = %.3f kg.\n",kilo_output1);
                            sprintf(str1,"Mass 1 on 6 plate = %.3f kg",kilo_output1);
                            lcd.LCD_write_string(0,1,str1,0);
                            pc.printf("Mass 2 on 5 and 7 plate = %.3f kg.\n",kilo_output2);
                            sprintf(str2,"Mass 2 on 5,7 plate = %.3f kg",kilo_output2);
                            lcd.LCD_write_string(0,2,str2,0);
                        } else if(module3>module1 && module3>module2) {
                            kilo_output1=module3;
                            kilo_output2=module1+module2;
                            pc.printf("Mass 1 of 7 plate  = %.3f kg.\n",kilo_output1);
                            sprintf(str1,"Mass 1 on 7 plate = %.3f kg",kilo_output1);
                            lcd.LCD_write_string(0,1,str1,0);
                            pc.printf("Mass 2 between 5 and 6 plate = %.3f kg.\n",kilo_output2);
                            sprintf(str2,"Mass 2 on 5,6 plate = %.3f kg",kilo_output2);
                            lcd.LCD_write_string(0,2,str2,0);
                        }
                    } else if(module1>standard_kilo && module2>standard_kilo && module3<standard_kilo && module4>standard_kilo) {
                        if(module1>module2 && module1>module4) {
                            kilo_output1=module1;
                            kilo_output2=module2+module4;
                            pc.printf("Mass 1 of 5 plate  = %.3f kg.\n",kilo_output1);
                            sprintf(str1,"Mass 1 on 5 plate = %.3f kg",kilo_output1);
                            lcd.LCD_write_string(0,1,str1,0);
                            pc.printf("Mass 2 between 6 and 8 plate = %.3f kg.\n",kilo_output2);
                            sprintf(str2,"Mass 2 on 6,8 plate = %.3f kg",kilo_output2);
                            lcd.LCD_write_string(0,2,str2,0);
                        } else if(module2>module1 && module2>module4) {
                            kilo_output1=module2;
                            kilo_output2=module1+module4;
                            pc.printf("Mass 1 on 6 plate  = %.3f kg.\n",kilo_output1);
                            sprintf(str1,"Mass 1 on 6 plate = %.3f kg",kilo_output1);
                            lcd.LCD_write_string(0,1,str1,0);
                            pc.printf("Mass 2 between 5 and 8 plate = %.3f kg.\n",kilo_output2);
                            sprintf(str2,"Mass 2 on 5,8 plate = %.3f kg",kilo_output2);
                            lcd.LCD_write_string(0,2,str2,0);
                        } else if(module4>module1 && module4>module2) {
                            kilo_output1=module4;
                            kilo_output2=module1+module2;
                            pc.printf("Mass 1 of 8 plate  = %.3f kg.\n",kilo_output1);
                            sprintf(str1,"Mass 1 on 8 plate = %.3f kg",kilo_output1);
                            lcd.LCD_write_string(0,1,str1,0);
                            pc.printf("Mass 2 between 5 and 6 plate = %.3f kg.\n",kilo_output2);
                            sprintf(str2,"Mass 2 on 5,6 plate = %.3f kg",kilo_output2);
                            lcd.LCD_write_string(0,2,str2,0);
                        }
                    } else if(module1>standard_kilo && module2<standard_kilo && module3>standard_kilo && module4>standard_kilo) {
                        if(module1>module3 && module1>module4) {
                            kilo_output1=module1;
                            kilo_output2=module3+module4;
                            pc.printf("Mass 1 of 5 plate  = %.3f kg.\n",kilo_output1);
                            sprintf(str1,"Mass 1 on 5 plate = %.3f kg",kilo_output1);
                            lcd.LCD_write_string(0,1,str1,0);
                            pc.printf("Mass 2 between 7 and 8 plate = %.3f kg.\n",kilo_output2);
                            sprintf(str2,"Mass 2 on 7,8 plate = %.3f kg",kilo_output2);
                            lcd.LCD_write_string(0,2,str2,0);
                        } else if(module3>module1 && module3>module4) {
                            kilo_output1=module3;
                            kilo_output2=module1+module4;
                            pc.printf("Mass 1 of 7 plate  = %.3f kg.\n",kilo_output1);
                            sprintf(str1,"Mass 1 on 7 plate = %.3f kg",kilo_output1);
                            lcd.LCD_write_string(0,1,str1,0);
                            pc.printf("Mass 2 between 5 and 8 plate = %.3f kg.\n",kilo_output2);
                            sprintf(str2,"Mass 2 on 5,8 plate = %.3f kg",kilo_output2);
                            lcd.LCD_write_string(0,2,str2,0);
                        } else if(module4>module1 && module4>module3) {
                            kilo_output1=module4;
                            kilo_output2=module1+module3;
                            pc.printf("Mass 1 of 8 plate  = %.3f kg.\n",kilo_output1);
                            sprintf(str1,"Mass 1 on 8 plate = %.3f kg",kilo_output1);
                            lcd.LCD_write_string(0,1,str1,0);
                            pc.printf("Mass 2 between 5 and 7 plate = %.3f kg.\n",kilo_output2);
                            sprintf(str2,"Mass 2 on 5,7 plate = %.3f kg",kilo_output2);
                            lcd.LCD_write_string(0,2,str2,0);
                        }
                    } else if(module1<standard_kilo && module2>standard_kilo && module3>standard_kilo && module4>standard_kilo) {
                        if(module2>module3 && module2>module4) {
                            kilo_output1=module2;
                            kilo_output2=module3+module4;
                            pc.printf("Mass 1 of 6 plate  = %.3f kg.\n",kilo_output1);
                            sprintf(str1,"Mass 1 on 6 plate = %.3f kg",kilo_output1);
                            lcd.LCD_write_string(0,1,str1,0);
                            pc.printf("Mass 2 between 7 and 8 plate = %.3f kg.\n",kilo_output2);
                            sprintf(str2,"Mass 2 on 7,8 plate = %.3f kg",kilo_output2);
                            lcd.LCD_write_string(0,2,str2,0);
                        } else if(module3>module2 && module3>module4) {
                            kilo_output1=module3;
                            kilo_output2=module2+module4;
                            pc.printf("Mass 1 of 7 plate  = %.3f kg.\n",kilo_output1);
                            sprintf(str1,"Mass 1 on 7 plate = %.3f kg",kilo_output1);
                            lcd.LCD_write_string(0,1,str1,0);
                            pc.printf("Mass 2 between 6 and 8 plate = %.3f kg.\n",kilo_output2);
                            sprintf(str2,"Mass 2 on 6,8 plate = %.3f kg",kilo_output2);
                            lcd.LCD_write_string(0,2,str2,0);
                        } else if(module4>module2 && module4>module3) {
                            kilo_output1=module4;
                            kilo_output2=module2+module3;
                            pc.printf("Mass 1 of 8 plate  = %.3f kg.\n",kilo_output1);
                            sprintf(str1,"Mass 1 on 8 plate = %.3f kg",kilo_output1);
                            lcd.LCD_write_string(0,1,str1,0);
                            pc.printf("Mass 2 between 6 and 7 plate = %.3f kg.\n",kilo_output2);
                            sprintf(str2,"Mass 2 on 6,7 plate = %.3f kg",kilo_output2);
                            lcd.LCD_write_string(0,2,str2,0);
                        }
                    } else if(module1>standard_kilo && module2>standard_kilo && module3>standard_kilo && module4>standard_kilo) {
                        if(module1>module2 && module1>module3 && module1>module4) {
                            if(module2>module3 && module2>module4) {
                                kilo_output1=module1+module2;
                                kilo_output2=module3+module4;
                                pc.printf("Mass 1 between 5 and 6 plate  = %.3f kg.\n",kilo_output1);
                                sprintf(str1,"Mass 1 on 5,6 plate = %.3f kg",kilo_output1);
                                lcd.LCD_write_string(0,1,str1,0);
                                pc.printf("Mass 2 between 7 and 8 plate  = %.3f kg.\n",kilo_output2);
                                sprintf(str2,"Mass 2 on 7,8 plate = %.3f kg",kilo_output2);
                                lcd.LCD_write_string(0,2,str2,0);
                            } else if(module3>module2 && module3>module4) {
                                kilo_output1=module1+module3;
                                kilo_output2=module2+module4;
                                pc.printf("Mass 1 between 5 and 7 plate  = %.3f kg.\n",kilo_output1);
                                sprintf(str1,"Mass 1 on 5,7 plate = %.3f kg",kilo_output1);
                                lcd.LCD_write_string(0,1,str1,0);
                                pc.printf("Mass 2 between 6 and 8 plate  = %.3f kg.\n",kilo_output2);
                                sprintf(str2,"Mass 2 on 6,8 plate = %.3f kg",kilo_output2);
                                lcd.LCD_write_string(0,2,str2,0);
                            } else if(module4>module2 && module4>module3) {
                                kilo_output1=module1+module4;
                                kilo_output2=module2+module3;
                                pc.printf("Mass 1 on 5,8 plate  = %.3f kg.\n",kilo_output1);
                                sprintf(str1,"Mass 1 on 5,8 plate = %.3f kg",kilo_output1);
                                lcd.LCD_write_string(0,1,str1,0);
                                pc.printf("Mass 2 between 6 and 7 plate  = %.3f kg.\n",kilo_output2);
                                sprintf(str2,"Mass 2 on 6,7 plate = %.3f kg",kilo_output2);
                                lcd.LCD_write_string(0,2,str2,0);
                            } else {
                                pc.printf("Undefind weight (have 2 mass on 4 plate).\n");
                                lcd.LCD_write_string(0,1,"Undefind weight (have 2 mass on 4 plate).",0);
                            }
                        } else if(module2>module1 && module2>module3 && module2>module4) {
                            if(module1>module3 && module1>module4) {
                                kilo_output1=module1+module2;
                                kilo_output2=module3+module4;
                                pc.printf("Mass 1 between 5 and 6 plate  = %.3f kg.\n",kilo_output1);
                                sprintf(str1,"Mass 1 on 5,6 plate = %.3f kg",kilo_output1);
                                lcd.LCD_write_string(0,1,str1,0);
                                pc.printf("Mass 2 between 7 and 8 plate  = %.3f kg.\n",kilo_output2);
                                sprintf(str2,"Mass 2 on 7,8 plate = %.3f kg",kilo_output2);
                                lcd.LCD_write_string(0,2,str2,0);
                            } else if(module3>module1 && module3>module4) {
                                kilo_output1=module2+module3;
                                kilo_output2=module1+module4;
                                pc.printf("Mass 1 between 6 and 7 plate  = %.3f kg.\n",kilo_output1);
                                sprintf(str1,"Mass 1 on 6,7 plate = %.3f kg",kilo_output1);
                                lcd.LCD_write_string(0,1,str1,0);
                                pc.printf("Mass 2 between 5 and 8 plate  = %.3f kg.\n",kilo_output2);
                                sprintf(str2,"Mass 2 on 5,8 plate = %.3f kg",kilo_output2);
                                lcd.LCD_write_string(0,2,str2,0);
                            } else if(module4>module1 && module4>module3) {
                                kilo_output1=module2+module4;
                                kilo_output2=module1+module3;
                                pc.printf("Mass 1 between 6 and 5 plate  = %.3f kg.\n",kilo_output1);
                                sprintf(str1,"Mass 1 on 6,5 plate = %.3f kg",kilo_output1);
                                lcd.LCD_write_string(0,1,str1,0);
                                pc.printf("Mass 2 between 5 and 7 plate  = %.3f kg.\n",kilo_output2);
                                sprintf(str2,"Mass 2 on 5,7 plate = %.3f kg",kilo_output2);
                                lcd.LCD_write_string(0,2,str2,0);
                            } else {
                                pc.printf("Undefind weight (have 2 mass on 4 plate).\n");
                                lcd.LCD_write_string(0,1,"Undefind weight (have 2 mass on 4 plate).",0);
                            }
                        } else if(module3>module1 && module3>module2 && module3>module4) {
                            if(module1>module2 && module1>module4) {
                                kilo_output1=module1+module3;
                                kilo_output2=module2+module4;
                                pc.printf("Mass 1 between 5 and 7 plate   = %.3f kg.\n",kilo_output1);
                                sprintf(str1,"Mass 1 on 5,7 plate = %.3f kg",kilo_output1);
                                lcd.LCD_write_string(0,1,str1,0);
                                pc.printf("Mass 2 between 6 and 8 plate = %.3f kg.\n",kilo_output2);
                                sprintf(str2,"Mass 2 on 6,8 plate = %.3f kg",kilo_output2);
                                lcd.LCD_write_string(0,2,str2,0);
                            } else if(module2>module1 && module2>module4) {
                                kilo_output1=module2+module3;
                                kilo_output2=module1+module4;
                                pc.printf("Mass 1 between 6 and 7 plate  = %.3f kg.\n",kilo_output1);
                                sprintf(str1,"Mass 1 on 6,7 plate = %.3f kg",kilo_output1);
                                lcd.LCD_write_string(0,1,str1,0);
                                pc.printf("Mass 2 between 5 and 8 plate  = %.3f kg.\n",kilo_output2);
                                sprintf(str2,"Mass 2 on 5,8 plate = %.3f kg",kilo_output2);
                                lcd.LCD_write_string(0,2,str2,0);
                            } else if(module4>module1 && module4>module2) {
                                kilo_output1=module3+module4;
                                kilo_output2=module1+module2;
                                pc.printf("Mass 1 between 7 and 8 plate  = %.3f kg.\n",kilo_output1);
                                sprintf(str1,"Mass 1 on 7,8 plate = %.3f kg",kilo_output1);
                                lcd.LCD_write_string(0,1,str1,0);
                                pc.printf("Mass 2 between 5 and 6 plate  = %.3f kg.\n",kilo_output2);
                                sprintf(str2,"Mass 2 on 5,6 plate = %.3f kg",kilo_output2);
                                lcd.LCD_write_string(0,2,str2,0);
                            } else {
                                pc.printf("Undefind weight (have 2 mass on 4 plate).\n");
                                lcd.LCD_write_string(0,1,"Undefind weight (have 2 mass on 4 plate).",0);
                            }
                        } else if(module4>module1 && module4>module2 && module4>module3) {
                            if(module1>module2 && module1>module3) {
                                kilo_output1=module1+module4;
                                kilo_output2=module2+module3;
                                pc.printf("Mass 1 between 5 and 8 plate   = %.3f kg.\n",kilo_output1);
                                sprintf(str1,"Mass 1 on 5,8 plate = %.3f kg",kilo_output1);
                                lcd.LCD_write_string(0,1,str1,0);
                                pc.printf("Mass 2 between 6 and 7 plate   = %.3f kg.\n",kilo_output2);
                                sprintf(str2,"Mass 2 on 6,7 plate = %.3f kg",kilo_output2);
                                lcd.LCD_write_string(0,2,str2,0);
                            } else if(module2>module1 && module2>module3) {
                                kilo_output1=module2+module4;
                                kilo_output2=module1+module3;
                                pc.printf("Mass 1 between 6 and 8 plate  = %.3f kg.\n",kilo_output1);
                                sprintf(str1,"Mass 1 on 6,8 plate = %.3f kg",kilo_output1);
                                lcd.LCD_write_string(0,1,str1,0);
                                pc.printf("Mass 2 between 5 and 7 plate  = %.3f kg.\n",kilo_output2);
                                sprintf(str2,"Mass 2 on 5,7 plate = %.3f kg",kilo_output2);
                                lcd.LCD_write_string(0,2,str2,0);
                            } else if(module3>module1 && module3>module2) {
                                kilo_output1=module3+module4;
                                kilo_output2=module1+module2;
                                pc.printf("Mass 1 between 7 and 8 plate  = %.3f kg.\n",kilo_output1);
                                sprintf(str1,"Mass 1 on 7,8 plate = %.3f kg",kilo_output1);
                                lcd.LCD_write_string(0,1,str1,0);
                                pc.printf("Mass 2 between 5 and 6 plate  = %.3f kg.\n",kilo_output2);
                                sprintf(str2,"Mass 2 on 5,6 plate = %.3f kg",kilo_output2);
                                lcd.LCD_write_string(0,2,str2,0);
                            } else {
                                pc.printf("Undefind weight (have 2 mass on 4 plate).\n");
                                lcd.LCD_write_string(0,1,"Undefind weight (have 2 mass on 4 plate).",0);
                                pc.printf("Mass 1 = 0 kg\nMass 2 = 0 kg\n");
                                lcd.LCD_write_string(0,2,"Mass 1 = 0 kg",0);
                                lcd.LCD_write_string(0,3,"Mass 2 = 0 kg",0);
                            }
                        }
                    }
                }
                else {
                    pc.printf("Kilogram of mass : 0 kg\n");
                    lcd.LCD_write_string(0,1,"Kilogram of mass : 0 kg",0);

                }
                if(pc.readable()) {
                    state_exit =1;
                    state_calibrate=0;
                    state_onemass=0;
                    state_multiple_mass=0;
                    state_select=0;
                }

            } 


        }
    


    Find_kg::Find_kg()
{
    poid[1]=0;
}
Find_kg::~Find_kg()
{

}
float Find_kg::find_kilo(float valeur,float valeurTare)
{
    poid[0] = abs(((float)valeur-(float)valeurTare)/143200);
    diff_poids= abs(poid[0] - poid[1]);
        diff_poids = abs(diff_poids);
        if(diff_poids > standard_poid && kilo==0)
        {     
        kilo = diff_poids * (float)5.5555556 ;
        }
        else if(poid[0] < standard_poid)
        {
        kilo=0;
        }
       poid[1]=poid[0]; 
    return kilo;
}