#include "mbed.h"
#include <string>
#include "lfCall.h" //Lost and Found Box Library for HTTP Req.
#define BUFFER_SIZE 100

int  count,ended,timeout;
Serial esp(D8, D2); //tx rx
Serial pc(USBTX, USBRX);
Timer t; //Timeout comparison for get reply ESP8266
char buf[1024]; //reply buffer for esp8266
int setupESP(string,string);
char snd[256];

void getDataHTTP(const char domain[],const char dir[],const char value[],char uid[] , char name[] ,char tel[]);


void SendCMD()
{
    esp.printf("%s", snd);
}


void getreply()
{    
    memset(buf, '\0', sizeof(buf));
    t.start();
    ended=0;count=0;
    while(!ended) {
        if(esp.readable()) {
            buf[count] = esp.getc();count++;
            }
        if(t.read() > timeout) {
                ended = 1;t.stop();t.reset();
            }
        }   
}              
 

int main()
{

    string ssid = "1544_2G";
    string pass = "fiborobot" ;
    esp.baud(9600);
    pc.baud(115200);


    pc.printf("Starting System...\n");

    if(setupESP(ssid,pass) == 1) {
        pc.printf("System connected to %s with %s as password\n",ssid.c_str(),pass.c_str());
        pc.printf("System Initialized :: ESP8266 Module Ready!\n");
        wait(2);
    }
    getreply();
    char name[20];
    char uid[20];
    char tel[10];
 
 
    getDataHTTP("192.168.1.88","/l-f-box/getdata.php?rfid=","1",name,uid,tel);
    pc.printf("after call function : \n");
    pc.printf("ID : %s\n",uid);
    pc.printf("Name : %s\n",name);
    pc.printf("Tel : %s\n",tel);


}

int setupESP(string ssid,string password)
{
    pc.printf("Sending Reset CMD\n");
    esp.printf("AT+RST\r\n"); /* reset module */
    wait(3);    
    
    esp.printf("AT+CWMODE=1\r\n"); /* configure as access point */
    timeout = 2;
    getreply();
    pc.printf(buf);
    /* Error checking is not required */
    
    pc.printf("Access Point List!\n");
    esp.printf("AT+CWLAP\r\n");
    timeout = 5;
    getreply();
    pc.printf(buf);
    wait(1);
    
    
    string buffer("AT+CWJAP=\"");
    buffer += ssid;
    buffer += "\",\"";
    buffer += password;
    buffer += "\"\r\n";
    
    esp.printf(buffer.c_str());
    timeout = 7;
    getreply();
    pc.printf(buf);
    wait(1);
    
    esp.printf("AT+CIPMUX=1\r\n");
    timeout =5;
    getreply();
    pc.printf("Open Multi Connection : %s\n",buf);
       wait(1);
       
       pc.printf("\n---------- Get IP's ----------\r\n");
    char aa[]= "AT+CIFSR\r\n";
    esp.printf(aa);
    timeout=4;
    getreply();
    pc.printf(buf);
 
    wait(1);
    
    return 1;
}


// domain : 192.168.1.88
// directory : /l-f-box/getdata.php?rfid=
// value : 1
void getDataHTTP(const char domain[],const char dir[],const char value[],char uid[] , char name[] ,char tel[]){
    
    pc.printf("Start HTTP Request\n");
    esp.printf("AT+CIPSTART=0,\"TCP\",\"%s\",80\r\n",domain);
    timeout=5;
    getreply();
    pc.printf(buf);
    
    wait(1);

    char cmd[128] = "GET http://";
    strcat(cmd,domain);
    strcat(cmd,dir);
    strcat(cmd,value);
    //="GET http://%s%s%s",domain,dir,value;
    char buffer[2] = "";
    strcat(cmd," HTTP/1.0\r\n\r\n");
    sprintf(buffer , "%d",strlen(cmd) );

    strcpy(snd,"AT+CIPSEND=0,");
    strcat(snd,buffer);
   strcat(snd,"\r\n");
    pc.printf("%d %d",strlen(cmd) ,strlen(snd));
    pc.printf(snd);
    pc.printf(cmd);


    SendCMD();
    timeout=5;
    getreply();
    pc.printf(buf);
    wait(2);
    
    pc.printf("Start point to url...\n");
    strcpy(snd,cmd);
    SendCMD();
    timeout=5;
    getreply();
    pc.printf(buf);
    char* data;
/*    char * uid;
    char * name;
    char * tel; 
*/
    data = strstr(buf,"</data>");
    data = data+7;
    data = strtok(data,";");
    strcpy(uid,data+2);
    //uid = data+2;
    data = strtok(NULL,";");
    strcpy(name,data+2);
    //name    = data+2;
    data = strtok(NULL,";");
    strcpy(tel,data+2);
   // tel = data+2;
    
    pc.printf("--Extract data from http--\n");

    pc.printf("ID : %s : %d\n",uid,strlen(uid));
    pc.printf("Name : %s : %d\n",name,strlen(name));
    pc.printf("Tel : %s : %d\n",tel,strlen(tel));

    esp.printf("AT+CIPCLOSE=0\r\n");
    timeout=5;
    getreply();
    pc.printf(buf);
}

