
#include "mbed.h"
#include "MCP4922.h"
#include <math.h>

MCP4922 MCP(SPI_MOSI, SPI_SCK,SPI_CS);  // MOSI, SCLK, CS
#define PI 3.14159265

long map(long x, long in_min, long in_max, long out_min, long out_max)
{
    return (x - in_min) * (out_max - out_min) / (in_max - in_min) + out_min;
}

/**** Main Function  ***/
int main(void)
{
    int zeta;
    MCP.frequency(500000);
    int timer = 200;
    uint16_t i=0;
    uint8_t state=0;
    while(1) {
        zeta = map(i,0,4096,0,180);
        if(i < 0x0FFF) {
            i = (i+1);

        } else {
            i=0;
            state = ~state;
        }
        if(state == 0) {
            MCP.writeA( 2047 * (sin(zeta*PI/180)+1) );
        } else {
            MCP.writeA(2047 * (sin (abs(360-zeta) *PI/180) +1) );
            //MCP.writeA(  ((~i)&&0x0FFF) * sin(zeta*(PI/180)));
        }
        
        wait_us(timer);
        /*
        if((i+1)*1.05 < 0x0FFF && state) {
            i= (i+1) * 1.05;

        } else if((i+1)*1.05< 0x0FFF && state == 0) {
            i= (i+1) * 1.05;
        } else {
            i=0;
            state = ~state;
        }
        zeta = map(i,0,4096,0,90);
        if(state ==0) {
            MCP.writeA(i);
        } else {
            MCP.writeA( ((~i))&0x0FFF);
        }
        if(i < 2048 && state) {
            wait_us(timer * sin((abs(1-zeta)) *(PI/180)));
        }else
        if(i< 0xFFF && state){
            wait_us(timer * sin(zeta *(PI/180)));

            }*/
    }
}