#include "mbed.h"
#include <string>

extern Serial pc;
extern Serial esp; //tx rx
int  count,ended,timeout;
char buf[1024]; //reply buffer for esp8266
char snd[256];
Timer t; //Timeout comparison for get reply ESP8266

void SendCMD()
{
    esp.printf("%s", snd);
}


void getreply()
{    
    memset(buf, '\0', sizeof(buf));
    t.start();
    ended=0;count=0;
    while(!ended) {
        if(esp.readable()) {
            buf[count] = esp.getc();count++;
            }
        if(t.read() > timeout) {
                ended = 1;t.stop();t.reset();
            }
        }   
}              
 

int setupESP(string ssid,string password)
{
    pc.printf("Sending Reset CMD\n");
    esp.printf("AT+RST\r\n"); /* reset module */
    wait(3);    
    
    esp.printf("AT+CWMODE=1\r\n"); /* configure as access point */
    timeout = 2;
    getreply();
    pc.printf(buf);
    wait(1);
    /* Error checking is not required */
    
    /*
    pc.printf("Access Point List!\n");
    esp.printf("AT+CWLAP\r\n");
    timeout = 5;
    getreply();
    pc.printf(buf);
    wait(1);
    */
    
    string buffer("AT+CWJAP=\"");
    buffer += ssid;
    buffer += "\",\"";
    buffer += password;
    buffer += "\"\r\n";
    
    esp.printf(buffer.c_str());
    timeout = 7;
    getreply();
    pc.printf(buf);
    wait(1);
    
    esp.printf("AT+CIPMUX=1\r\n");
    timeout =1;
    getreply();
    pc.printf("Open Multi Connection : %s\n",buf);
    wait(1);
       
       pc.printf("\n---------- Get IP's ----------\r\n");
    char aa[]= "AT+CIFSR\r\n";
    esp.printf(aa);
    timeout=1;
    getreply();
    pc.printf(buf);
 
    //wait(1);
    
    return 1;
}

//Domain 192.168.1.88
// directory : /l-f-box/getdata.php?check=1
void getStatus(const char domain[],const char dir[],char id[]){
    pc.printf("Start Get Status\n");
    esp.printf("AT+CIPSTART=0,\"TCP\",\"%s\",80\r\n",domain);
    timeout=1;
    getreply();
    pc.printf(buf);
    //wait(1);
    
    char cmd[128] = "GET http://";
    strcat(cmd,domain);
    strcat(cmd,dir);

    char buffer[2] = "";
    strcat(cmd," HTTP/1.0\r\n\r\n");
    sprintf(buffer , "%d",strlen(cmd) );

    strcpy(snd,"AT+CIPSEND=0,");
    strcat(snd,buffer);
   strcat(snd,"\r\n");
    SendCMD();
    timeout=1;
    getreply();
    pc.printf(buf);
    //wait(2);
    
    pc.printf("Start point to url...\n");
    strcpy(snd,cmd);
    SendCMD();
    timeout=2;
    getreply();
    pc.printf(buf);

    char* data2;
    pc.printf("Declare data2 \n");
    data2 = strstr(buf,"</st>");
    pc.printf("Strstr </st> : %s\n",data2);
    data2 = data2+6;
    pc.printf("Shift +5 : %s\n",data2);
    id[0] = data2[0];
    id[1] = data2[1];
    id[2] = '\0';
    pc.printf(id);

    pc.printf("--Extract status from http--\n");
    pc.printf("UID : %s\n",id);
        esp.printf("AT+CIPCLOSE=0\r\n");
    timeout=1;
    getreply();
    pc.printf(buf);
}


// domain : 192.168.1.88
// directory : /l-f-box/getdata.php?rfid=
// value : 1
void getDataHTTP(const char domain[],const char dir[],const char value[],char uid[] , char name[] ,char tel[]){
    
    pc.printf("Start HTTP Request\n");
    esp.printf("AT+CIPSTART=0,\"TCP\",\"%s\",80\r\n",domain);
    timeout=1;
    getreply();
    pc.printf(buf);
    
    //wait(1);

    char cmd[128] = "GET http://";
    strcat(cmd,domain);
    strcat(cmd,dir);
    strcat(cmd,value);
    //="GET http://%s%s%s",domain,dir,value;
    char buffer[2] = "";
    strcat(cmd," HTTP/1.0\r\n\r\n");
    sprintf(buffer , "%d",strlen(cmd) );

    strcpy(snd,"AT+CIPSEND=0,");
    strcat(snd,buffer);
   strcat(snd,"\r\n");
    pc.printf("%d %d",strlen(cmd) ,strlen(snd));
    pc.printf(snd);
    pc.printf(cmd);


    SendCMD();
    timeout=1;
    getreply();
    pc.printf(buf);
    //wait(1);
    
    pc.printf("Start point to url...\n");
    strcpy(snd,cmd);
    SendCMD();
    timeout=2;
    getreply();
    pc.printf(buf);
    char* data;

    data = strstr(buf,"</data>");
    data = data+7;
    data = strtok(data,";");
    strcpy(uid,data);
    data = strtok(NULL,";");
    strcpy(name,data);
    data = strtok(NULL,";");
    strcpy(tel,data);
    
    pc.printf("--Extract data from http--\n");

    pc.printf("ID : %s : %d\n",uid,strlen(uid));
    pc.printf("Name : %s : %d\n",name,strlen(name));
    pc.printf("Tel : %s : %d\n",tel,strlen(tel));

    esp.printf("AT+CIPCLOSE=0\r\n");
    timeout=1;
    getreply();
    pc.printf(buf);
}


//http://localhost/l-f-box/update.php?key=fra221a0636&uid=11&withdrawer=57340500000
void updateWithdrawer(const char domain[],const char dir[],char withdrawer[]){
    pc.printf("Start HTTP Request\n");
    esp.printf("AT+CIPSTART=0,\"TCP\",\"%s\",80\r\n",domain);
    timeout=1;
    getreply();
    pc.printf(buf);
    
    wait(1);

    char cmd[128] = "GET http://";
    strcat(cmd,domain);
    strcat(cmd,dir);
    strcat(cmd,"?key=fra221a0636");
    strcat(cmd,"&withdrawer=");
    strcat(cmd,withdrawer);
    
    //="GET http://%s%s%s",domain,dir,value;
    char buffer[2] = "";
    strcat(cmd," HTTP/1.0\r\n\r\n");
    sprintf(buffer , "%d",strlen(cmd) );

    strcpy(snd,"AT+CIPSEND=0,");
    strcat(snd,buffer);
   strcat(snd,"\r\n");
    pc.printf("%d %d",strlen(cmd) ,strlen(snd));
    pc.printf(snd);
    pc.printf(cmd);


    SendCMD();
    timeout=1;
    getreply();
    pc.printf(buf);
    wait(1);
    
        pc.printf("Start point to url...\n");
    strcpy(snd,cmd);
    SendCMD();
    timeout=3;
    getreply();
    pc.printf(buf);
}

//http://localhost/l-f-box/update.php?key=fra221a0636&uid=11&withdrawer=57340500000
void newDepositor(const char domain[],const char dir[],char depositor[]){
    pc.printf("Start HTTP Request\n");
    esp.printf("AT+CIPSTART=0,\"TCP\",\"%s\",80\r\n",domain);
    timeout=2;
    getreply();
    pc.printf(buf);
    
    wait(1);

    char cmd[128] = "GET http://";
    strcat(cmd,domain);
    strcat(cmd,dir);
    strcat(cmd,"?key=fra221a0636");
    strcat(cmd,"&depositor=");
    strcat(cmd,depositor);
    
    //="GET http://%s%s%s",domain,dir,value;
    char buffer[2] = "";
    strcat(cmd," HTTP/1.0\r\n\r\n");
    sprintf(buffer , "%d",strlen(cmd) );

    strcpy(snd,"AT+CIPSEND=0,");
    strcat(snd,buffer);
   strcat(snd,"\r\n");
    pc.printf("%d %d",strlen(cmd) ,strlen(snd));
    pc.printf(snd);
    pc.printf(cmd);


    SendCMD();
    timeout=1;
    getreply();
    pc.printf(buf);
    wait(1);
    
        pc.printf("Start point to url...\n");
    strcpy(snd,cmd);
    SendCMD();
    timeout=3;
    getreply();
    pc.printf(buf);
}