//Test of cheap 13.56 Mhz RFID-RC522 module from eBay
//This code is based on Martin Olejar's MFRC522 library. Minimal changes
//Adapted for Nucleo STM32 F401RE. Should work on other Nucleos too
//Connect as follows:
//RFID pins        ->  Nucleo header CN5 (Arduino-compatible header)
//----------------------------------------
//RFID IRQ=pin5    ->   Not used. Leave open
//RFID MISO=pin4   ->   Nucleo SPI_MISO=PA_6=D12
//RFID MOSI=pin3   ->   Nucleo SPI_MOSI=PA_7=D11
//RFID SCK=pin2    ->   Nucleo SPI_SCK =PA_5=D13
//RFID SDA=pin1    ->   Nucleo SPI_CS  =PB_6=D10 SlaveSelect
//RFID RST=pin7    ->   Nucleo         =PA_9=D8
//3.3V and Gnd to the respective pins                                                           
#include "mbed.h"
#include "MFRC522.h"
#include "NOKIA_5110.h" // Nucleo Pin for MFRC522 reset (pick another D pin if you need D8)
#define MF_RESET    D9
#include "speaker.h"
#include "myESP.h"
#include "myRFID.h"
#include "myLCD4884.h"
#include <ctype.h>
DigitalOut LedGreen(LED1); //RFID Status
DigitalOut spi_address[2] = {SPI_CS,PB_4}; //SPI Slave using... (RFID,LCD4884)
DigitalOut LDRstatus(D4); //Set enable LDR
AnalogIn LDR(A0);
double LDRref = 0.1000; //set LDR Threshold
//Serial connection to PC for output
Serial esp(D8, D2); //tx rx
Serial pc(SERIAL_TX, SERIAL_RX); //for debugging
Speakers speak(D3); //Buzzer setup
DigitalOut lock(PB_13); //Solenoid Control
MFRC522    RfChip   (SPI_MOSI, SPI_MISO, SPI_SCK, SPI_CS, MF_RESET); //RFID Setup
char buffers[5]={'\0'}; //Buffer
char IDs[17]={'\0'}; //IDs of RFID
char backupIDs[17]={'\0'}; //IDs of RFID

int ItemCheck(){
    pc.printf("Now LDR state : %lf",LDR.read());
    if(LDR.read() < LDRref){
        pc.printf("Item available\n");
        return 1; //Item Available
    }else
    pc.printf("Item unavailable\n");
    return 0; //Item Unavailable
}

void wifiInitial(){
       pc.baud(115200);
    esp.baud(9600);
    string ssid = "1544_2G";
    string pass = "fiborobot" ;

    if(setupESP(ssid,pass) == 1) {
        pc.printf("System connected to %s with %s as password\n",ssid.c_str(),pass.c_str());
        pc.printf("System Initialized :: ESP8266 Module Ready!\n");
        wait(2);
    }
}

int main(void) {
    LDRstatus =1;
    // Init. LCD Pin
    LcdPins myPins;      
    myPins.sce  = PB_4;  //D5 ActiveLow SlaveSelect
    myPins.rst  = PB_10; //D6
    myPins.dc   = PA_8;  //D7
    myPins.mosi = PA_7;  //SPI_MOSI;
    myPins.miso = NC;
    myPins.sclk = PA_5; //SPI_SCK;    
    
    // Init. LCD Chip
    NokiaLcd myLcd( myPins );
    myLcd.InitLcd();                // LCD is reset and DDRAM is cleared
    myLcd.DrawString("System Initializing...");   
    myLcd.stop();
    
    // Init. esp8266
    wifiInitial();
    char name[20];
    char sid[20];
    char tel[10];
    char stat_uid[3];
    
    // Init.RFID Variable
    uint8_t RFID[10];
    int mode = 0;
    int submode = 0;
    pc.printf("starting...\n");
    
    // Init. RC522 Chip
    RfChip.PCD_Init();
    pc.printf("Begin RFID!\n");
    
  /* ===== System Initialized ===== */
    myLcd.InitLcd();  
    myLcd.DrawString("Welcome to LOST & FOUND BOX V.1");   
    myLcd.stop();
    

    while(true){//Loop around
        wait(1);
        lock = 0; //Locked!


        getStatus("refinance-sogood.com","/secret/8266/getdata.php?check=1",stat_uid); //Recheck now status
            
        if(isalnum((int)stat_uid[0]) && ItemCheck()){ //Check status has an item AND item in the box
            mode = 0; //It have an item
            submode=-1;
        }else if(!ItemCheck()){
            mode = 1;  //Doesn't have an item
            submode=0; 
        }else
        {
            pc.printf("ERROR! Something went wrong... Maybe Item was stolen\n");    
            
            speak.speakWrong();
            wait(3);
        }


        
        while(mode == 0){ //Withdraw Process (Item in the box!)
            
            pc.printf("Withdraw process...");
             if(stat_uid[0] == 'X'){ //Unlocked!
                speak.speakRight();
                wait(0.5);
                myLcd.InitLcd();
                myLcd.SetXY(20,2);
                myLcd.DrawString("UNLOCKED!");
                myLcd.SetXY(16,2);
                myLcd.DrawString("TAP A CARD...");
                myLcd.stop(); 
                submode ++; 
             }else{
                wait(1);
                getStatus("refinance-sogood.com","/secret/8266/getdata.php?check=1",stat_uid); //Recheck now status
               
               //Check for now available card..
               if ( ! RfChip.PICC_IsNewCardPresent()) 
               {
                      wait_ms(500);
                      continue;
                }
                // Select one of the cards
                if( ! RfChip.PICC_ReadCardSerial())
                {
                      wait_ms(500);
                      continue;
                }
                GetID(RFID);
                pc.printf("Comparison old data %s , new %s",backupIDs,IDs);
                if(backupIDs[0] == IDs[0]){
                    if(backupIDs[1] == IDs[1]){
                    if(backupIDs[2] == IDs[2]){ 
                    pc.printf("Permission allow!\n");
                    stat_uid[0] = 'X'; //Force to unlock
                    speak.speak();
                    submode++;
                    }
            
                }
                }else{
                    pc.printf("Permission denied.\n");
                    speak.speakWrong();
                }
                
            }
            if(submode == 0){ //Get RFID for update withdrawer
                if ( ! RfChip.PICC_IsNewCardPresent())
                    {
                         wait_ms(500);
                        continue;
                     }
                    // Select one of the cards
                    if ( ! RfChip.PICC_ReadCardSerial())
                    {
                      wait_ms(500);
                      continue;
                    }
                    speak.speak();
                    wait(0.5);
                    myLcd.InitLcd();  
                    myLcd.DrawString("WAITING...");
                    myLcd.stop();  
                    GetID(RFID);
                    getDataHTTP("refinance-sogood.com","/secret/8266/getdata.php?rfid=",IDs,sid,name,tel); // Data of withdrawer
                    submode ++;    
            }
            if(submode == 1){
                    wait(0.5);
                    myLcd.InitLcd();  
                    myLcd.DrawString("PLEASE GET ITEM...");
                    myLcd.stop();  
                lock=1; // Unlocked
                while(ItemCheck()){
                    pc.printf("Waiting for withdraw item\n");
                    wait(1);    
                }
                    wait(0.5);
                    myLcd.InitLcd();  
                    myLcd.DrawString("PLEASE CLOSE THE DOOR");
                    myLcd.stop();  
                wait(6);
                updateWithdrawer("refinance-sogood.com","/secret/8266/update.php",sid);
                wait(0.5);
                myLcd.InitLcd();
                myLcd.SetXY(20,2);
                myLcd.DrawString("WITHDRAW");
                myLcd.SetXY(16,2);
                myLcd.DrawString("SUCCESSFUL");
                myLcd.stop();  
                submode++;
                }
            if(submode == 2){//Check for item & return to empty position
                    mode = -1;    
            }
        }
        while(mode == 1){ //Deposit Process (No item in the box)
        pc.printf("Deposition process \n");
            if(submode == 0){ //Ask for deposit
                myLcd.InitLcd();  
                myLcd.SetXY(20,1);
                myLcd.DrawString("PLEASE");   
                myLcd.SetXY(8,3);
                myLcd.DrawString("TAP A CARD");   
                myLcd.SetXY(9,5);
                myLcd.DrawString("TO DEPOSIT"); 
                myLcd.stop();
                submode++;
            }
            if(submode == 1){ //Wait and Get Tap Card
                if ( ! RfChip.PICC_IsNewCardPresent())
                {
                     wait_ms(500);
                    continue;
                 }
                // Select one of the cards
                if ( ! RfChip.PICC_ReadCardSerial())
                {
                  wait_ms(500);
                  continue;
                }
                speak.speak();
                submode ++;
            }
            if(submode == 2){ //Get depositor data. & Show depositor data
                lock=1;
                wait(0.5);
                myLcd.InitLcd();  
                myLcd.DrawString("WAITING...");
                myLcd.stop();  
                GetID(RFID);
                getDataHTTP("refinance-sogood.com","/secret/8266/getdata.php?rfid=",IDs,sid,name,tel);
                submode ++;
    
                wait(0.5);
                myLcd.InitLcd();  
                myLcd.DrawString("NAME : ");   
                            myLcd.SetXY(5,1);
    
                myLcd.DrawString(name);   
                myLcd.SetXY(0,3);
                myLcd.DrawString("TEL : ");   
                            myLcd.SetXY(5,4);
    
                myLcd.DrawString(tel);   
                myLcd.stop();        
            }
            if(submode == 3){ // Show depositor data on screen
                newDepositor("refinance-sogood.com","/secret/8266/update.php",sid);
                lock =1; //Unlocked the box!
                wait(0.5);
                myLcd.InitLcd();  
                myLcd.SetXY(20,1);
                myLcd.DrawString("PLEASE");   
                myLcd.SetXY(4,3);
                myLcd.DrawString("PUT THE ITEMS");   
                myLcd.stop();
                
                while(!ItemCheck()){ //Waiting for Item , Until it has an item...
                    pc.printf("Waiting for item...");
                    wait(0.5);
                }
               wait(0.5);
                myLcd.InitLcd();  
                myLcd.SetXY(20,1);
                myLcd.DrawString("PLEASE");   
                myLcd.SetXY(4,3);
                myLcd.DrawString("CLOSE THE DOOR");   
                myLcd.stop();
                wait(8);
                myLcd.InitLcd();  
                myLcd.SetXY(10,0);
                myLcd.DrawString("==CONTACT==");   
                    myLcd.SetXY(5,2);
                myLcd.DrawString("NAME : ");   
                            myLcd.SetXY(5,3);
    
                myLcd.DrawString(name);   
                myLcd.SetXY(0,4);
                myLcd.DrawString("TEL : ");   
                            myLcd.SetXY(5,5);
    
                myLcd.DrawString(tel);   
                myLcd.stop();
                strcpy(backupIDs,IDs);
                wait(3);
                submode=0; //Bring back submode value.
                mode = 0; //Bring to Item In Mode...
                lock = 0; //Locked!
            } // End Deposit Process
        }
        
    }
    
    
    
/*
    while (true) {
    LedGreen = 1;
    // Look for new cards
    if ( ! RfChip.PICC_IsNewCardPresent())
    {
      wait_ms(500);
      continue;
    }
    // Select one of the cards
    if ( ! RfChip.PICC_ReadCardSerial())
    {
      wait_ms(500);
      continue;
    }
    LedGreen = 0;
    myLcd.InitLcd();               
    myLcd.DrawString("Ready");   
    myLcd.stop();
    checker = check(RFID);    
    if(checks == 1)
        {
            if (checker == 1)
            {
                pc.printf("Right\n");
                myLcd.InitLcd();               
                myLcd.DrawString("Right"); 
                myLcd.stop();
                checks = 0;
                speak.speakRight();
                strcpy(IDs,"");
                continue;
            }
            else
            {
                pc.printf("Wrong!!\n");
                myLcd.InitLcd();               
                myLcd.DrawString("Wrong!!");   
                myLcd.stop();
                speak.speakWrong();
                continue;
            }
        }
    // Print Card UID
    pc.printf("Card UID: ");
    for (uint8_t i = 0; i < RfChip.uid.size; i++)
    {
      pc.printf(" %X", RfChip.uid.uidByte[i]);
    }
    checker = check(RFID);
    speak.speak();
    GetID(RFID);
    lock = 0;
    pc.printf("\n\r"); 
    wait_ms(1000);
    checks = 1;
    }
*/
}