#include "mbed.h"

//------------------------------------
// Hyperterminal configuration
// 9600 bauds, 8-bit data, no parity
//------------------------------------

//Serial pc(SERIAL_TX, SERIAL_RX);
Serial blue(PA_15,PB_7);

BusOut digit1(D13,D12,D11,D10);
BusOut digit2(D9,D8,D7,D6);
AnalogIn vin(A2);

Ticker VoltReading;

int segment(int numberic)
{
    //digit1 = numberic;
    //digit2 = numberic2;
    
    if(numberic > 9) {
        digit1 = numberic/10;
        digit2 = numberic%10;
     //   pc.printf("%d\n",numberic);
      //  pc.printf("%d\n",numberic%10);
        return 0;
    } else
        digit1 = 0;
    digit2 = numberic;
    
    return 0;
}

void voltRead(){
    float data = vin.read() * 3.3;
 //   pc.printf("Voltage : %f\n",data);
    int num1 = data*100.0;
//    pc.printf("Bluetooth : volt%d \n",num1);
    blue.printf("vt %d\n",num1);
}
int main()
{
   // pc.baud(115200);
    blue.baud(9600);
    VoltReading.attach(&voltRead,0.05);
    while(1) {
        if(blue.readable()) {
            if(blue.getc() == 's'){
                int data;
                blue.scanf("%d",&data);
             //   pc.printf("%d",data);
                segment(data);
            }
        }
    
    }
}
