#include "mbed.h"

//------------------------------------
// Hyperterminal configuration
// 9600 bauds, 8-bit data, no parity
//------------------------------------

Serial pc(SERIAL_TX, SERIAL_RX);

DigitalOut Out1(D13);
DigitalOut Out2(D12);
DigitalOut Out3(D11);
DigitalOut Out4(D10);
DigitalOut Out5(D9);
DigitalOut Out6(D8);
DigitalOut Out7(D7);
DigitalOut Out8(D6);

DigitalIn In(D3);
int min = 10;

void blinking(int min)
{
    Out1 = 1;
    Out2 = 1;
    Out3 = 1;
    Out4 = 1;
    Out5 = 1;
    Out6 = 1;
    Out7 = 1;
    Out8 = 1;
    wait_ms(min);
    Out1 = 0;
    Out2 = 0;
    Out3 = 0;
    Out4 = 0;
    Out5 = 0;
    Out6 = 0;
    Out7 = 0;
    Out8 = 0;
    wait_ms(min);
}
void follow(int min)
{
    Out8 = 1;
    wait_ms(min);
    Out8 = 0;
    wait_ms(min);
    Out7 = 1;
    wait_ms(min);
    Out7 = 0;
    wait_ms(min);
    Out6 = 1;
    wait_ms(min);
    Out6 = 0;
    wait_ms(min);
    Out5 = 1;
    wait_ms(min);
    Out5 = 0;
    wait_ms(min);
    Out4 = 1;
    wait_ms(min);
    Out4 = 0;
    wait_ms(min);
    Out3 = 1;
    wait_ms(min);
    Out3 = 0;
    wait_ms(min);
    Out2 = 1;
    wait_ms(min);
    Out2 = 0;
    wait_ms(min);
    Out1 = 1;
    wait_ms(min);
    Out1 = 0;
    wait_ms(min);
}
void led_off()
{
    Out1 = 0;
    Out2 = 0;
    Out3 = 0;
    Out4 = 0;
    Out5 = 0;
    Out6 = 0;
    Out7 = 0;
    Out8 = 0;
}


int main()
{

    uint8_t state_menu=0;
    uint8_t state_show=0;
    uint8_t state_exit =0;
    uint8_t data;
    uint8_t state_led = 0;

    while(1) {
        if(state_show == 0) {
            pc.printf("Menu\n");
            pc.printf("1.LED Mode\n");
            pc.printf("2.Digital Input Check\n");
            state_show =1;
        }
        if(pc.readable()) {
            data = pc.getc();
            pc.printf("\n");
            state_show =0;
            state_exit =0;

            switch(data) {
                case '1':
                    do {
                        if(state_menu == 0) {
                            pc.printf("LED Function\n");
                            pc.printf("a.Blinking\n");
                            pc.printf("d.Follow to right\n");
                            pc.printf("s.Stop\n");
                            state_menu = 1;
                        }
                        if(pc.readable()) {
                            if(state_menu == 0) {
                                pc.printf("LED Function\n");
                                pc.printf("a.Blinking\n");
                                pc.printf("d.Follow to right\n");
                                pc.printf("s.Stop\n");


                                state_menu = 1;
                            }
                            data = pc.getc();

                            state_menu=0;
                            do {
                                if(pc.readable()) {
                                    data =pc.getc();
                                }

                                switch(data) {

                                    case 'a':
                                        pc.printf("Blinking!\n");
                                        blinking(min*20);
                                        state_led = 1;
                                        break;

                                    case 'd':
                                        pc.printf("Follow Light! \n");
                                        follow(min);
                                        state_led = 1;
                                        break;

                                    case 's':
                                        led_off();
                                        state_led = 0;
                                        state_exit = 1;
                                        break;

                                    default:
                                        pc.printf("please select a or d\n");
                                        pc.printf("\n");
                                        break;
                                }
                            } while(state_led != 0);

                        }


                    } while(state_exit ==0);
                    pc.printf("\n\n");
                    break;

                case '2':
                    if(In == 0){
                        pc.printf("Switch is off\n");
                        }else
                        pc.printf("Switch is on\n");
            }
        }
    }
}
