#include "mbed.h"

AnalogIn analog_value(A0);

DigitalOut led(LED1);

int main()
{
    float meas_r;
    float meas_v;

    while(1) {

        meas_r = analog_value.read(); // Read the analog input value (value from 0.0 to 1.0 = full ADC conversion range)
        meas_v = meas_r * 3300; // Converts value in the 0V-3.3V range
        
        // LED is ON when the value is above 2V
        if (meas_v > 2000) {
            led = 1; // LED ON
        } else {
            led = 0; // LED OFF
        }

        wait(0.2); // 200 millisecond
    }
}
