#include "mbed.h"
/**********************
 *      MCP4922
 **********************/
 
///SPI Interface
SPI MCP4922_SPI(D11,D12,D13);//MOSI ,MISO ,SCK
DigitalOut MCP4922_CS(D10);//CS

//Digital Output
DigitalOut MCP4922_LDAC(D8);
DigitalOut MCP4922_SHDN(D9);

int main()
{
    /******************************
     *****      setup       *******
     ******************************/

    /////////setup SPI//////////
    //set CS High
    MCP4922_CS=1;

    //set SPI mode [1,1]=> mode 3 @16bit
    MCP4922_SPI.format(16,3);

    //set SPI Frequency @20MHz
    MCP4922_SPI.frequency(20000000);

    //set Load DAC High (inactive)
    MCP4922_LDAC = 1;

    //set shutdown DAC High (inactive)
    MCP4922_SHDN = 1;

    //loop
    while(1) {
        
        /******************************************************************************
         * Set DAC output channal A @ 2.5v  Vref = 3.3v , DAC 12 bit ,Gain =0, Unbuffer
         * So DAC data = 3103
         * SPI data format CH,BUF,GA,SHDN,DATA[12:0]
         ******************************************************************************/

        /////prepare Data to tranfer/////
        //create data buffer
        uint16_t MCP4922_Sent_Data = 0;

        //Set MCP4922_Sent_data[12:0] to expected DAC output
        MCP4922_Sent_Data = 3103 & 0x0FFF;

        //Set Channal to output A => CH = 0
        MCP4922_Sent_Data &= 0b0111111111111111;

        //Set Buffer mode to Unbuffer => BUF = 0
        MCP4922_Sent_Data &= 0b1011111111111111;

        //Set GAIN mode to 1 => GA = 1
        MCP4922_Sent_Data |= 0b0010000000000000;

        //Set Shutdown channal mode to inactive => SHDN = 1
        MCP4922_Sent_Data |= 0b0001000000000000;

        /////sent data to MCP4922/////
        //set CS to LOW to activated MCP4922 SPI Interface
        MCP4922_CS = 0;

        //sent data buffer to mcp4922
        MCP4922_SPI.write(MCP4922_Sent_Data);

        //set CS to High to End MCP4922 SPI Interface
        MCP4922_CS = 1;

        //set LDAC to LOW to Load data to output 
        MCP4922_LDAC = 0 ;
        
        //wait at least 100ns = 0.1 microsec ..... So set at 1 microsec
        wait_us(1);
        
        //set LDAC to High to prepare next output
        MCP4922_LDAC = 1 ;
        
    }
}
