#include "mbed.h"
#include "string"


Serial pc(D1,D0);   // Serial for pc (tx,rx)
Serial esp(D8,D2); // Serial for esp32 (tx, rx)

DigitalIn espStatus(D15);   // Digital In for checking ESP32 status

char buffer[128];   // Buffer for storing serial data 

/**************************** Begin ESP32 Function ********************************/
void SetSSID(char*);
void SetPassword(char*);
void SetChannelID(char*);
void SetAPIWrite(char*);
void SetAPIRead(char*);
void SetTotalField(char*);
/**************************** End ESP32 Function ********************************/

/************** Edit here: parameters for setting Wifi+thingspeak **************/
char ssid[] = "FIBO-Wifi";                  // Wifi Name
char password[] = "fibo@2538";           // Wifi Password 
char channelID[] = "570817";            // Your ThingSpeak channalID
char APIWrite[] = "DCXUGD222HXQAXP4";   // Your ThingSpeak APIWrite 
char APIRead[] = "XHQ9OWAS6KY6XBK6";    // Your ThingSpeak APIRead
char totalField[] = "3";                // Total number of fields in your ThingSpeak 
/***************************** End Gobal Variable *********************************/


int main() {
    // Init Serial 
    esp.baud(115200); 
    pc.baud(115200);
    wait_ms(2000);
    
    // Init ESP32    
    SetSSID(ssid);
    SetPassword(password);
    SetChannelID(channelID);
    SetAPIWrite(APIWrite);
    SetAPIRead(APIRead);
    SetTotalField(totalField);

    // Wait for ESP connect Internet
    pc.printf("Please Wait!!!\n\n\n");
    time_t seconds = time(NULL);
    while(espStatus==0){
        if(time(NULL) - seconds > 1){
            pc.printf(".");
            seconds = time(NULL);
        }
    }
    pc.printf("\n\n\nESP32 is Ready.\n\n");
    
    // Loop
    while(1) {
        if(pc.readable())
        {
            pc.scanf("%s",buffer);
            
            //Check if in Setting or Writing mode and all data are sent in collect protocol format 
            if((buffer[0]=='S' || buffer[0]=='W') && buffer[2]==':' &&buffer[strlen(buffer)-1]==';')
            {
                pc.printf("%s\n",(buffer[0]=='S')?"Setting":"Write");
                esp.printf("%s",buffer);
            } 
            else if(buffer[0]=='R' && buffer[2]==';')//Check if in Read mode and is in collect protocol format
            {
                pc.printf("Read : ");
                esp.printf("%s",buffer);
                while(!esp.readable());
                esp.scanf("%s",buffer);
                pc.printf("%s\n",buffer);
            }
            else
            {
                pc.printf("Invalid Syntax !!!\n");
            }    
        }
            
    }
} // End of main loop 


/************** Function Declaration ***********************/ 
void SetSSID(char *text){
    esp.printf("S1:");
    esp.printf("%s",text);
    esp.printf(";");
    pc.printf("SSID: %s\n",text);
}

void SetPassword(char *text){
    esp.printf("S2:");
    esp.printf("%s",text);
    esp.printf(";");
    pc.printf("Password: %s\n",text);
}

void SetChannelID(char *text){
    esp.printf("S3:");
    esp.printf("%s",text);
    esp.printf(";");
    pc.printf("ChannelID: %s\n",text);
}

void SetAPIWrite(char *text){
    esp.printf("S4:");
    esp.printf("%s",text);
    esp.printf(";");
    pc.printf("APIWrite: %s\n",text);
}

void SetAPIRead(char *text){
    esp.printf("S5:");
    esp.printf("%s",text);
    esp.printf(";");
    pc.printf("APIRead: %s\n",text);
}
void SetTotalField(char *text){
    esp.printf("S6:");
    esp.printf("%s",text);
    esp.printf(";");
    pc.printf("Number of Field: %s\n",text);
}