#include "mbed.h"
#include "MPU6050.h"
Serial pc(USBTX, USBRX);
MPU6050 MPU6050(D14, D15);
float aceleracao[3];
float giroscopio[3];
int giroscopio_raw[3];
int aceleracao_raw[3];

//----------Taxa de amostragem----------
Timer t_dados; // timer para taxa de aquisicao dos dados
Timer t_tempo;
Timer tempo;
Ticker clockzin;
int timer_ms;
int tx_aquisicao; //quantos pontos serao plotados em um segundo
int t_amostragem; //valor do timer do Main
int t_amostragem_tempo;
int tempo_ms;
int second = 0;
int minute = 0;
int hour = 0;

void relogio()
{
    timer_ms++;
}

int main()
{
    pc.baud(115200);
    tx_aquisicao = 80;
    t_dados.start();
    t_tempo.start();
    tempo.start();
    clockzin.attach(&relogio,0.001f);  //relogio
    pc.printf("Iniciando\r\n");

    if(MPU6050.testConnection() == 1) {

        pc.printf("MPU6050 - Status: OK\r\n");

    } else {

        pc.printf("MPU6050 - Status: Sem resposta \r\n");

    }

    MPU6050.setAcceleroRange(MPU6050_ACCELERO_RANGE_2G);
    MPU6050.setGyroRange(MPU6050_GYRO_RANGE_250);

    while (1) {

        t_amostragem = t_dados.read_us();
        t_amostragem_tempo = t_tempo.read_us();
        tempo_ms = tempo.read_ms();
        if (t_amostragem >= 1000000/tx_aquisicao) {
            t_dados.reset();
            MPU6050.getAccelero(aceleracao);
            MPU6050.getGyro(giroscopio);
            MPU6050.getGyroRaw(giroscopio_raw);
            MPU6050.getAcceleroRaw(aceleracao_raw);
//            pc.printf("Aceleracao-X=%0.5f, Aceleracao-Y=%0.5f, Aceleracao-Z=%0.5f,", aceleracao[0], aceleracao[1], aceleracao[2]);
//            pc.printf("Giroscopio-X=%0.5f,  Giroscopio-Y=%0.5f, Giroscopio-Z=%0.5f  \r\n", giroscopio[0], giroscopio[1], giroscopio[2]);
            pc.printf("AX%f, AY%f, AZ%f, GX%f, GY%f, GZ%f\n", aceleracao[0], aceleracao[1], aceleracao[2], giroscopio[0], giroscopio[1], giroscopio[2]);


        }

        if (timer_ms >999) {
            timer_ms = 0;
            second++;
        }
        if(second > 59) {
            second = 0;
            minute++;
        }

        if(minute > 59) {
            minute = 0;
            hour++;
        }
    }
} //teste