#include "mbed.h"
#include "BNO055.h"

#define taxa_de_amostragem 10 //100 Hz (10ms)

Serial pc (D1, D0); //Comunicação com USB TX, RX


BNO055 BNO055(D14, D15); //Define as portas SDA/SCL do BNO055
float aceleracao_linear[3];

Timer t_dados; // timer para taxa de aquisicao dos dados
int tx_aquisicao; //quantos pontos serao plotados em um segundo
int t_amostragem; //valor do timer do Main

Timer check_status;

void configuracao_BNO055(void);
void calibracao_BNO055(void);

int main()
{

    pc.baud(115200); //Define a velocidade da porta USB
    t_dados.start();
    tx_aquisicao = 100;
    configuracao_BNO055();
    calibracao_BNO055();


    while(1) {

        check_status.start();

        if (t_amostragem >= 1000000/tx_aquisicao % BNO055.check() == true) {
            t_dados.reset();
            BNO055.SetExternalCrystal(true); //Indica a existencia de um cristal externo
            BNO055.get_angles();
            BNO055.get_accel();
            aceleracao_linear[0] = BNO055.lia.x;
            aceleracao_linear[1] = BNO055.lia.y;
            aceleracao_linear[2] = BNO055.lia.z;
//            pc.printf("YAW= %f, ROLL= %f, PITCH= %f \r\n", BNO055.euler.yaw, BNO055.euler.roll, BNO055.euler.pitch);
            //pc.printf("%f,%f,%f \r\n", BNO055.euler.yaw, BNO055.euler.roll, BNO055.euler.pitch);

            //pc.printf("%f,%f,%f\n", aceleracao_linear[0], aceleracao_linear[1], aceleracao_linear[2]);
            pc.printf("AX= %f, AY= %f, AZ= %f \r\n", BNO055.accel.x, BNO055.accel.y, BNO055.accel.z);

            //pc.printf("Tempo= %d", check_status.read_ms());
            check_status.reset();

        } else {
            
            pc.printf("Status BNO055: %d\r\n", BNO055.check()); //Verifica se tem comunicação com o BNO055

            configuracao_BNO055();
            calibracao_BNO055();

        }


        //wait_ms(taxa_de_amostragem);

    }
}

void configuracao_BNO055()
{

    //============= Configurações iniciais no BNO055 ================
    BNO055.reset(); //Reseta o BNO055
    //pc.printf("Status BNO055: %d\r\n", BNO055.check()); //Verifica se tem comunicação com o BNO055
    wait_ms(650);
    BNO055.setpowermode(POWER_MODE_NORMAL); //Define o modo de alimentação do BNO055
    wait_ms(25); //Aguarda a troca de modo de alimentação
    BNO055.setmode(OPERATION_MODE_IMUPLUS); //Configura o modo padrão para iniciar a calibração
    wait_ms(25); //Aguarda o BNO055 trocar de modo de operação
    

//============= Unidade das variáveis do BNO055 ================
    BNO055.set_accel_units(MPERSPERS); // m/s2
    BNO055.set_anglerate_units(DEG_PER_SEC); // graus°/s
    BNO055.set_angle_units(DEGREES); // graus°
    BNO055.set_temp_units(CENTIGRADE); // °C
    BNO055.set_orientation(ANDROID); // Sentido de rotação ANDROID = Regra da mão direita

}

void calibracao_BNO055()
{

//=================== Calibração do BNO055 =====================
    BNO055.read_calibration_data(); //Calibração dos sensores
    wait_ms(10);
    BNO055.write_calibration_data(); //Calibração dos sensores
    wait_ms(10);
    BNO055.setmode(OPERATION_MODE_IMUPLUS); //Configura o mode de fusão entre acelerômetro e giroscópio taxa de atualização máxima: 100Hz
    wait_ms(25); //Aguarda o BNO055 trocar de modo de operação

}

    

