/*
Versuche um die 24. mal Problematik zu lösen:
1. Zeile einfügen:
------------code-----------
    RCC->APB1ENR |= 0x24000000;     // Enable Interface clock for DAC1 and DAC2
------------code-----------
2. Analog Ausgang anders programmieren Programmzeilen für die Registerprogrammierung entfernen
------------code-----------
aout1.write((512.0f*stellges_spannung+2047.0f)/4095.0f);
aout1.write(0.5);
------------code-----------
3. Zeilen entfernen:
------------code-----------
 AnalogOut aout(PA_4);  //A3 wird zunächst nicht gebraucht 
 AnalogOut aout1(PA_5); //A4 Ausgabespannung für Motor 1
 AnalogOut aout2(PA_6); //A5 Ausgabespannung für Motor 2
------------code-----------
4. ohne die spezifische Library sondern mit der gelieferten
mbed library
*/

#include "mbed.h"
#include "strdup.h"

//#include <stdio.h>

 Serial pc(SERIAL_TX, SERIAL_RX);
 
 Ticker regelung_strom;
 Ticker regelung_zustand;
 
 DigitalOut out5(PA_11);
 
 /*
 AnalogOut aout(PA_4);  //A3 wird zunächst nicht gebraucht 
 AnalogOut aout1(PA_5); //A4 Ausgabespannung für Motor 1
 AnalogOut aout2(PA_6); //A5 Ausgabespannung für Motor 2
 */
 
 AnalogIn ain1(PA_1);  //A0 Messung des Stromsensors von Motor 1
 AnalogIn ain2(PA_0);  //A1 Messung des Stromsensors von Motor 2
 AnalogIn ain4(PA_3);  //A2 Messung der Drehzahl von Motor 1 !!!!!!!!!!!!!!!!!!!! MOTOREN VERTAUSCHT
 AnalogIn ain3(PA_7);  //A6 Messung der Drehzahl von Motor 2
 
 unsigned int i;  
 unsigned int j;
 int Kennwert0, Kennwert1, Kennwert2, Kennwert3, Kennwert4;
 
 //**************************************************************//
 //Deklaration und Funktionen für Stromregelung                  //
 //**************************************************************//

 int Kp_strom = 0;
 int Ki_strom = 0;
 float Ta_strom = 0.0001;
 int sollstrom = 0; //gerade so kein drehen
 
 float meas1, meas2, ai_real1, ai_real2, stromwert1, stromwert2;
 float stellP_strom, stellI_strom_alt, stellI_strom, stellges_spannung;
 
 float stromsensor1(void);
 float stromsensor2(void);
 void pi_regler_strom(int, float);
 
 //void set_stellgroesse_spannung(float);
 
  //**************************************************************//
 //Deklaration und Funktionen für Drehzahlmessung                //
 //**************************************************************//

 float meas3, meas4, ai_real3, ai_real4, drehzahl1, drehzahl2;
 
 float drehzahlsensor1(void);
 float drehzahlsensor2(void);
 
  //**************************************************************//
 //Deklaration und Funktionen für die Zustandsregelung            //
 //**************************************************************//

 int K_faktor = 0;
 float Ta_zustand = 0.0001;
 int M_soll = 0;
 int M_stell = 0 ;
 void zustandsregler(float, float, float);

 //**************************************************************//
 //Deklaration und Funktionen für das Einlesen der Bytes         //
 //**************************************************************//
char a;
char c[99];
char *ptr;
char *ptr2=c;
char *my_tokens[10] = { 0 };
int parameter[10];
void read_parameter(void);

void regler_strom() {
 pi_regler_strom(sollstrom, stromsensor1());
 }

void regler_zustand() {
 zustandsregler(stromsensor1(), drehzahlsensor1(), drehzahlsensor2());
 }
 
int main () {
 pc.baud(9600);

 RCC->APB1ENR |= 0x24000000;    // Enable Clock for DAC
 GPIOA->MODER |= 0x00003f00;    // MODE PortA, PA4 PA5 & PA6 are analog!
 DAC->CR |= 0x00030003;         // DAC control reg, both channels ON
 DAC2->CR |= 0x00000003;        // DAC2 control reg channel 1 ON
 
 wait(0.1);
 
 regelung_zustand.attach(&regler_zustand,Ta_zustand);
//regelung_strom.attach(&regler_strom, Ta_strom);
 
 while (1) { // infinite loop
 read_parameter();
 }
}

float stromsensor1()
{
    meas1 = ain1.read();
    ai_real1 = 2.424242f*(meas1*3.3f)-4.0f;
    stromwert1 = ai_real1*1.25f;
    //printf("ADC Wert: %f reale Eingangsspannung vor OPV: %f V Stromwert Motor 1: %f A Durchschnitt Strom %f A\n", (meas1*3.3f), ai_real1, stromwert1, avg_stromwert);
    return stromwert1; //hier gehört stromwert1 herein
}

float stromsensor2()
{
    meas2 = ain2.read();
    ai_real2=6.06060606f*(meas2*3.3f)-10.0f;
    stromwert2 = 7.575757f*(meas2*3.3f)-12.5f;
    //printf("reale Eingangsspannung an Analog Input 2:%f Volt umgerechneter Strom Motor 2: %f Ampere \n", ai_real2, stromwert2);
    return stromwert2;
}

float drehzahlsensor1()
{
    meas3 = ain3.read();
    ai_real3=6.06060606f*(meas3*3.3f)-10.0f;
    drehzahl1 = ai_real3/4.0f;
    //printf("reale Eingangsspannung an Analog Input 3:%f Volt umgerechnete Drehzahl Motor 1: %f Hz \n", ai_real3, drehzahl1);
    return drehzahl1;
}

float drehzahlsensor2()
{
    meas4 = ain4.read();
    ai_real4=6.06060606f*(meas4*3.3f)-10.0f;
    drehzahl2 = ai_real4/4.0f;
    //printf("reale Eingangsspannung an Analog Input 4:%f Volt umgerechnete Drehzahl Motor 2: %f Hz \n", ai_real4, drehzahl2);
    return drehzahl2;
}

void zustandsregler(float strom, float dreh1, float dreh2) {
    M_stell = K_faktor*((int)(1000*dreh1-1000*dreh2));
    M_stell = M_stell/50;    
    pi_regler_strom(M_soll+M_stell, strom);
    }

void pi_regler_strom(int soll, float ist) {

    float regelabweichung_strom = 0;
    out5 = 1; 
    regelabweichung_strom = soll*0.01f - ist; 
    out5 = 0; 
    stellP_strom = Kp_strom*0.01f*regelabweichung_strom;
    
    stellI_strom_alt = stellI_strom;
    stellI_strom = Ki_strom*0.01f*Ta_strom*regelabweichung_strom+stellI_strom_alt;
    
    if (stellI_strom > 4.0f) {
        stellI_strom = 4.0f;
    }
    else if (stellI_strom < 0.0f) {
        stellI_strom = 0.0f;
    }
    stellges_spannung = stellP_strom + stellI_strom;
    if (stellges_spannung > 4.0f) {
        stellges_spannung = 4.0f;
        }
    else if (stellges_spannung < 0.0f) {
        stellges_spannung = 0.0f;
        }
    //return stellges_spannung;
    if (stellges_spannung >= 0) {
        DAC->DHR12R2=((int)(512.0f*stellges_spannung+2047.0f));
        }
    else {
         DAC->DHR12R2=2047;
         }
    //printf("soll strom: %f, iststrom: %f, regelabweichung: %f, stellP: %f, stellI_alt: %f, stellI: %f, Stellgroesse Spannung: %f \n", soll, ist, regelabweichung_strom, stellP_strom, stellI_strom_alt, stellI_strom, stellges_spannung);
           
}     

void read_parameter() {
    while (pc.readable()) {
    
        a = pc.getc();
 
        //if character is $ than it is the start of a sentence
        if (a == '$') {
            //b.clear();
            //c[0] = '\0';
            i=0; //write buffer character to big buffer string
        }
        //b += a;
        //c[i]=a;
     
        //if the character is # than the end of the sentence is reached and some stuff has to be done
        if (a == '#') 
        {
                //b.erase(0,1);
                //b.erase(b.length()-1,1);
                //rpm=atoi(b.c_str());  
                //pc.printf("String: %s \n Drehzahl: %d \n", b, rpm);
                c[0] = '0';
                ptr = strtok(c, ",");
                j=0;
                while(ptr != NULL)
                {
                    //my_tokens[j] = strdup(ptr);
                    // naechsten Abschnitt erstellen
                    parameter[j]=atoi(ptr);
                    printf("\n %d \n",parameter[j]);
                    ptr = strtok(NULL, ",");
                    //arrays[i]=str;
                    j++;
                }
                pc.putc('\n');
                Kp_strom = parameter[0];
                pc.putc('0');
                Ki_strom = parameter[1];
                pc.putc('1');
                sollstrom = parameter[2];
                pc.putc('2');
                K_faktor = parameter[3];
                pc.putc('3');
                M_soll = parameter[4];
                pc.putc('4');
                Kennwert0 = parameter[5];
                pc.putc('5');
                Kennwert1 = parameter[6];
                pc.putc('6');
                Kennwert2 = parameter[7];
                pc.putc('7');
                Kennwert3 = parameter[8];
                pc.putc('8');
                Kennwert4 = parameter[9];
                if (Kennwert4==66) {
                pc.putc('9');
                }
                a='\0';
                for(i=0; i<=99; i++) 
                {
                    c[i]='\0';
                }
        }
        c[i]=a;
        i++;
 
    }

}  
