#include "mbed.h"
 
//AnalogOut aout1(PA_5); //A4 Motor 1
//AnalogOut aout2(PA_6); //A5 Motor 2

InterruptIn rising2(D3); //Inkrementalgeber Spur A Motor 1
//DigitalIn direction2(D2); //Inkrementalgeber Spur B Motor 1
InterruptIn rising1(D8); //Inkrementalgeber Spur A Motor 2
//DigitalIn direction1(D9); //Inkrementalgeber Spur B Motor 2

Timer t1;   //Timer für den Inkrementalgeber des Motor 1

int t_period1 = 0;                  // This is the period between interrupts in microseconds
float t_freq1 = 0;                  // Umrechnung in Frequenz 
int calculation1;                   // Kennlinien Berechnung 
int calculation2;
int t_period2 = 0;                  // This is the period between interrupts in microseconds
float t_freq2 = 0;                  // Umrechnung in Frequenz 
int tneu1,tneu2, tdiff1, tdiff2, talt1, talt2;

void extTrigger1();
void extTrigger2();

int main()
{
    RCC->APB1ENR |= 0x24000000;     // Enable Interface clock for DAC1 and DAC2
    GPIOA->MODER |= 0x00003f00;     // MODE PortA, PA4 PA5 & PA6 are analog!
    DAC->CR |= 0x00030003;          // DAC control reg, both channels ON
    DAC2->CR |= 0x00000003;         // DAC2 control reg channel 1 ON
    
    wait(0.1);
    
    rising1.mode(PullDown);
    rising1.rise(&extTrigger1);
    rising2.mode(PullDown);
    rising2.rise(&extTrigger2);
    t1.start();
    
    while(1)
    {
        //printf("tdiff1: %d \n", tdiff1);
        //printf("tdiff2: %d \n", tdiff2);
        t_freq1 = (1.0/((float)tdiff1)*(1000000.0/256.0));
        t_freq2 = (1.0/((float)tdiff2)*(1000000.0/256.0));
        calculation1 = (((0.66f*t_freq1+1.65f)/3.3f)*4095.0f);
        if (calculation1 >= 4095) 
        {
            calculation1 = 4095;
        }
        DAC2->DHR12R1 = calculation1;
        //printf("Motor 1: %.2f Hz %i Bitwert\n",t_freq1, calculation1);
        
        calculation2 = (((0.66f*t_freq2+1.65f)/3.3f)*4095.0f);
        if (calculation2 >= 4095) 
        {
            calculation2 = 4095;
        }
        //printf("Motor 2: %.2f Hz %i Bitwert\n",t_freq2, calculation2);
       if (calculation2 >= 4095000){  printf("a");} //Printf Funktion wird gebracuht damit das Programm Ordnungsgemäß arbeitet
        DAC->DHR12R2 = calculation2;
        }                
}

void extTrigger1()
{
    tneu1 = t1.read_us();
    tdiff1 = tneu1 - talt1;
    //printf("tdiff1: %d \n", tdiff1);
    if (tdiff1 > 0)
    {
        talt1=tneu1;
    }
}

void extTrigger2()
{
    tneu2 = t1.read_us();
    tdiff2 = tneu2 - talt2;
    //printf("tdiff2: %d \n", tdiff2);
    if (tdiff2 > 0)
    {
        talt2=tneu2;
    }
}