#include "mbed.h"
#include "SDFileSystem.h"
#include "wave_player.h"
#include "Adafruit_LEDBackpack.h"
#include "Adafruit_GFX.h"
#include "rtos.h"
#include "FFT.h"
#include <string>
#include "around_the_world-atc-array.h"
#include "dont_speak-no_doubt-array.h"
#include "my-love-array.h"

SDFileSystem sd(p5, p6, p7, p8, "sd"); // SD card

I2C i2c(p28, p27); // LED display
Adafruit_8x8matrix matrix = Adafruit_8x8matrix(&i2c);

AnalogOut DACout(p18); // speaker
//PwmOut speaker(p21);
wave_player waver(&DACout);
//wave_player waver(speaker);
Mutex speaker_lock;
Mutex file_lock;
DigitalOut myled(LED1); // mbed LED
Serial pc (USBTX,USBRX);
string dir;         // "/sd/" + song + ".wav"
//string song = "around_the_world-atc";
string song;
int song_data_length;
const unsigned short *song_data;
bool play = false;
bool song_selected = false;


// delete later
/*int sample[12][8] = {
 34085,32666,29810,29823,27514,24175,24468,32559,
 36401,33075,29037,21933,20189,21751,20975,20087,
 17530,27723,30891,21128,19982,15446,12413,13597,
 15776,14233,15622,16334,15485,17136,16389,17954,
 20349,18486,23377,34447,34400,34681,33107,31171,
 30007,33640,37007,38136,39187,38169,51831,52041,
 47831,48634,44189,43878,44743,46468,43170,47172,
 53518,52294,54825,51992,49619,48147,47901,48413,
 46049,49090,47590,46154,45423,41223,41782,54695,
 57452,51210,52462,59096,56711,52268,49364,42865,
 41483,37964,39215,35908,31570,28332,24492,23121,
 22874,18154,15541,15263,12463,12198,13301,9951
};*/


#define BUFFER_SIZE 64

// states for display output
const int on[8][8] = {
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1
};

const int high[8][8] = {
    0, 0, 0, 1, 1, 0, 0, 0,
    0, 0, 0, 1, 1, 0, 0, 0,
    0, 0, 1, 1, 1, 1, 0, 0,
    0, 1, 1, 1, 1, 1, 1, 0,
    0, 1, 1, 1, 1, 1, 1, 0,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1
};

const int med[8][8] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 1, 1, 0, 0, 0,
    0, 0, 1, 1, 1, 1, 0, 0,
    0, 0, 1, 1, 1, 1, 0, 0,
    0, 1, 1, 1, 1, 1, 1, 0,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1
};

const int low[8][8] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 1, 1, 1, 1, 0, 0,
    0, 1, 1, 1, 1, 1, 1, 0,
    1, 1, 1, 1, 1, 1, 1, 1
};

const int off[8][8] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0
};




void display_fft(float sample[])
{

    int state = 0;
    float freq = 0;
    matrix.begin(0x70);

        
    
    //calculates FFT value of passed in array
    //Value scaled down by 4 for visualization
    freq = sample[1]/4;


    //pc.printf("%f\n",freq);

    // determine state based on the FFT output range
    if (freq < 10000) {
        state = 5; // OFF
    } else if (freq >= 10000 && freq < 25000) {
        state = 4; // LOW
    } else if (freq >= 25000 && freq < 40000) {
        state = 3; // MED
    } else if (freq >= 40000 && freq < 55000) {
        state = 2; // HIGH
    } else if (freq >= 55000) {
        state = 1; // ON
    }

    // switch statement based on the state
    switch (state) {
        case(1): // CASE HIGHEST
            matrix.clear();
            for (int i = 0; i < 8; i++) {
                for (int j = 0; j < 8; j++) {
                    if (on[i][j] == 1) {
                        matrix.drawPixel(i, j, LED_ON);
                    }
                }
            }
            matrix.writeDisplay();
            Thread::wait(10);
            //wait(.15);
            break;

        case(2): // CASE HIGH
            matrix.clear();
            for (int i = 0; i < 8; i++) {
                for (int j = 0; j < 8; j++) {
                    if (high[i][j] == 1) {
                        matrix.drawPixel(i, j, LED_ON);
                    }
                }
            }
            matrix.writeDisplay();
            Thread::wait(10);
            //wait(.15);



        case(3): // CASE MEDIUM
            matrix.clear();
            for (int i = 0; i < 8; i++) {
                for (int j = 0; j < 8; j++) {
                    if (med[i][j] == 1) {
                        matrix.drawPixel(i, j, LED_ON);
                    }
                }
            }
            matrix.writeDisplay();
            Thread::wait(10);
            //wait(.15);
            break;

        case(4): // CASE LOW
            matrix.clear();
            for (int i = 0; i < 8; i++) {
                for (int j = 0; j < 8; j++) {
                    if (low[i][j] == 1) {
                        matrix.drawPixel(i, j, LED_ON);
                    }
                }
            }
            matrix.writeDisplay();
            Thread::wait(10);
            break;

        case(5): // CASE OFF
            matrix.clear();
            for (int i = 0; i < 8; i++) {
                for (int j = 0; j < 8; j++) {
                    if (off[i][j] == 1) {
                        matrix.drawPixel(i, j, LED_ON);
                    }
                }
            }
            matrix.writeDisplay();
            Thread::wait(10);
            //wait(.15);
            break;

        default:
            break;
    }


}

//Reads SD card and passes value to frequency display
void display_thread(void const* args)
{
    while(1) {
        
        //Buffer which will hold 64 values
        float buffer[BUFFER_SIZE];
        //index for iteratiing through buffer
        int buffer_index = 0;
        //index for iterating through song array
        int song_array_index = 0;
        if(play) {
            //int num_elements = NUM_ELEMENTS_AROUND_THE_WORLD;
            while(play && song_array_index < song_data_length) {
                buffer[buffer_index] = song_data[song_array_index];
                song_array_index++;
                // pc.printf("%f", buffer[buffer_index]);
                buffer_index++;
                //pc.printf("%d\n",value);
                //buffer_index++;
                if(buffer_index == BUFFER_SIZE) {
                    //fast fourier tranform function here
                    vRealFFT(buffer, 4);
                    display_fft(buffer);
                    buffer_index = 0;
                    memset(buffer,0,sizeof(buffer));

                }

            }
        }
        Thread::wait(300);
    }

}

void speaker_thread(void const* args)
{
    while(1) {
        // check helper function for new song in GUI
        // grab file here and put together string
        // string song_title = "/sd/" + "" + ".wav";


        if(play == true && song_selected == true) {
            speaker_lock.lock();
            FILE *wave_file;
            dir = "/sd/" + song + ".wav";

            file_lock.lock();
            wave_file=fopen(dir.c_str(),"r");
            if(wave_file == NULL)
            {
                pc.printf("Error opening music file\n");
                }
            file_lock.unlock();

            waver.play(wave_file);

            file_lock.lock();
            fclose(wave_file);
            file_lock.unlock();
            play = false;
            myled = 0;
            speaker_lock.unlock();
        } 
        Thread::wait(1000);
    }

}


int main()
{
    //starting thread
    Thread th1(speaker_thread);
    Thread th2(display_thread);
    
    
    char c;
    while(1) {
        while(!pc.readable()) {
            Thread::wait(1);
        }
        
        //selects the song
        if (pc.getc() == '!') {
            c = pc.getc();
            switch(c) {
                /*
                case '1':
                    song = "africa-toto";

                    break;
                */
                case '2':
                    song = "around_the_world-atc";
                    song_data_length = NUM_ELEMENTS_AROUND_THE_WORLD;
                    song_data = data_around_the_world;
                    song_selected = true;
                    //play = true;
                    break;
                    
                /*
                case '3':
                    song = "beautiful_life-ace_of_base";
                    break;
                */
                
                
                case '4':
                    song = "dont_speak-no_doubt";
                    song_data_length = NUM_ELEMENTS_DONT_SPEAK_NO_DOUBT;
                    song_data = data_dont_speak_no_doubt;
                    song_selected = true;
                    break;
                case '5':
                    song = "my-love";
                    song_data_length = NUM_ELEMENTS_MY_LOVE;
                    song_data = data_my_love;
                    song_selected = true;
                    break;
                
                /*
                case '6':
                    song = "Song1_test";
                    break;
                */
                
                case 'P':
                    // wave_player plays
                    play = true;
                    myled =1;
                    break;
                case 'S':
                    // wave_player stops
                    play = false;
                    myled = 0;
                    break;
                default:
                    break;
            }
        }
        Thread::wait(100);
    }

}