#include "mbed.h"
#include "SDFileSystem.h"
#include "wave_player.h"
#include "Adafruit_LEDBackpack.h"
#include "Adafruit_GFX.h"
#include "rtos.h"
#include "FFT.h"
#include <string>

SDFileSystem sd(p5, p6, p7, p8, "sd"); // SD card

I2C i2c(p28, p27); // LED display
Adafruit_8x8matrix matrix = Adafruit_8x8matrix(&i2c);

AnalogOut DACout(p18); // speaker
wave_player waver(&DACout);
Mutex speaker_lock;
DigitalOut myled(LED1); // mbed LED
Serial pc (USBTX,USBRX);
string dir;         // "/sd/" + song + ".wav"
string song;
bool play;

<<<<<<< working copy
#define BUFFER_SIZE 50

// delete later
/*int sample[12][8] = {
 34085,32666,29810,29823,27514,24175,24468,32559,
 36401,33075,29037,21933,20189,21751,20975,20087,
 17530,27723,30891,21128,19982,15446,12413,13597,
 15776,14233,15622,16334,15485,17136,16389,17954,
 20349,18486,23377,34447,34400,34681,33107,31171,
 30007,33640,37007,38136,39187,38169,51831,52041,
 47831,48634,44189,43878,44743,46468,43170,47172,
 53518,52294,54825,51992,49619,48147,47901,48413,
 46049,49090,47590,46154,45423,41223,41782,54695,
 57452,51210,52462,59096,56711,52268,49364,42865,
 41483,37964,39215,35908,31570,28332,24492,23121,
 22874,18154,15541,15263,12463,12198,13301,9951
};*/
=======
#define BUFFER_SIZE 64
>>>>>>> merge rev

// states for display output
const int on[8][8] = {
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1
};

const int high[8][8] = {
    0, 0, 0, 1, 1, 0, 0, 0,
    0, 0, 0, 1, 1, 0, 0, 0,
    0, 0, 1, 1, 1, 1, 0, 0,
    0, 1, 1, 1, 1, 1, 1, 0,
    0, 1, 1, 1, 1, 1, 1, 0,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1
};

const int med[8][8] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 1, 1, 0, 0, 0,
    0, 0, 1, 1, 1, 1, 0, 0,
    0, 0, 1, 1, 1, 1, 0, 0,
    0, 1, 1, 1, 1, 1, 1, 0,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1
};

const int low[8][8] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 1, 1, 1, 1, 0, 0,
    0, 1, 1, 1, 1, 1, 1, 0,
    1, 1, 1, 1, 1, 1, 1, 1
};

const int off[8][8] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0
};



<<<<<<< working copy
void display_fft(int sample[])
{

=======
void display_fft(float sample[]) {
    
>>>>>>> merge rev
    int state = 0;
    float freq = 0;
    matrix.begin(0x70);
<<<<<<< working copy

    for (int a = 0; a < 50; a++) {

        freq = sample[a];

=======
    
    int s = sizeof(sample);
    
    pc.printf("%d\n", s);
    
    for (int a = 0; a < 64; a++) {
            
        freq = sample[a];
        
        pc.printf("%f\n",freq);
        
>>>>>>> merge rev
        // determine state based on the FFT output range
        if (freq < 10000) {
            state = 5; // OFF
        } else if (freq >= 10000 && freq < 25000) {
            state = 4; // LOW
        } else if (freq >= 25000 && freq < 40000) {
            state = 3; // MED
        } else if (freq >= 40000 && freq < 55000) {
            state = 2; // HIGH
        } else if (freq >= 55000) {
<<<<<<< working copy
            state = 1; // ON
        }

=======
            state = 1; // HIGHEST
        } 
        
>>>>>>> merge rev
        // switch statement based on the state
        switch (state) {
            case(1): // CASE HIGHEST
                matrix.clear();
                for (int i = 0; i < 8; i++) {
                    for (int j = 0; j < 8; j++) {
                        if (on[i][j] == 1) {
                            matrix.drawPixel(i, j, LED_ON);
                        }
                    }
                }
                matrix.writeDisplay();
                wait(.2);
                break;

            case(2): // CASE HIGH
                matrix.clear();
                for (int i = 0; i < 8; i++) {
                    for (int j = 0; j < 8; j++) {
                        if (high[i][j] == 1) {
                            matrix.drawPixel(i, j, LED_ON);
                        }
                    }
                }
                matrix.writeDisplay();
<<<<<<< working copy
                wait(1);

=======
                wait(.2);
        
>>>>>>> merge rev
            case(3): // CASE MEDIUM
                matrix.clear();
                for (int i = 0; i < 8; i++) {
                    for (int j = 0; j < 8; j++) {
                        if (med[i][j] == 1) {
                            matrix.drawPixel(i, j, LED_ON);
                        }
                    }
                }
                matrix.writeDisplay();
                wait(.2);
                break;

            case(4): // CASE LOW
                matrix.clear();
                for (int i = 0; i < 8; i++) {
                    for (int j = 0; j < 8; j++) {
                        if (low[i][j] == 1) {
                            matrix.drawPixel(i, j, LED_ON);
                        }
                    }
                }
                matrix.writeDisplay();
                wait(.2);
                break;

            case(5): // CASE OFF
                matrix.clear();
                for (int i = 0; i < 8; i++) {
                    for (int j = 0; j < 8; j++) {
                        if (off[i][j] == 1) {
                            matrix.drawPixel(i, j, LED_ON);
                        }
                    }
                }
                matrix.writeDisplay();
                wait(.2);
                break;

            default:
                break;
        }
<<<<<<< working copy


    }

=======
        
        pc.printf("done");
    
>>>>>>> merge rev
}

//Reads SD card and passes value to frequency display
void display_thread(void const* args)
{
    FILE *fp = fopen("/sd/africa-toto-array.txt","r");
    if(fp == NULL) {
        pc.printf("Error opening file\n");
        return;
    }
<<<<<<< working copy

    int buffer[BUFFER_SIZE];
=======
    
    float buffer[BUFFER_SIZE];
>>>>>>> merge rev
    int buffer_index = 0;
    int value;
<<<<<<< working copy
    pc.printf("Thread start\n");
    while(fscanf(fp,"%d,",&value) == 1) {
        buffer[buffer_index] = value;
        buffer_index++;
        pc.printf("%d\n",value);
        buffer_index++;
        if(buffer_index == BUFFER_SIZE) {
            //fast fourier tranform function here
            display_fft(buffer);
            buffer_index = 0;
            memset(buffer,0,sizeof(buffer));

        }
=======

    while(fscanf(fp,"%d,",&value) == 1){
           buffer[buffer_index] = (float)value;
           buffer_index++;
           //pc.printf("%d\n",value);
           //buffer_index++;
           if(buffer_index == BUFFER_SIZE)
           {
               //fast fourier tranform function here
               vRealFFT(buffer, 4);
               display_fft(buffer);
               buffer_index = 0;
               memset(buffer,0,sizeof(buffer));
               
           }
>>>>>>> merge rev
    }

    fclose(fp);
}

void speaker_thread(void const* args)
{
    while(1) {
        // check helper function for new song in GUI
        // grab file here and put together string
        // string song_title = "/sd/" + "" + ".wav";


        /*
        FILE *wave_file;
        dir = "/sd/" + song + ".wav";
        wave_file=fopen(dir.c_str(),"r");

        speaker_lock.lock();
        if (play)
        {
            waver.play(wave_file);
        }
        speaker_lock.unlock();
        fclose(wave_file);
        Thread::wait(100);
        */
    }
}


int main()
{

    Thread th1(speaker_thread);
    Thread th2(display_thread);
    char c;
    while(1) {
        myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.2);
        while(!pc.readable()) {
            Thread::wait(1);
        }
        if (pc.getc() == '!') {
            c = pc.getc();
            switch(c) {
                case '1':
                    song = "africa-toto";
                    break;
                case '2':
                    song = "around_the_world-atc";
                    break;
                case '3':
                    song = "beautiful_life-ace_of_base";
                    break;
                case '4':
                    song = "dont_speak-no_doubt";
                    break;
                case '5':
                    song = "my-love";
                    break;
                case '6':
                    song = "Song1_test";
                    break;
                case 'P':
                    // wave_player plays
                    play = true;
                    break;
                case 'S':
                    // wave_player stops
                    play = false;
                    break;
                default:
                    break;
            }
        }
        Thread::wait(100);
    }

}