#include "mbed.h"                                                                                                                                        #include "mbed.h"
#include "uw.h"

CAN can1(PA_11,PA_12,1000000);//ピン宣言
//CAN can1(p30,p29,1000000);
DigitalOut led(LED1);
Ticker ticker;//タイマー割り込み
char can_data[8] = {0}; //CAN送信用の配列

Uw uw1(PF_0); //機体背面の超音波センサー（三宝アーム側)PF_1
Uw uw2(PF_1); //機体正面の超音波センサー（果物アーム側)PF_0
Uw uw3(PA_0); //機体左側の超音波センサーPB_4
Uw uw4(PB_4); //機体右側の超音波センサーPA_0

char can_data1[2]= {0,0};
char can_data2[2]= {0,0};
char can_data3[2]= {0,0};
char can_data4[2]= {0,0};

int data1,data2;
int dataA, dataB, dataC, dataD;

void can_send()
{
    printf("start\n\r");
    //printf("%fcm\r\n",uw1.get_dist());

    dataA = (short)(100 * uw1.get_dist()); //超音波センサーの値を1000倍して送る（受信側で0.001倍して元に戻す）
    dataB = (short)(100 * uw2.get_dist());
    dataC = (short)(100 * uw3.get_dist());
    dataD = (short)(100 * uw4.get_dist());

    can_data1[0] = dataA >> 8;
    can_data1[1] = dataA &255;

    can_data2[0] = dataB >> 8;
    can_data2[1] = dataB &255;

    can_data3[0] = dataC >> 8;
    can_data3[1] = dataC &255;

    can_data4[0] = dataD >> 8;
    can_data4[1] = dataD &255;

    if(can1.write(CANMessage(3,can_data1,2))) {
        led = 1;
        //printf("%fcm\r\n",uw1.get_dist());
        //printf("send\n\r");
    } else {
        printf("uw1 not send\n\r");
    }

    if(can1.write(CANMessage(4,can_data2,2))) {
        led = 1;
        //printf("%fcm\r\n",uw2.get_dist());
        //printf("send\n\r");
    } else {
        printf("uw2 not send\n\r");
    }



    if(can1.write(CANMessage(6,can_data4,2))) {
        led = 1;
        //printf("%fcm\r\n",uw4.get_dist());
        //printf("send\n\r");
    } else {
        printf("uw4 not send\n\r");
    }

    if(can1.write(CANMessage(5,can_data3,2))) {
        led = 1;
        //printf("%fcm\r\n",uw3.get_dist());
        //printf("send\n\r");
    } else {
        printf("uw3 not send\n\r");
    }
    printf("uw1=%f uw2=%f  uw3=%f uw4=%f\n\r",uw1.get_dist(),uw2.get_dist(),uw3.get_dist(),uw4.get_dist());

    /*動確用プログラム

    data1 = 500;
    can_data[0] = data1>>8;
    can_data[1] = data1&255;

    if(can1.write(CANMessage(1,can_data,2))) { //IDを1にして送信
        led = 1;//送信時にLED1を点灯
        printf("send\n\r");
    } else {
        printf("not send\n\r");
    }*/
}

int main()
{
    can1.frequency(1000000);
    //can1.frequency(10000);
    ticker.attach(&can_send,0.01);  //can_send関数に0.001秒間隔で割り込み
    while(1);
}