#include <mbed.h>
#include "EC.h"
#include "R1370P.h"
#include "move4wheel.h"
#include "PathFollowing.h"
#include "Maxon_setting.h"
#include "Harurobo_CAN.h"

#define PROGRAM_INFO //プログラム使用時に使用プログラムの情報を最初に表示する際に定義

#define HARUROBO_TEST_MODE //テスト自動プログラム（練習・動作確認用）使用時に定義
//#define HARUROBO_RIGHT_MODE //本番用自動プログラム（右側フィールド）使用時に定義
//#define HARUROBO_LEFT_MODE //本番用自動プログラム（左側フィールド）使用時に定義

Ticker ticker;

//////////////////////////////////////////////////////////////以下main文/////////////////////////////////////////////////////////////////

int main()
{
      UserLoopSetting(); //Maxon関連設定関数
      UserLoopSetting2(); //PathFollowing関連設定関数
      
#ifdef PROGRAM_INFO //プログラム使用時に使用プログラムの情報を最初に表示

  printf("ソースファイル名 : %s\n\r", __FILE__);
  printf("作成日付 : %s\n\r", __DATE__);
  printf("作成時刻 : %s\n\r", __TIME__); //イギリスの時間（9時間前）の時間が表示される。
  
#endif
      
      
      

/////////////以下自動モードプログラム/////////////

#ifdef HARUROBO_TEST_MODE //テスト自動プログラム（練習・動作確認用）

      //Debug_Control();
    
      gogo_straight(1,1,0,0,0,-300,200,1000,5,0.1,10,0.1,600,0);
      purecurve2(6,1,1,0,-300,-600,-1000,9,1000,5,0.1,10,0.1,600,0);
      purecurve2(5,1,1,-600,-1000,-1200,-1700,9,1000,5,0.1,10,0.1,600,0);
      gogo_straight(1,1,-1200,-1700,-1200,-2000,1000,200,5,0.1,10,0.1,600,0);
      MotorControl(0,0,0,0);
      pos_correction(-1200,-2000,0,1,1);
      wait(0.5);

      gogo_straight(1,1,-1200,-2000,-1200,-1700,200,1000,5,0.1,10,0.1,600,0);
      purecurve2(2,1,1,-1200,-1700,-600,-1000,9,1000,5,0.1,10,0.1,600,0);
      purecurve2(1,1,1,-600,-1000,0,-300,9,1000,5,0.1,10,0.1,600,90);
      gogo_straight(1,1,0,-300,0,300,1000,200,5,0.1,10,0.1,600,90);
      MotorControl(0,0,0,0);
      pos_correction(0,300,90,1,1);
      
      gogo_straight(1,1,0,300,-200,300,200,200,5,0.1,10,0.1,800,90);
      MotorControl(0,0,0,0);
      pos_correction(-200,300,90,1,1);
      wait(0.5);
      
      gogo_straight(1,1,-200,300,0,600,200,1000,5,0.1,10,0.1,800,90);
      purecurve2(3,1,1,0,600,-400,1000,9,1000,5,0.1,10,0.1,800,90);
      purecurve2(4,1,1,-400,1000,-800,1400,9,1000,5,0.1,10,0.1,800,90);
      purecurve2(2,1,1,-800,1400,-400,1800,9,1000,5,0.1,10,0.1,800,90);
      gogo_straight(1,1,-400,1800,-300,1800,1000,1000,5,0.1,10,0.1,800,90);
      gogo_straight(1,1,-300,1800,0,1800,1000,200,5,0.1,10,0.1,800,90);
      MotorControl(0,0,0,0);
      pos_correction(0,1800,90,1,1);
      wait(0.5);
      
      gogo_straight(1,1,0,1800,-300,1800,200,1000,5,0.1,10,0.1,800,90);
      gogo_straight(1,1,-300,1800,-900,1800,1000,1000,5,0.1,10,0.1,800,90);
      purecurve2(5,1,1,-900,1800,-1300,1400,9,1000,5,0.1,10,0.1,600,180);
      gogo_straight(1,1,-1300,1400,-1300,900,1000,1000,5,0.1,10,0.1,600,180);
      gogo_straight(1,1,-1300,900,-1300,600,1000,200,5,0.1,10,0.1,800,180);
      MotorControl(0,0,0,0);
      pos_correction(-1300,600,180,1,1);
      
      
      //ticker.attach(&can_read,0.01);
       
     //can_start();
     //set_cond(1,0,0,1,-1000);
     //gogo_straight(1,1,0,0,0,-300,500,500,5,0.1,10,0.1,600,0);
     //pos_correction(100,0,0,1,1);
      //{

//while(1);

   // MotorControl(0,0,0,0);

#endif 


#ifdef HARUROBO_RIGHT_MODE //本番用自動プログラム（右側フィールド用）

//ここに本番用自動プログラム（右側フィールド用）を書く

#endif


#ifdef HARUROBO_LEFT_MODE //本番用自動プログラム（左側フィールド用）

//ここに本番用自動プログラム（左側フィールド用）を書く

#endif 


/////////自動モードプログラム終了/////////

}