#include "mbed.h"
#include "EC.h"

DigitalOut can_led(LED1);

PwmOut motorRF(PB_4);
PwmOut motorRB(PB_5);
PwmOut motorLF(PA_8);
PwmOut motorLB(PF_0);
PwmOut motorCF(PB_6);
PwmOut motorCB(PB_0);  //謎仕様のため変更

/*PA_2, PB_3 は使えない.  ・PB_7 と PA_5, PB_6 と PA_6 がつながっている.*/

Ec ECR(PA_5,PA_4,NC,500,0.05);
Ec ECL(PA_3,PA_1,NC,500,0.05);
//Ec ECC(PA_0,PB_3,NC,500,0.05);

//-----電磁弁-------------------------//
DigitalOut armR(PF_1);
DigitalOut armL(PA_10);
DigitalOut sanpou(PA_9);
DigitalOut under_sanpou(PA_7);
DigitalOut above_sanpou(PB_1);
//-----タッチセンサ--------------------//
DigitalIn touch(PA_0,PullUp);
//-----------------------------------//

int distR=0,distL=0,distC=0;
int timerstop=0,stopcount=0;
double second=0;

Serial pc(USBTX, USBRX);

CAN can1(PA_11,PA_12,1000000);
Ticker can_ticker;
Timer timer;

int id2_value[9]= {0};

char t2[1]={0}; //動作番号（送信する値（char型））
int t2_r = 0, T2=0; //動作番号（受け取った値、送信する値（int型））

void can_read()
{

    t2[0] = T2;
   //printf("t2[0] = %d\n\r",t2[0]);

    CANMessage msg;

    if(can1.write(CANMessage(10,t2,1))) {
        can_led = 1;
        //printf("send\n\r");
    } else {
        can_led = 0;
        //printf("not send\n\r");
    }

    if(can1.read(msg)) {
        can_led = 1;

        if( msg.id == 2 ) { //from main

            /*id2_value[0] = (msg.data[0]>>6 | 00000011);  //BOTTON〇-motorR off/on(1 or 2)
            id2_value[1] = (msg.data[0]>>4 | 00000011);  //BOTTON×-motorL off/on(1 or 2)
            id2_value[2] = (msg.data[0]>>3 | 00000001);  //BOTTON□-armR off/on(0 or 1)
            id2_value[3] = (msg.data[0]>>2 | 00000001);  //BOTTON△-armL off/on(0 or 1)
            id2_value[4] = (msg.data[0]>>1 | 00000001);  //BOTTONRIGHT-sanpou off/on(0 or 1)
            id2_value[5] = (msg.data[0] | 00000001);     //BOTTONDOWn-under_sanpou off/on(0 or 1)
            id2_value[6] = (msg.data[1]>>7 | 00000001);  //BOTTONUP-above_sanpou off/on(0 or 1)
            id2_value[7] = (msg.data[1]>>5 | 00000011);  //BOTTONLEFT-motorC off/on(1 or 2)
            id2_value[8] = (msg.data[1]>>3 | 00000011);  //decide wait/auto/manual(0~2)*/

            id2_value[0] = (msg.data[0]>>6)%4;  //BOTTON〇-motorR off/on(1 or 2)
            //id2_value[1] = (msg.data[0]>>400000011);  //BOTTON×-motorL off/on(1 or 2)
            id2_value[1] = (msg.data[0]>>4)%4;
            id2_value[2] = (msg.data[0]>>3)%2;  //BOTTON□-armR off/on(0 or 1)
            id2_value[3] = (msg.data[0]>>2)%2;  //BOTTON△-armL off/on(0 or 1)
            id2_value[4] = (msg.data[0]>>1)%2;  //BOTTONRIGHT-sanpou off/on(0 or 1)
            id2_value[5] = (msg.data[0])%2;     //BOTTONDOWn-under_sanpou off/on(0 or 1)
            id2_value[6] = (msg.data[1]>>7)%2;  //BOTTONUP-above_sanpou off/on(0 or 1)
            id2_value[7] = (msg.data[1]>>5)%4;  //BOTTONLEFT-motorC off/on(1 or 2)
            id2_value[8] = (msg.data[1]>>3)%4;  //decide wait/auto/manual(0~2)

            /*printf("msg.data[0]=%d mag.data[1]=%d 4bit=%d [0]=%d [1]=%d [2]=%d [3]=%d [4]=%d [5]=%d [6]=%d [7]=%d\n\r"
                  ,msg.data[0],msg.data[1],msg.data[0]>>4,id2_value[0],id2_value[1],id2_value[2],id2_value[3],id2_value[4],id2_value[5],id2_value[6],id2_value[7]);*/
            /*  printf("[0]=%d [1]=%d [2]=%d [3]=%d [4]=%d [5]=%d [6]=%d [7]=%d [8]=%d\n\r"
                     ,id2_value[0],id2_value[1],id2_value[2],id2_value[3],id2_value[4],id2_value[5],id2_value[6],id2_value[7],id2_value[8]);
                printf("ECR=%d ECL=%d\n\r",distR,distL);*/
        }

        if(msg.id == 8) {
            t2_r = msg.data[0];
        }
    } else {
        can_led = 0;
    }

    if(t2_r > T2) {
        T2 = t2_r;
    }
}

void calOmega()  //角速度計算関数
{
    ECR.CalOmega();
    ECL.CalOmega();
    //ECC.CalOmega();
}

void motorRout(double rf,double rb)
{
    motorRF = rf;
    motorRB = rb;
}

void motorLout(double lf,double lb)
{
    motorLF = lf;
    motorLB = lb;
}

void motorCout(double cf,double cb)
{
    motorCF = cf;
    motorCB = cb;
}

int main()
{
    can_ticker.attach(&can_read,0.01);
    motorRF.period_us(10);
    motorRB.period_us(10);
    motorLF.period_us(10);
    motorLB.period_us(10);
    motorCF.period_us(10);
    motorCB.period_us(10);

    while(1) {

        distR=ECR.getCount();
        distL=ECL.getCount();
        //distC=ECC.getCount();

        id2_value[8] = 1;

        switch(id2_value[8]) {
//-----auto mode----------------------------------------------------------------------------------------------------------------------//
            case 1:

                T2 = 0;
                printf("start\n\r");
                //printf("T2 = %d\n\r",T2);

                if(T2 == 0) {
                    while(1) {
                        printf("T2 = 0\n\r");
                        if(T2 == 1) {
                            break;
                        }
                    }
                }


                if(T2 == 1) {

                    //みかん掴んで持ち上げて機体に取り込む
                    //printf("T2 = 1\n\r");

                    T2++;
                    
                }

                if(T2 == 2) {
                    while(1) {
                        printf("T2 = 2\n\r");
                        if(T2 == 3) {
                            break;
                        }
                    }
                }

                if(T2 == 3) {

                    //三宝を掴み上げて、機体内に取り込み、みかんを機体内に取り込む
                    printf("t = 3");
                    T2++;
                }

                if(T2 == 4) {
                    while(1) {
                        if(T2 == 5) {
                            break;
                        }
                    }
                }

                if(T2 == 5) {

                    //りんごを掴んで持ち上げて機体に取り込む
                    printf("t = 5");
                    T2++;
                }

                if(T2 == 6) {
                    while(1) {
                        if(T2 == 7) {
                            break;
                        }
                    }
                }

                if(T2 == 7) {

                    //お供え
                    printf("t = 7");
                    T2++;
                }


                break;
//-----wait mode----------------------------------------------------------------------------------------------------------------------//
            case 0:

                break;
//-----manual mode--------------------------------------------------------------------------------------------------------------------//
            case 2:
//-----motor & EC---------------------------------------//
                switch(id2_value[0]) {  //armR

                    case 0:
                        motorRout(0,0);
                        break;

                    case 1:  //move from first position
                        if(distR < 200) {
                            motorRout(0.1,0);
                            /*} else if(distR >= 80 && distR < 110) {
                                motorRout(0.1,0);*/
                        } else {
                            motorRout(0,0);
                        }
                        break;

                    case 2:  //move from second position
                        if(distR > 30) {
                            motorRout(0,0.1);
                            /*} else if(distR >= 5 && distR < 20) {
                                motorRout(0,0.1);*/
                        } else {
                            motorRout(0,0);
                        }
                        break;
                }

                switch(id2_value[1]) {  //armL

                    case 0:
                        motorLout(0,0);
                        break;

                    case 1:  //move from first position
                        if(distL < 200) {
                            motorLout(0.1,0);
                            /*} else if(distL >=80  && distL < 110) {
                                motorLout(0.1,0);*/
                        } else {
                            motorLout(0,0);
                        }
                        break;

                    case 2:
                        if(distL > 30) {
                            motorLout(0,0.1);
                            /*} else if(distL >= 5 && distL < 20) {
                                motorLout(0,0.1);*/
                        } else {
                            motorLout(0,0);
                        }
                        break;
                }

                //-----編集中----------------------------------------------------------------------------------------------
                if(id2_value[7]==1) {
                    timer.start();
                    second = timer.read();
                    printf("second = %f\n\r",second);

                    if(timerstop == 0 && second > 6.8) {
                        motorCout(0,0);
                        timerstop = 1;

                    } else if(timerstop == 1) {
                        motorCout(0,0);
                        timer.reset();
                        timer.stop();

                    } else  {
                        motorCout(0.1,0);
                    }

                    /*if(stopcount == 0 && second < 1) {
                        motorCout(0.1,0);
                    } else if(stopcount == 0 && touch.read() == 1){
                        motorCout(0.1,0);
                    } else if(stopcount == 0 && touch.read() == 0) {
                        motorCout(0,0);
                        stopcount = 1;
                    } else if(stopcount == 1){
                        motorCout(0,0);
                    }*/

                } else if(id2_value[7]==2) {
                    timer.start();
                    second = timer.read();
                    printf("second = %f\n\r",second);
                    timerstop = 0;

                    if(touch.read() == 1) {
                        motorCout(0,0.1);
                    } else if(touch.read() == 0) {
                        motorCout(0,0);
                        timer.reset();
                        timer.stop();
                    }

                    /*if(stopcount == 1 && second < 1) {
                        motorCout(0,0.1);
                    } else if(stopcount == 1 && touch.read() == 1){
                        motorCout(0,0.1);
                    } else if(stopcount == 1 && touch.read() == 0) {
                        motorCout(0,0);
                        stopcount = 0;
                    } else if(stopcount == 0){
                        motorCout(0,0);
                    }*/
                }
//--------------------------------------------------------------------------------------------------------

//----- 電磁弁 ----------------------------------------------//
                if(id2_value[2]==1) {  //初期位置設定早めに
                    armR = 0;
                } else if(id2_value[2]==0) {
                    armR = 1;
                }

                if(id2_value[3]==1) {
                    armL = 0;
                } else if(id2_value[3]==0) {
                    armL = 1;
                }

                if(id2_value[4]==1) {
                    sanpou = 1;
                } else if(id2_value[4]==0) {
                    sanpou = 0;
                }

                if(id2_value[5]==1) {
                    under_sanpou = 1;
                } else if(id2_value[5]==0) {
                    under_sanpou = 0;
                }

                if(id2_value[6]==1) {
                    above_sanpou = 1;
                } else if(id2_value[6]==0) {
                    above_sanpou = 0;
                }

                break;
        }
    }
}