#ifndef HARUROBO2019_PATHFOLLOWING_H
#define HARUROBO2019_PATHFOLLOWING_H
#include <EC.h>


extern double now_x,now_y,now_angle;  //main.cppにこれらの値の読み込みを書くこと
extern double now_timeQ,now_timeR;
extern double usw_data1,usw_data2,usw_data3,usw_data4;


void UserLoopSetting2();

void XYRmotorout(double plot_x1, double plot_y1, double plot_x2, double plot_y2, double *ad_x_out, double *ad_y_out, double *ad_r_out,double speed1,double speed2);
//出発地点、目標地点の座標から機体のx軸方向、y軸方向、旋回の出力を算出する関数(エンコーダ/ジャイロ使用)
/*
 *1.main分内でx_out,y_out,r_outをdouble型で定義
 *2.XYRmotorout関数使用時は、num番目のx、y座標、num+1番目のx,y座標に加え、
  x_out,y_out,r_outのアドレス（&x_out,&y_out,&r_out）を渡す→（XYRmotorout(座標×４つ,&x_out,&y_out,&r_out)）
*/

//次の関数のパラメーターを定義すること

//void set_p_out(double p);
//ベクトルABに平行方向の出力値設定関数

void q_setPDparam(double q_p,double q_d);
//ベクトルABに垂直な方向の誤差を埋めるPD制御のパラメータ設定関数 

void r_setPDparam(double r_p,double r_d);
//機体角度と目標角度の誤差を埋めるPD制御のパラメータ設定関数

void set_r_out(double r);
//旋回時の最大出力値設定関数

void set_target_angle(double t);
//機体目標角度設定関数

void calOmega();

void output(double FL,double BL,double BR,double FR);

void base(double FL,double BL,double BR,double FR,double Max);

void calc_xy_enc();

void set_cond(int t, int px, double bx, int py, double by);

void calc_xy_usw(double tgt_angle);

void calc_xy(double tgt_angle, double u, double v);

void purecurve2(int type,double u, double v,          //正面を変えずに円弧or楕円を描いて曲がる
                double point_x1,double point_y1,
                double point_x2,double point_y2,
                int theta,
                double speed,
                double q_p,double q_d,
                double r_p,double r_d,
                double r_out_max,
                double target_angle);
                
void gogo_straight(double u, double v, double x1_point,double y1_point,  //直線運動プログラム
                   double x2_point,double y2_point,
                   double speed1,double speed2,
                   double q_p,double q_d,
                   double r_p,double r_d,
                   double r_out_max,
                   double target_angle);
                   



#endif