#include "PathFollowing.h"
#include <mbed.h>
#include <math.h>
#include "EC.h"
#include "R1370P.h"
#include "move4wheel.h"
#include <stdarg.h>
#include "Maxon_setting.h"

#define PI 3.141592


double p_out,r_out_max;
double Kvq_p,Kvq_d,Kvr_p,Kvr_d;
double diff_old,diffangle,diffangle_old;
double out_dutyQ,out_dutyR;
double now_angle,target_angle;
double now_timeQ,old_timeQ,now_timeR,old_timeR;
double now_x, now_y;
double diff_st,diff_tgt,diff_st_tgt,p_param;
double usw_data1,usw_data2,usw_data3,usw_data4;


Ticker motor_tick;  //角速度計算用ticker
//Ticker ticker;  //for enc
Timer timer;

Ec EC1(p8,p26,NC,500,0.05);
Ec EC2(p21,p22,NC,500,0.05);
R1370P gyro(p28,p27);

double new_dist1=0,new_dist2=0;
double old_dist1=0,old_dist2=0;
double d_dist1=0,d_dist2=0;  //座標計算用関数
double d_x,d_y;
//現在地X,y座標、現在角度については、PathFollowingでnow_x,now_y,now_angleを定義済
double start_x=0,start_y=0;  //スタート位置

double x_out,y_out,r_out;  //出力値

static int16_t m_1=0, m_2=0, m_3=0, m_4=0;  //int16bit = int2byte

double xy_type,pm_typeX,pm_typeY,x_base,y_base;


///////////////////機体情報をメンバとする構造体"robo_data"と構造体型変数info(←この変数に各センサーにより求めた機体情報(機体位置/機体角度)を格納する)の宣言/////////////////

/*「info.(機体情報の種類).(使用センサーの種類)」に各情報を格納する
 *状況に応じて、どのセンサーにより算出した情報を信用するかを選択し、その都度now_angle,now_x,now_yに代入する。（何種類かのセンサーの情報を混ぜて使用することも可能）
 *(ex)
 *info.nowX.enc → エンコーダにより算出した機体位置のx座標
 *info.nowY.usw → 超音波センサーにより求めた機体位置のy座標
*/

typedef struct{ //使用センサーの種類
    double usw;  //超音波センサー
    double enc;  //エンコーダ
    double gyro; //ジャイロ
    //double line;//ラインセンサー
}robo_sensor;

typedef struct{ //機体情報の種類
    robo_sensor angle; //←機体角度は超音波センサーやラインセンサーからも算出可能なので一応格納先を用意したが、ジャイロの値を完全に信用してもいいかも
    robo_sensor nowX;
    robo_sensor nowY;
}robo_data;

robo_data info={{0,0,0},{0,0,0},{0,0,0}}; //全てのデータを０に初期化


////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


void UserLoopSetting2(){
    
     gyro.initialize();
   motor_tick.attach(&calOmega,0.05);  //0.05秒間隔で角速度を計算
    EC1.setDiameter_mm(48);
    EC2.setDiameter_mm(48);  //測定輪半径//後で測定
    
}

//初期座標：A, 目標座標：B、機体位置：C、点Cから直線ABに下ろした垂線の足：H
void XYRmotorout(double plot_x1, double plot_y1, double plot_x2, double plot_y2, double *ad_x_out, double *ad_y_out, double *ad_r_out, double speed1, double speed2 )  //プログラム使用時、now_x,now_yはグローバル変数として定義する必要あり
//plot_x1,plot_y1:出発地点の座標
//plot_x2,plot_y2:目標地点の座標
//speed1:初期速度
//speed2:目標速度
{
    double Vector_P[2] = {(plot_x2 - plot_x1), (plot_y2 - plot_y1)}; //ベクトルAB
    double A_Vector_P = hypot(Vector_P[0], Vector_P[1]); //ベクトルABの大きさ（hypot(a,b)で√（a^2+b^2）を計算できる <math.h>））
    double UnitVector_P[2] = {Vector_P[0]/A_Vector_P, Vector_P[1]/A_Vector_P}; //ベクトルABの単位ベクトル
    double UnitVector_Q[2] = {UnitVector_P[1], -UnitVector_P[0]}; //ベクトルCHの単位ベクトル
    double Vector_R[2] = {(now_x - plot_x1), (now_y - plot_y1)}; //ベクトルAC
    double diff = UnitVector_P[0]*Vector_R[1] - UnitVector_P[1]*Vector_R[0]; //機体位置と直線ABの距離（外積を用いて計算）


    //double VectorOut_P[2]= {0}; //ベクトルABに平行方向の出力をx軸方向、y軸方向の出力に分解*/

///////////////////＜XYRmotorout関数内＞以下、ベクトルABに垂直な方向の誤差を埋めるPD制御（ベクトルABに垂直方向の出力を求め、x軸方向、y軸方向の出力に分解）//////////////////////

    timer.start();
    now_timeQ=timer.read();
    out_dutyQ=Kvq_p*diff+Kvq_d*(diff-diff_old)/(now_timeQ-old_timeQ); //ベクトルABに垂直方向の出力を決定
    diff_old=diff;

    if(out_dutyQ>500)out_dutyQ=500;
    if(out_dutyQ<-500)out_dutyQ=-500;

    old_timeQ=now_timeQ;

    double VectorOut_Q[2] = {out_dutyQ*UnitVector_Q[0], out_dutyQ*UnitVector_Q[1]}; //ベクトルABに垂直方向の出力をx軸方向、y軸方向の出力に分解

///////////////////////////////<XYRmotorout関数内＞以下、機体角度と目標角度の誤差を埋めるPD制御（旋回のための出力値を決定）//////////////////////////////////

    now_timeR=timer.read();
    diffangle=target_angle-now_angle;
    out_dutyR=-(Kvr_p*diffangle+Kvr_d*(diffangle-diffangle_old)/(now_timeR-old_timeR));
    diffangle_old=diffangle;

    if(out_dutyR>r_out_max)out_dutyR=r_out_max;
    if(out_dutyR<-r_out_max)out_dutyR=-r_out_max;

    old_timeR=now_timeR;

//////////////////////////<XYRmotorout関数内＞以下、x軸方向、y軸方向、旋回の出力をそれぞれad_x_out,ad_y_out,ad_r_outの指すアドレスに書き込む/////////////////////////////
////////////////////////////////////////////その際、x軸方向、y軸方向の出力はフィールドの座標系から機体の座標系に変換する。///////////////////////////////////////////////

    diff_st = hypot(now_x-plot_x1,now_y-plot_y1); //出発座標と機体の位置の距離
    diff_tgt = hypot(now_x - plot_x2, now_y - plot_y2); //機体の位置と目標座標の距離
    diff_st_tgt = hypot(plot_x1-plot_x2,plot_y1-plot_y2); //出発座標と目標座標の距離

    if(speed1 == speed2) { //等速移動

        double VectorOut_P[2] = {speed1*UnitVector_P[0], speed1*UnitVector_P[1]};

        *ad_x_out = (VectorOut_P[0]+VectorOut_Q[0])*cos(-now_angle*3.141592/180)-(VectorOut_P[1]+VectorOut_Q[1])*sin(-now_angle*3.141592/180);
        *ad_y_out = (VectorOut_P[0]+VectorOut_Q[0])*sin(-now_angle*3.141592/180)+(VectorOut_P[1]+VectorOut_Q[1])*cos(-now_angle*3.141592/180);
        *ad_r_out = out_dutyR;

    } else if(speed2 == 0) { //減速移動(目標速度が０)→ベクトルABに垂直な方向の出力にもP制御をかける。

        double VectorOut_P[2] = {speed1*UnitVector_P[0], speed1*UnitVector_P[1]};

        if(diff_tgt > diff_st_tgt) {
            diff_tgt = diff_st_tgt;
        }

        p_param=(diff_tgt/diff_st_tgt);

        *ad_x_out = p_param*((VectorOut_P[0]+VectorOut_Q[0])*cos(-now_angle*3.141592/180)-(VectorOut_P[1]+VectorOut_Q[1])*sin(-now_angle*3.141592/180));
        *ad_y_out = p_param*((VectorOut_P[0]+VectorOut_Q[0])*sin(-now_angle*3.141592/180)+(VectorOut_P[1]+VectorOut_Q[1])*cos(-now_angle*3.141592/180));
        *ad_r_out = out_dutyR;

    } else if(speed1 > speed2) { //減速移動（目標速度が０でない）

        if(diff_tgt > diff_st_tgt) {
            diff_tgt = diff_st_tgt;
        }
        
        p_param=(diff_tgt/diff_st_tgt);

        double speed3 = speed2 + (speed1-speed2)*p_param;

        double VectorOut_P[2] = {speed3*UnitVector_P[0], speed3*UnitVector_P[1]};
         
        *ad_x_out = (VectorOut_P[0]+VectorOut_Q[0])*cos(-now_angle*3.141592/180)-(VectorOut_P[1]+VectorOut_Q[1])*sin(-now_angle*3.141592/180);
        *ad_y_out = (VectorOut_P[0]+VectorOut_Q[0])*sin(-now_angle*3.141592/180)+(VectorOut_P[1]+VectorOut_Q[1])*cos(-now_angle*3.141592/180);
        *ad_r_out = out_dutyR;

    } else if(speed1 < speed2) { //加速移動(speed1)

        if(diff_st > diff_st_tgt) {
            diff_st = diff_st_tgt;
        }
             
        p_param=(diff_st/diff_st_tgt);

        double speed4 = speed1 + (speed2-speed1)*p_param;

        double VectorOut_P[2] = {speed4*UnitVector_P[0], speed4*UnitVector_P[1]};
         
        *ad_x_out = (VectorOut_P[0]+VectorOut_Q[0])*cos(-now_angle*3.141592/180)-(VectorOut_P[1]+VectorOut_Q[1])*sin(-now_angle*3.141592/180);
        *ad_y_out = (VectorOut_P[0]+VectorOut_Q[0])*sin(-now_angle*3.141592/180)+(VectorOut_P[1]+VectorOut_Q[1])*cos(-now_angle*3.141592/180);
        *ad_r_out = out_dutyR;
    }
}

////////////////////////////////////////////////////////////<XYRmotorout関数は以上>////////////////////////////////////////////////////////////////


/*void set_p_out(double p)  //ベクトルABに平行方向の出力値設定関数
{
    p_out = p;
}*/

void q_setPDparam(double q_p,double q_d)  //ベクトルABに垂直な方向の誤差を埋めるPD制御のパラメータ設定関数
{
    Kvq_p=q_p;
    Kvq_d=q_d;
}

void r_setPDparam(double r_p,double r_d)  //機体角度と目標角度の誤差を埋めるPD制御のパラメータ設定関数
{
    Kvr_p=r_p;
    Kvr_d=r_d;
}

void set_r_out(double r)  //旋回時の最大出力値設定関数
{
    r_out_max = r;
}

void set_target_angle(double t)  //機体の目標角度設定関数
{
    target_angle = t;
}


void UserLoopSetting();             // initialize setting
void DAC_Write(int16_t data, DigitalOut* DAC_cs);
void MotorControl(int16_t val_md1, int16_t val_md2, int16_t val_md3, int16_t val_md4);

void calOmega()  //角速度計算関数
{
    EC1.CalOmega();
    EC2.CalOmega();
}

void output(double FL,double BL,double BR,double FR)
{
    m_1=FL;
    m_2=BL;
    m_3=BR;
    m_4=FR;
}

void base(double FL,double BL,double BR,double FR,double Max)
//いろんな加算をしても最大OR最小がMaxになるような補正//絶対値が一番でかいやつで除算
//DCモーターならMax=1、マクソンは-4095～4095だからMax=4095にする
{
    if(fabs(FL)>=Max||fabs(BL)>=Max||fabs(BR)>=Max||fabs(FR)>=Max) {

        if     (fabs(FL)>=fabs(BL)&&fabs(FL)>=fabs(BR)&&fabs(FL)>=fabs(FR))output(Max*FL/fabs(FL),Max*BL/fabs(FL),Max*BR/fabs(FL),Max*FR/fabs(FL));
        else if(fabs(BL)>=fabs(FL)&&fabs(BL)>=fabs(BR)&&fabs(BL)>=fabs(FR))output(Max*FL/fabs(BL),Max*BL/fabs(BL),Max*BR/fabs(BL),Max*FR/fabs(BL));
        else if(fabs(BR)>=fabs(FL)&&fabs(BR)>=fabs(BL)&&fabs(BR)>=fabs(FR))output(Max*FL/fabs(BR),Max*BL/fabs(BR),Max*BR/fabs(BR),Max*FR/fabs(BR));
        else                                                               output(Max*FL/fabs(FR),Max*BL/fabs(FR),Max*BR/fabs(FR),Max*FR/fabs(FR));
    } else {
        output(FL,BL,BR,FR);
    }
}

void calc_xy_enc() //エンコーダによる座標計算
{
    now_angle=gyro.getAngle();  //ジャイロの値読み込み

    new_dist1=EC1.getDistance_mm();
    new_dist2=EC2.getDistance_mm();
    d_dist1=new_dist1-old_dist1;
    d_dist2=new_dist2-old_dist2;
    old_dist1=new_dist1;
    old_dist2=new_dist2;  //微小時間当たりのエンコーダ読み込み

    d_x=d_dist2*sin(now_angle*PI/180)-d_dist1*cos(now_angle*PI/180);
    d_y=d_dist2*cos(now_angle*PI/180)+d_dist1*sin(now_angle*PI/180);  //微小時間毎の座標変化
    info.nowX.enc = info.nowX.enc + d_x;
    info.nowY.enc = info.nowY.enc - d_y;  //微小時間毎に座標に加算
}

void set_cond(int t, int px, double bx, int py, double by){ //超音波センサーを使用するときの条件設定関数
//引数の詳細は関数"calc_xy_usw"参照
  
   xy_type = t;
   
   pm_typeX = px;
   x_base = bx;
   
   pm_typeY = py;
   y_base = by;   
       
}


void calc_xy_usw(double tgt_angle){ //超音波センサーによる座標計算（機体が旋回する場合はこの方法による座標計算は出来ない）
//tgt_angle:機体の目標角度（運動初期角度と同じ/今大会では0,90,180のみ）
//xy_type:（0:Y軸平行の壁を読む/1:X軸平行の壁を読む/2:X,Y軸平行の壁を共に読む）
//pm_typeX,pm_typeY:（0:各軸正方向側の壁を読む/1:各軸負方向側の壁を読む）
//x_base,y_base:超音波センサーで読む壁の座標(y軸並行の壁のx座標/x軸平行の壁のy座標)
    
    double R1=240,R2=240,R3=240,R4=240; //機体の中心から各超音波センサーが付いている面までの距離
    double D1=30,D2=30,D3=30,D4=30; //各超音波センサーが付いている面の中心から各超音波センサーまでの距離
    
    now_angle=gyro.getAngle();
    
    if(tgt_angle==0){
      if((xy_type==0 || xy_type==2) && pm_typeX==0){
        
        info.nowX.usw = x_base - (usw_data4 + R4*cos(now_angle*PI/180) + D4*sin(now_angle*PI/180));
           
      }else if((xy_type==0 || xy_type==2) && pm_typeX==1){
         
        info.nowX.usw = x_base + (usw_data3 + R3*cos(now_angle*PI/180) + D3*sin(now_angle*PI/180));
          
      }
      if((xy_type==1 || xy_type==2) && pm_typeY==0){
         
        info.nowY.usw = y_base - (usw_data2 + R2*cos(now_angle*PI/180) + D2*sin(now_angle*PI/180));
          
      }else if((xy_type==1 || xy_type==2) && pm_typeY==1){
         
        info.nowY.usw = y_base + (usw_data1 + R1*cos(now_angle*PI/180) + D1*sin(now_angle*PI/180));
          
      }
    
    }else if(tgt_angle==90){
      if((xy_type==0 || xy_type==2) && pm_typeX==0){
        
        info.nowX.usw = x_base - (usw_data1 + R1*cos(now_angle*PI/180) + D1*sin(now_angle*PI/180));
           
      }else if((xy_type==0 || xy_type==2) && pm_typeX==1){
         
        info.nowX.usw = x_base + (usw_data2 + R2*cos(now_angle*PI/180) + D2*sin(now_angle*PI/180));
          
      }
      if((xy_type==1 || xy_type==2) && pm_typeY==0){
         
        info.nowY.usw = y_base - (usw_data4 + R4*cos(now_angle*PI/180) + D4*sin(now_angle*PI/180));
          
      }else if((xy_type==1 || xy_type==2) && pm_typeY==1){
         
        info.nowY.usw = y_base + (usw_data3 + R3*cos(now_angle*PI/180) + D3*sin(now_angle*PI/180));
          
      }
        
    }else if(tgt_angle==180){    
       if((xy_type==0 || xy_type==2) && pm_typeX==0){
        
        info.nowX.usw = x_base - (usw_data3 + R3*cos(now_angle*PI/180) + D3*sin(now_angle*PI/180));
           
      }else if((xy_type==0 || xy_type==2) && pm_typeX==1){
         
        info.nowX.usw = x_base + (usw_data4 + R4*cos(now_angle*PI/180) + D4*sin(now_angle*PI/180));
          
      }
      if((xy_type==1 || xy_type==2) && pm_typeY==0){
         
        info.nowY.usw = y_base - (usw_data1+ R1*cos(now_angle*PI/180) + D1*sin(now_angle*PI/180));
          
      }else if((xy_type==1 || xy_type==2) && pm_typeY==1){
         
        info.nowY.usw = y_base + (usw_data2 + R2*cos(now_angle*PI/180) + D2*sin(now_angle*PI/180));
          
      }
    
    }
    
}

void calc_xy(double target_angle, double u,double v){ //エンコーダにより求めた機体の座標と超音波センサーにより求めた機体の座標を(エンコーダ : 超音波 = u : i-u / v : i-v)の割合で混ぜて now_x,now_y に代入する。
    
   calc_xy_enc();
   
   if(u != 1){
      calc_xy_usw(target_angle); //エンコーダの値しか使用しない場合は超音波センサーによる座標計算は行わずに計算量を減らす。
   }
   if(v != 1){
      calc_xy_usw(target_angle);
    }
    
    now_x = u * info.nowX.enc + (1-u) * info.nowX.usw;
    now_y = v * info.nowY.enc + (1-v) * info.nowY.usw;
    
}

//ここからそれぞれのプログラム/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//now_x(現在のx座標),now_y(現在のy座標),now_angle(機体角度(ラジアンではない)(0~360や-180~180とは限らない))(反時計回りが正)
//ジャイロの出力は角度だが三角関数はラジアンとして計算する
//通常の移動＋座標のずれ補正＋機体の角度補正(＋必要に応じさらに別補正)
//ジャイロの仕様上、角度補正をするときに計算式内で角度はそのままよりsinをとったほうがいいかもね

void purecurve2(int type,double u,double v,                         //正面を変えずに円弧or楕円を描いて曲がる
                double point_x1,double point_y1,
                double point_x2,double point_y2,
                int theta,
                double speed,
                double q_p,double q_d,
                double r_p,double r_d,
                double r_out_max,
                double target_angle)
//type:動きの種類（8パターン) point_x1,point_y1=出発地点の座標 point_x2,point_x2=目標地点の座標 theta=plotの間隔(0～90°) speed=速度
{
    //-----PathFollowingのパラメーター設定-----//
    q_setPDparam(q_p,q_d);  //ベクトルABに垂直な方向の誤差を埋めるPD制御のパラメータ設定関数
    r_setPDparam(r_p,r_d);  //機体角度と目標角度の誤差を埋めるPD制御のパラメータ設定関数
    set_r_out(r_out_max);  //旋回時の最大出力値設定関数
    set_target_angle(target_angle);  //機体目標角度設定関数

    int s;
    int t = 0;
    double X,Y;//X=楕円の中心座標、Y=楕円の中心座標
    double a,b; //a=楕円のx軸方向の幅の半分,b=楕円のy軸方向の幅の半分
    double plotx[(90/theta)+1];  //楕円にとるplotのx座標
    double ploty[(90/theta)+1];

    double x_out,y_out,r_out;

    a=fabs(point_x1-point_x2);
    b=fabs(point_y1-point_y2);

    switch(type) {

        case 1://→↑移動
            X=point_x1;
            Y=point_y2;

            for(s=0; s<((90/theta)+1); s++) {
                plotx[s] = X + a * cos(-PI/2 + s * (PI*theta/180));
                ploty[s] = Y + b * sin(-PI/2 + s * (PI*theta/180));
                //debug_printf("plotx[%d]=%f ploty[%d]=%f\n\r",s,plotx[s],s,ploty[s]);
            }
            break;

        case 2://↑→移動
            X=point_x2;
            Y=point_y1;

            for(s=0; s<((90/theta)+1); s++) {
                plotx[s] = X + a * cos(PI - s * (PI*theta/180));
                ploty[s] = Y + b * sin(PI - s * (PI*theta/180));
                //debug_printf("plotx[%d]=%f ploty[%d]=%f\n\r",s,plotx[s],s,ploty[s]);
            }
            break;

        case 3://↑←移動
            X=point_x2;
            Y=point_y1;

            for(s=0; s<((90/theta)+1); s++) {
                plotx[s] = X + a * cos(s * (PI*theta/180));
                ploty[s] = Y + b * sin(s * (PI*theta/180));
                //debug_printf("plotx[%d]=%f ploty[%d]=%f\n\r",s,plotx[s],s,ploty[s]);
            }
            break;

        case 4://←↑移動
            X=point_x1;
            Y=point_y2;

            for(s=0; s<((90/theta)+1); s++) {
                plotx[s] = X + a * cos(-PI/2 - s * (PI*theta/180));
                ploty[s] = Y + b * sin(-PI/2 - s * (PI*theta/180));
                //debug_printf("plotx[%d]=%f ploty[%d]=%f\n\r",s,plotx[s],s,ploty[s]);
            }
            break;

        case 5://←↓移動
            X=point_x1;
            Y=point_y2;

            for(s=0; s<((90/theta)+1); s++) {
                plotx[s] = X + a * cos(PI/2 + s * (PI*theta/180));
                ploty[s] = Y + b * sin(PI/2 + s * (PI*theta/180));
                //debug_printf("plotx[%d]=%f ploty[%d]=%f\n\r",s,plotx[s],s,ploty[s]);
            }
            break;

        case 6://↓←移動
            X=point_x2;
            Y=point_y1;

            for(s=0; s<((90/theta)+1); s++) {
                plotx[s] = X + a * cos(-s * (PI*theta/180));
                ploty[s] = Y + b * sin(-s * (PI*theta/180));
                //debug_printf("plotx[%d]=%f ploty[%d]=%f\n\r",s,plotx[s],s,ploty[s]);
            }
            break;

        case 7://↓→移動
            X=point_x2;
            Y=point_y1;

            for(s=0; s<((90/theta)+1); s++) {
                plotx[s] = X + a * cos(PI + s * (PI*theta/180));
                ploty[s] = Y + b * sin(PI + s * (PI*theta/180));
                //debug_printf("plotx[%d]=%f ploty[%d]=%f\n\r",s,plotx[s],s,ploty[s]);
            }
            break;

        case 8://→↓移動
            X=point_x1;
            Y=point_y2;

            for(s=0; s<((90/theta)+1); s++) {
                plotx[s] = X + a * cos(PI/2 - s * (PI*theta/180));
                ploty[s] = Y + b * sin(PI/2 - s * (PI*theta/180));
                //debug_printf("plotx[%d]=%f ploty[%d]=%f\n\r",s,plotx[s],s,ploty[s]);
            }
            break;
    }

    while(1) {

        calc_xy(target_angle,u,v);

        XYRmotorout(plotx[t],ploty[t],plotx[t+1],ploty[t+1],&x_out,&y_out,&r_out,speed,speed);
        CalMotorOut(x_out,y_out,r_out);
        //debug_printf("t=%d now_x=%f now_y=%f x_out=%f y_out=%f\n\r",t,now_x,now_y,x_out,y_out);

        base(GetMotorOut(0),GetMotorOut(1),GetMotorOut(2),GetMotorOut(3),4095);  //m1～m4に代入
        //debug_printf("t=%d (0)=%f (1)=%f (2)=%f (3)=%f\n\r",t,GetMotorOut(0),GetMotorOut(1),GetMotorOut(2),GetMotorOut(3));
        
        if(((plotx[t+1] - now_x)*(plotx[t+1] - plotx[t]) + (ploty[t+1] - now_y)*(ploty[t+1] - ploty[t])) < 0)t++;

        MotorControl(m_1,m_2,m_3,m_4);  //出力
        debug_printf("t=%d m1=%d m2=%d m3=%d m4=%d x=%f y=%f angle=%f\n\r",t,m_1,m_2,m_3,m_4,now_x,now_y,now_angle);
        
        if(t == (90/theta))break;
    }
}


void gogo_straight(double u,double v,
                   double x1_point,double y1_point,  //直線運動プログラム
                   double x2_point,double y2_point,
                   double speed1,double speed2,
                   double q_p,double q_d,
                   double r_p,double r_d,
                   double r_out_max,
                   double target_angle)
//引数:出発地点の座標（x,y）、目標地点の座標(x,y)、初速度（speed1）、目標速度（speed2）//speed1=speed2 のとき等速運動
{
    //-----PathFollowingのパラメーター設定-----//
    q_setPDparam(q_p,q_d);  //ベクトルABに垂直な方向の誤差を埋めるPD制御のパラメータ設定関数
    r_setPDparam(r_p,r_d);  //機体角度と目標角度の誤差を埋めるPD制御のパラメータ設定関数
    set_r_out(r_out_max);  //旋回時の最大出力値設定関数
    set_target_angle(target_angle);  //機体目標角度設定関数
    
    while (1) {

        calc_xy(target_angle,u,v);

        XYRmotorout(x1_point,y1_point,x2_point,y2_point,&x_out,&y_out,&r_out,speed1,speed2);
        //printf("x = %f, y = %f,angle = %f,x_out=%lf, y_out=%lf, r_out=%lf\n\r",now_x,now_y,now_angle,x_out, y_out,r_out);

        CalMotorOut(x_out,y_out,r_out);
        //printf("out1=%lf, out2=%lf, out3=%lf, out4=%lf\n",GetMotorOut(0),GetMotorOut(1),GetMotorOut(2),GetMotorOut(3));

        base(GetMotorOut(0),GetMotorOut(1),GetMotorOut(2),GetMotorOut(3),4095);
        //printf("m1=%d, m2=%d, m3=%d, m4=%d\r\n",m_1,m_2,m_3,m_4);
        
        MotorControl(m_1,m_2,m_3,m_4);
        debug_printf("m1=%d m2=%d m3=%d m4=%d x=%f y=%f angle=%f\n\r",m_1,m_2,m_3,m_4,now_x,now_y,now_angle);

        if(((x2_point - now_x)*(x2_point - x1_point) + (y2_point - now_y)*(y2_point - y1_point)) < 0)break;
    }
}

