#include "Utils.h"
#include "USBHost.h"
#include "hci.h"
#include "ps3.h"
#include "User.h"
#include "mbed.h"
#include "math.h"

int RSX,RSY,LSX,LSY,BSU,BSL;
DigitalOut cs(p8);
int move,shoot,speed;
Can controller(,);//CANpin_name


void UserLoopSetting()
{

}
void UserLoop(char n,const u8* data)
{
    u16 ButtonState;
    if(n==0) { //有線Ps3USB.cpp
        RSX = ((ps3report*)data)->RightStickX;
        RSY = ((ps3report*)data)->RightStickY;
        LSX = ((ps3report*)data)->LeftStickX;
        LSY = ((ps3report*)data)->LeftStickY;
        BSU = (u8)(((ps3report*)data)->ButtonState & 0x00ff);
        BSL = (u8)(((ps3report*)data)->ButtonState >> 8);
        //ボタンの処理
        ButtonState =  ((ps3report*)data)->ButtonState;
    } else {//無線TestShell.cpp
        RSX = ((ps3report*)(data + 1))->RightStickX;
        RSY = ((ps3report*)(data + 1))->RightStickY;
        LSX = ((ps3report*)(data + 1))->LeftStickX;
        LSY = ((ps3report*)(data + 1))->LeftStickY;
        BSU = (u8)(((ps3report*)(data + 1))->ButtonState & 0x00ff);
        BSL = (u8)(((ps3report*)(data + 1))->ButtonState >> 8);
        //ボタンの処理
        ButtonState =  ((ps3report*)(data + 1))->ButtonState;
    }
    //ここより下にプログラムを書く
    //CAN通信用プログラム
    move = controller_move();
    shoot = controller_shoot();
    speed = controller_speed();
    controller.write(CANMessage(1,move,1);
    controller.write(CANMessage(2,shoot,1);
    controller.write(CANMessgae(3,speed,1);
}

int controller_move(){
    if((ButtonState >> BUTTONUP)&1 == 1&&(ButtonState >> BUTTONL1)&1 == 1)//UPL1
    {
       return 9;
    }else if ((ButtonState >> BUTTONDOWN)&1 == 1&&(ButtonState >> BUTTONR1)&1 == 1)//DownR1
    {
        return 3;
    }else if ((ButtonState >> BUTTONUP)&1 == 1&&(ButtonState >> BUTTONR1)&1 == 1)//UPR1
    {
        return 7;
    }else if ((ButtonState >> BUTTONDOWN)&1 == 1&&(ButtonState >> BUTTONL1)&1 == 1)//DownL1
    {
        return 1;
    }else if((ButtonState >> BUTTONUP)&1 == 1) //up
    {
        return 8;
    }else if((ButtonState >> BUTTONDOWN)&1 == 1)//down
    {
        return 2;
    }else if((ButtonState >> BUTTONRIGHT)&1 == 1)//right
    {
        return 6;
    }else if((ButtonState >> BUTTONLEFT)&1 == 1)//left
    {
        return 4;
    }else if((ButtonState >> BUTTONL1)&1 == 1) //L1
    {
        return 10;
    }else if((ButtonState >> BUTTONR1)&1 == 1) //R1
    {
        return 11;
    }else{
        return 0;
    }
}
int controller_speed(){
    if((ButtonState >> BUTTONL2)&1 == 1&&Speed_Mode>1) {//対応するボタンを書く(今回L2ボタン
        return 1;
    }else if((ButtonState >> BUTTONR2)&1 == 1&&Speed_Mode<3) {//対応するボタンを書く(今回R2ボタン
        return 2;
    }else{
        return 0;
    }
}
int controller_shoot(){
    if((ButtonState >> BUTTONCIRCLE)&1 == 1) {//O
        return 1;
    } else if((ButtonState >> BUTTONCROSS)&1 == 1) {//X
        return 2;
    }else if((ButtonState >> BUTTONTRIANGLE)&1 == 1) {//△
        return 3;
    }else if((ButtonState >> BUTTONSQUARE)&1 == 1) {//□
        return 4;
    }else{ 
        return 0;
    }
}