#include "mbed.h"
#include "EC.h" //Encoderライブラリをインクルード
#define RESOLUTION 500

//Serial pc(USBTX, USBRX); // tx, rx
PwmOut f(p26);
PwmOut b(p25);
Ticker ticker;
Ec1multi EC(p16,p17,RESOLUTION);
InterruptIn X(p15);
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

DigitalOut out(p20);

void cal()
{
    EC.calOmega();
}

int X_count=0;

void Xcount()
{
    X_count++;
}

int main()
{
    X.rise(&Xcount);
    f.period_us(50);
    b.period_us(50);
    out=1;
    double a=0,r=0.4,v=0;
    int i=0,count;//rで半径指定 a*r=v
    ticker.attach(&cal,0.05);


    while(1) {
        printf("set");
        if(X_count ==1) {
            EC.reset();
            X_count =0;
            break;
        }
    }
    //角度リセット
    out = 0;
    wait(5);
    while(1) {
        printf("%.3f %.3f %d %d\r\n",a,v,X_count,i);
        a=EC.getOmega();
        count=EC.getCount();
        i =count%500;
        v=a*r;
        f=0.45;//速度一定
        b=0.0;
        led1=1;
        led2=0;
        led3=0;
        led4=1;
        if(X_count>3) {
            if(i < -380 && i > -390) {//離す角度を決める
                out=1; //ボールを離す
                printf("shot\r\n");
                led1=1;
                led2=1;
                led3=1;
                led4=1;
                break;
            }
        }
    }
    printf("stop\r\n");
    while(1) {
        printf("%.3f %.3f %d %d stop\r\n",a,v,X_count,i);
        X.rise(&Xcount);
        a=EC.getOmega();
        count=EC.getCount();
        i =count%500;
        f=0;
        b=0;
        led1=0;
        led2=1;
        led3=1;
        led4=0;
    }
}

