#include "mbed.h"
#include "EC.h"
#define RESOLUTION 500
#define V_ARRAY_COUNT_MAX 400

Serial pc(USBTX, USBRX);
DigitalIn Button1(p15);
DigitalIn Button2(p16);
//DigitalOut clutch(p19);
DigitalOut air(p20);
PwmOut motord(p25);
PwmOut motoru(p26);
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
Ec1multi ec(p27,p28,RESOLUTION);
Timer timer;


int main() {
    motoru.period_us(50);
    Button1.mode(PullUp);
    Button2.mode(PullUp);
    //clutch=0;//on
    air=1;//off
    led1=1;
    led2=1;
    led3=1;
    led4=1;
    motoru=0;
    int motor_state=2;
    int led_state=0;
    int omega;
    int read_v_state=0;
    pc.printf("ready to fire");
    int count=ec.getCount();
    float v_array[V_ARRAY_COUNT_MAX][2];
    int v_array_count=0;
    while(1){
        //pc.printf("%d\r\n",count);//確認
        count=ec.getCount();
        omega = ec.getOmega();
        if(Button1==0){
            led1=1;
            led2=0;
            led3=0;
            led4=0;
            //clutch=0;   //on
            air=0;//on
            count=0;
            motoru=0;
            motor_state=0;
            pc.printf("stop\r\n");
        }
        if(Button2==0){
            led2=1;
            led1=0;
            led3=0;
            led4=0;
            motoru=0.5;
            motor_state=1;
            pc.printf("start loading\r\n");
        }
        if (motor_state == 1)
        {
            switch (led_state)
            {
            case 0:
                led1 = 1;
                led2 = 0;
                led3 = 0;
                led4 = 0;
                break;
            case 50:
                led1 = 0;
                led2 = 1;
                led3 = 0;
                led4 = 0;
                break;
            case 100:
                led1 = 0;
                led2 = 0;
                led3 = 1;
                led4 = 0;
                break;
            case 150:
                led1 = 0;
                led2 = 0;
                led3 = 0;
                led4 = 1;
                break;
            }
            led_state++;
            if(led_state>200)led_state=0;
        }
        if (count>4500&&read_v_state==0){
            motoru=0;
            wait(3);
            //clutch=1;   //off
            air=1;//off
            motor_state=0;
            led1=0;
            led2=0;
            led3=0;
            led4=0;
            pc.printf("fire\r\n");
            read_v_state=1;
            timer.reset();
            timer.start();
        }
        ec.calOmega();
        wait_ms(1);
        if (read_v_state == 1)
        {
            if (v_array_count < V_ARRAY_COUNT_MAX)
            {
                v_array[v_array_count][0] = omega * 0.01;
                v_array[v_array_count][1] = timer.read();
                v_array_count++;
            }
            else
            {
                pc.printf("time\tspeed\r\n");
                for (int j = 0; j < V_ARRAY_COUNT_MAX; j++)
                {
                        pc.printf("%f\t%f\r\n", v_array[j][1],v_array[j][0]);
                }
                read_v_state = 0;
            }
        }
    }
}
