#include "mbed.h"
#include "EC.h"
#define RESOLUTION 500
#define V_ARRAY_COUNT_MAX 300

Serial pc(USBTX, USBRX);
DigitalIn Button1(p15);
DigitalIn Button2(p16);
DigitalOut clutch(p19);
PwmOut motord(p25);
PwmOut motoru(p26);
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
Ec1multi ec(p27,p28,RESOLUTION);
Timer timer;


int main() {
    motoru.period_us(50);
    Button1.mode(PullUp);
    Button2.mode(PullUp);
    clutch=0;//on
    led1=1;
    led2=1;
    led3=1;
    motoru=0;
    int motor_state=2;
    int omega;
    int read_v_state=0;
    pc.printf("ready to fire");
    int count=ec.getCount();
    float v_array[V_ARRAY_COUNT_MAX][2];
    int v_array_count=0;
    while(1){
        //pc.printf("%d\r\n",count);//確認
        count=ec.getCount();
        omega = ec.getOmega();
        if(Button1==0){
            led1=1;
            led2=0;
            clutch=1;   //off
            count=0;
            motoru=0;
            motor_state=0;
            pc.printf("stop\r\n");
        }
        if(Button2==0){
            led2=1;
            led1=0;
            motoru=0.5;
            motor_state=1;
            clutch=0;//on
            pc.printf("start loading\r\n");
        } 
        if (count>4500&&read_v_state==0){
            motoru=0;
            wait(3);
            clutch=1;   //off
            motor_state=0;
            led3=0;
            pc.printf("fire\r\n");
            read_v_state=1;
            timer.reset();
            timer.start();
        }

        ec.calOmega();
        wait_ms(10);
        if (read_v_state == 1)
        {
            if (v_array_count < V_ARRAY_COUNT_MAX)
            {
                v_array[v_array_count][0] = omega * 0.02;
                v_array[v_array_count][1] = timer.read();
                v_array_count++;
            }
            else
            {
                pc.printf("time\tspeed\r\n");
                for (int j = 0; j < V_ARRAY_COUNT_MAX; j++)
                {
                    if (v_array[j][0] != 0)
                    {
                        pc.printf("%f\t", v_array[j][1]);
                        pc.printf("%f\r\n", v_array[j][0]);
                    }
                }
                read_v_state = 0;
            }
        }
    }
}
