#include "Utils.h"
#include "USBHost.h"
#include "hci.h"
#include "ps3.h"
#include "User.h"
#include "mbed.h"
#include "math.h"

int RSX,RSY,LSX,LSY,BSU,BSL;
PwmOut servo(p21); //check survo pin
SPI spi(p5,p6,p7);
DigitalOut cs(p8);
int Speed_Mode = 2 ;
int send;


void UserLoopSetting()
{
    spi.format(8,3);
    spi.frequency(1000000);
    servo.pulsewidth_us(1450);
}
void UserLoop(char n,const u8* data)
{
    u16 ButtonState;
    if(n==0) { //有線Ps3USB.cpp
        RSX = ((ps3report*)data)->RightStickX;
        RSY = ((ps3report*)data)->RightStickY;
        LSX = ((ps3report*)data)->LeftStickX;
        LSY = ((ps3report*)data)->LeftStickY;
        BSU = (u8)(((ps3report*)data)->ButtonState & 0x00ff);
        BSL = (u8)(((ps3report*)data)->ButtonState >> 8);
        //ボタンの処理
        ButtonState =  ((ps3report*)data)->ButtonState;
    } else {//無線TestShell.cpp
        RSX = ((ps3report*)(data + 1))->RightStickX;
        RSY = ((ps3report*)(data + 1))->RightStickY;
        LSX = ((ps3report*)(data + 1))->LeftStickX;
        LSY = ((ps3report*)(data + 1))->LeftStickY;
        BSU = (u8)(((ps3report*)(data + 1))->ButtonState & 0x00ff);
        BSL = (u8)(((ps3report*)(data + 1))->ButtonState >> 8);
        //ボタンの処理
        ButtonState =  ((ps3report*)(data + 1))->ButtonState;
    }
    //ここより下にプログラムを書く
    //spi通信用プログラム
    send = 0;
    if((ButtonState >> BUTTONUP)&1 == 1&&(ButtonState >> BUTTONL1)&1 == 1)//UPL1
    {
        send = 84;
    }else if ((ButtonState >> BUTTONDOWN)&1 == 1&&(ButtonState >> BUTTONR1)&1 == 1)//DownR1
    {
        send = 168;
    }else if ((ButtonState >> BUTTONUP)&1 == 1&&(ButtonState >> BUTTONR1)&1 == 1)//UPR1
    {
        send = 148;
    }else if ((ButtonState >> BUTTONDOWN)&1 == 1&&(ButtonState >> BUTTONL1)&1 == 1)//DownL1
    {
        send = 104;
    }else if((ButtonState >> BUTTONUP)&1 == 1) 
    {//対応するボタンを書く(今回上ボタン
        send = 20;
    }else if((ButtonState >> BUTTONDOWN)&1 == 1) 
    {//対応するボタンを書く(今回下ボタン
        send = 40;
    }else if((ButtonState >> BUTTONL1)&1 == 1) 
    {//対応するボタンを書く(今回L1ボタン
        send = 100;
    }else if((ButtonState >> BUTTONR1)&1 == 1) 
    {//対応するボタンを書く(今回R1ボタン
        send = 152;
    }else{
        send = 0;
    }
    if((ButtonState >> BUTTONL2)&1 == 1&&Speed_Mode>1) {//対応するボタンを書く(今回L2ボタン
        Speed_Mode-=1;
        wait(0.1);
    }else if((ButtonState >> BUTTONR2)&1 == 1&&Speed_Mode<3) {//対応するボタンを書く(今回R2ボタン
        Speed_Mode+=1;
        wait(0.1);
    } 
    if((ButtonState >> BUTTONTRIANGEL)&1 == 1) {//対応するボタンを書く(今回△ボタン
        servo.pulsewidth_us(1450);
    } else if((ButtonState >> BUTTONCROSS)&1 == 1) {//対応するボタンを書く(今回×ボタン
        servo.pulsewidth_us(2400);
    }
    send += Speed_Mode;
    spi. write(send);
}