#include "Utils.h"
#include "USBHost.h"
#include "hci.h"
#include "ps3.h"
#include "User.h"
#define speed 0.2
#include "mbed.h"

int RSX,RSY,LSX,LSY,BSU,BSL;
//これより下に関数外に書く要素を記入する
DigitalOut air(p24);
PwmOut motorRB(p22);
PwmOut motorRF(p21);
PwmOut motorLB(p25);
PwmOut motorLF(p26);
SPI spi(p5,p6,p7);
DigitalOut cs(p8);
int send;


void UserLoopSetting()
{
    spi.format(8,3);
    spi.frequency(1000000);
    motorRF.period_ms(1);
    motorRB.period_ms(1);
    motorLF.period_ms(1);
    motorLB.period_ms(1);
}
void UserLoop(char n,const u8* data)
{
    u16 ButtonState;
    if(n==0) { //有線Ps3USB.cpp
        RSX = ((ps3report*)data)->RightStickX;
        RSY = ((ps3report*)data)->RightStickY;
        LSX = ((ps3report*)data)->LeftStickX;
        LSY = ((ps3report*)data)->LeftStickY;
        BSU = (u8)(((ps3report*)data)->ButtonState & 0x00ff);
        BSL = (u8)(((ps3report*)data)->ButtonState >> 8);
        //ボタンの処理
        ButtonState =  ((ps3report*)data)->ButtonState;
    } else {//無線TestShell.cpp
        RSX = ((ps3report*)(data + 1))->RightStickX;
        RSY = ((ps3report*)(data + 1))->RightStickY;
        LSX = ((ps3report*)(data + 1))->LeftStickX;
        LSY = ((ps3report*)(data + 1))->LeftStickY;
        BSU = (u8)(((ps3report*)(data + 1))->ButtonState & 0x00ff);
        BSL = (u8)(((ps3report*)(data + 1))->ButtonState >> 8);
        //ボタンの処理
        ButtonState =  ((ps3report*)(data + 1))->ButtonState;
    }
    //ここより下にプログラムを書く
    //spi通信用プログラム
    send = 0;
    if((ButtonState >> BUTTONUP)&1 == 1) 
    {//対応するボタンを書く(今回上ボタン
        motorRF = 0.2;
        motorRB = 0;
        motorLF = 0.2;
        motorLB = 0;
        send = 0;
    }else if((ButtonState >> BUTTONDOWN)&1 == 1) 
    {//対応するボタンを書く(今回下ボタン
        motorRF = 0;
        motorRB = 0.2;
        motorLF = 0;
        motorLB = 0.2;
        send = 0;
    }else if((ButtonState >> BUTTONL1)&1 == 1) 
    {//対応するボタンを書く(今回L1ボタン
        motorRF = 0.2;
        motorRB = 0;
        motorLF = 0;
        motorLB = 0.2;
        send = 0;
    }else if((ButtonState >> BUTTONR1)&1 == 1) 
    {//対応するボタンを書く(今回R1ボタン
        send = 0;
        motorRF = 0;
        motorRB = 0.2;
        motorLF = 0.2;
        motorLB = 0;
    }else if((ButtonState >> BUTTONRIGHT)&1 == 1)//Right
    {
        send = 4;
        motorRF = 0;
        motorRB = 0.2;
        motorLF = 0.2;
        motorLB = 0;
    }else if((ButtonState >> BUTTONLEFT)&1 == 1)//Left
    {
        send = 3;
        motorRF = 0.2;
        motorRB = 0;
        motorLF = 0;
        motorLB = 0.2;
    }else{
        send = 0;
        motorRF = 0;
        motorRB = 0;
        motorLF = 0;
        motorLB = 0;
    }
    if((ButtonState >> BUTTONCIRCLE)&1 == 1) {//対応するボタンを書く(今回Oボタン
        air=1;
    } else if((ButtonState >> BUTTONCROSS)&1 == 1) {//対応するボタンを書く(今回×ボタン
        air=0;
    }
    if((ButtonState >> BUTTONR2&1) == 1 )//R2 down
    {
        send = 1;
    }else if((ButtonState >> BUTTONL2)&1 == 1)//L2 up
    {
        send = 2;
    }
    spi. write(send);
}