#include "mbed.h"
#include "EC.h"

#define RESOLUTION 500
Ec1multi EC(PA_9,PA_8,RESOLUTION);  //x//1逓倍用class
Ec1multi EC2(PB_3,PB_5,RESOLUTION); //y
void calcOmega();

double PID_x(double aim_x){
    double e_x,Kp,Kd,old_count,Ki,integ_x,P_x,I_x,D_x,PID_x,count;
    count=EC.getCount();
    e_x = aim_x - count;
    Kp = 1/12000;                  //set value
    P_x = Kp * e_x;
    Kd = 1/1000;                  //set value
    I_x = Kd * (count - old_count);
    old_count = count;
    Ki = 1/10000;                  //set value
    integ_x = integ_x + e_x;
    D_x = Ki * integ_x;
    PID_x = P_x + I_x + D_x;
    return PID_x;
}
    
 double PID_y(double aim_y){
    double e_y,Kp,Kd,old_count2,Ki,integ_y,P_y,I_y,D_y,PID_y,count2;
    count2=EC2.getCount();
    e_y = aim_y - count2;
    Kp = 12000;                  //set value
    P_y = Kp * e_y;
    Kd = 1/1000;                  //set value
    I_y = Kd * (count2 - old_count2);
    old_count2 = count2;
    Ki = 1/20000;                  //set value
    integ_y = integ_y + e_y;
    D_y = Ki * integ_y;
    PID_y = P_y + I_y + D_y;
    return PID_y;
}   
