#include "mbed.h"
#include "EthernetInterface.h"
#include "HTTPClient.h"
#include "C12832_lcd.h"
#include <FileSystemLike.h>
#include <FileHandle.h>
#include "LM75B.h"

/* known issues:
1. CIK becomes corrupted after updating bin files on mbed device -or- resets
2. Does not read led1 yet to control LED1 on/off

*/
const char VENDOR[] = "exosite";
const char MODEL[] = "mbed_lpc1768_appbrdv1";

#define WRITE_ALIAS "temp"
#define READ_ALIASES "?screen&led1"

char EXO_CIK_HDR[] = "X-Exosite-CIK: 0000000000000000000000000000000000000000\r\n";
const char EXO_CIK_HDR_FMT[] = "X-Exosite-CIK: %s\r\n";
char EXO_ACCEPT_HDR[] = "Accept: application/x-www-form-urlencoded; charset=utf-8\r\n";
char EXO_CONTYP_HDR[] = "Content-Type: application/x-www-form-urlencoded; charset=utf-8\r\n";
const char EXO_URI[] = "https://m2.exosite.com:443/onep:v1/stack/alias" READ_ALIASES;
// NOTE: Need to specify port due to parsing bug in lib on "onep:v1"
const char EXO_ACTIVATE_URI[] = "https://m2.exosite.com/provision/activate";

#define TIMEOUT 2000
#define BUFFSIZE 1024

AnalogIn aPot1(p19);
Timer send_timer, connection_timer, run_time;

EthernetInterface eth;
HTTPClient http;

LocalFileSystem localfs("local");

static C12832_LCD lcd;
LM75B tmp(p28,p27);

AnalogIn   Pot1(p19);
AnalogIn   Pot2(p20);
DigitalOut Led1Out(LED1);

int main()
{
    int uptime = 0;
    
    run_time.start();
    send_timer.start();

    printf("\r\nStart\r\n");
    
    eth.init(); //Use DHCP
    
    lcd.printf("Exosite HTTP Cloud Demo");
    lcd.locate(0,11);
    lcd.printf("MAC: %s", eth.getMACAddress());
    lcd.locate(0,22);
    lcd.printf("IP:  Requesting From DHCP...");
    
    eth.connect();
    
    printf("IP Address is %s\r\n", eth.getIPAddress());
    printf("MAC Address is %s\r\n", eth.getMACAddress());
    
    lcd.locate(0,22);
    lcd.printf("IP:    %s      ", eth.getIPAddress());
    
    printf("[%f] Running...\r\n", run_time.read());
    
    printf("[%f] Attempting Activation\r\n", run_time.read());
    {
        int ret;
        char incomming_buffer[BUFFSIZE];
        HTTPText hti = HTTPText(incomming_buffer, BUFFSIZE);
        HTTPMap hto = HTTPMap();
        hto.put("vendor", VENDOR);
        hto.put("model", MODEL);
        hto.put("sn", eth.getMACAddress());
        if ((ret = http.post(EXO_ACTIVATE_URI, hto, &hti)) == 0) {
            printf("Success, Got: %s\n", incomming_buffer);
            lcd.locate(0,0);
            sprintf(EXO_CIK_HDR, EXO_CIK_HDR_FMT, incomming_buffer);
            FILE *fp = fopen("/local/cik.txt", "w");
            fprintf(fp, "%s", incomming_buffer);
            fclose(fp);
        } else if (ret == 0) {
            printf("Couldn't Connect to Exosite, Check Network\r\n");
                lcd.locate(0,0);
                lcd.printf("Couldn't Connect to Exosite");
                lcd.locate(0,11);
                lcd.printf("Check Network");
        } else {
            printf("Error %d\r\n", http.getHTTPResponseCode());
            lcd.locate(0,0);
            lcd.printf("Act Error (%d)", http.getHTTPResponseCode());
            FILE *fp = fopen("/local/cik.txt", "r");
            if (fp !=0 && fread(incomming_buffer, 1, 40, fp) == 40) {
                sprintf(EXO_CIK_HDR, EXO_CIK_HDR_FMT, incomming_buffer);
                printf("Found cik in nv: %s\r\n", incomming_buffer);
            } else if (ret != 0) {
                printf("No CIK, Please Re-Enable Device for Activation in Portals\r\n");
                lcd.locate(0,0);
                lcd.printf("No CIK, Re-Enable in Portals");
                lcd.locate(0,22);
                lcd.printf("Then Hard-Reset Board");
                while(1);
            }
            
            if (fp != 0)
                fclose(fp);
        }
    }
    
    while (1) {
        int ret;
        char *key, *value;
        char incomming_buffer[BUFFSIZE];
        char scratch[32];
        char tmp_str[8]={0};
        char uptime_str[8]={0};
        char pot1_str[8]={0};
        char pot2_str[8]={0};
        
        HTTPMap read_map = HTTPMap(incomming_buffer, BUFFSIZE);
        HTTPMap write_map = HTTPMap();
        
        if(tmp.open())
        {
            snprintf(tmp_str, 16, "%.2f", (float)tmp);
            printf("[%f] temp: %s C\r\n", run_time.read(), tmp_str);
            write_map.put("tempc", tmp_str);
        }
        else {
            error("Temp Sensor not detected!\n");
        }
        
        snprintf(pot1_str, 16, "%3.3f", Pot1.read()*100.0f);
        printf("[%f] Pot1: %s %%\r\n", run_time.read(), pot1_str);
        write_map.put("pot1", pot1_str);
        
        snprintf(pot2_str, 16, "%3.3f", Pot2.read()*100.0f);
        printf("[%f] Pot2: %s %%\r\n", run_time.read(), pot2_str);
        write_map.put("pot2", pot2_str);
        
        /*if(Pot1 > 0.3f) {
            Led1Out = 1;
        } else {
            Led1Out = 0;
        }*/
        
        snprintf(uptime_str, 16, "%d", uptime);
        printf("[%f] Uptimer Counter: %s\r\n", run_time.read(), uptime_str);
        write_map.put("uptime", uptime_str);
    
        http.setHeader(0,EXO_CIK_HDR);
        http.setHeader(1,EXO_ACCEPT_HDR);
        //http.setHeader(2,EXO_CONTYP_HDR);
        
        printf("[%f] Making Request...\r\n", run_time.read());
        connection_timer.reset();
        connection_timer.start();
        
        // make request
        ret = http.post(EXO_URI, write_map, &read_map);
        connection_timer.stop();
        printf("[%f] Done! Status: %d, %d\r\n", run_time.read(), ret, http.getHTTPResponseCode());
        lcd.locate(0,0);
        lcd.printf("                       ");
        if (!ret) {
            // write 'screen' dp to screen
            lcd.locate(0,0);
            if (read_map.get("screen", scratch, 32)) {
                lcd.printf(scratch);
            } else {
                lcd.printf("couldn't read 'screen' dp");
            }
            
            // list returned dataports
            while(read_map.pop(key, value)) {
                printf("  %s: %s\r\n", key, value);
            }
        } else {
            lcd.locate(0,0);
            lcd.printf("Error (%d, %d)", ret, http.getHTTPResponseCode());
        }
        
        printf("[%f] Completed in %f seconds.\r\n", run_time.read(), connection_timer.read());
        uptime++;
        wait(5);
    }

}
