#include "mbed.h"


AnalogIn adc_temp(ADC_TEMP);

enum estados {inicio, esperandopulso, mostrartemp, esperandopulsodos   } estado;

const float         AVG_SLOPE   = 4.3E-03;
const float         V30         = 1.43;

DigitalOut led(LED1);
DigitalIn  boton(USER_BUTTON);
float temperatura;
float mediatemp;
int contador;
Timer t;

void estadoinicio() {
    if (boton ==1)
    {
        estado = esperandopulso;
    }
}

void estadoesperandopulso()
{
    if (boton==0) {
        estado = mostrartemp;
        t.reset();
    }
}

void estadomostrartemp()
{
    if (t.read()>4.0) {
        printf("Mostrar la temperatura media %f\n", mediatemp/contador);
        printf("Mostrar el contador %d\n", contador);
        mediatemp = 0;
        contador = 0;
        estado = inicio;

    } else if (boton==1) {
        temperatura= (V30-adc_temp.read()*3.3)/ AVG_SLOPE + 30; // con el plus ese se van sumando todos los valores de la temperatura calculada
        mediatemp+= temperatura;
        contador++;
        printf("La temperatura es de %f\n", temperatura);
        estado= esperandopulsodos;
    }
}

void estadoesperandopulsodos()
{
    if (t.read ()<0.5 && boton ==0) {
        led = !led;
        estado = inicio;
    } else if (t.read()>0.5) {
        estado= inicio;
    }
}

int main()
{
    estado=inicio;
    t.start();
    while(1) {
        switch (estado) {
            case inicio:
                estadoinicio();
                break;
            case esperandopulso:
                estadoesperandopulso();
                break;
            case mostrartemp:
                estadomostrartemp();
                break;
            case esperandopulsodos:
                estadoesperandopulsodos();
                break;
        }
    }
}
