#include "mbed.h"
#include "EthernetInterface.h"
#include "Websocket.h"

#define _DHCP
//#define _USE_WIZ550io
DigitalOut myled(LED1);

int main()
{
#if defined(TARGET_LPC1114)
    SPI spi(dp2, dp1, dp6); // mosi, miso, sclk
    EthernetInterfaceW5500 eth(&spi, dp25, dp26); // spi, cs, reset

#elif defined(TARGET_LPC1768)
    SPI spi(p11, p12, p13); // mosi, miso, sclk
    EthernetInterfaceW5500 eth(&spi, p14, p15); // spi, cs, reset

#elif defined(TARGET_LPC11U68)
    SPI spi(P0_9, P0_8, P1_29); // mosi, miso, sclk
    EthernetInterfaceW5500 eth(&spi, P0_2, P1_28);//scs(P0_2), nRESET(P1_28)
    spi.format(8,0); // 8bit, mode 0
    spi.frequency(7000000); // 7MHz
    wait(1); // 1 second for stable state
#elif defined(TARGET_KL25Z)
    Serial pc(USBTX, USBRX);
    pc.baud(115200);
    printf("spi init\r\n");
    SPI spi(D11, D12, D13); // mosi, miso, sclk
    wait(1); // 1 second for stable state
    EthernetInterface eth(&spi, D10, D9);//scs(D10), nRESET(PTA20)
    printf("App Start\r\n");
    wait(1); // 1 second for stable state
#endif

#ifndef _USE_WIZ550io
   // as your env. change to real MAC address; 
   uint8_t mac_addr[6] = {0x00, 0x08, 0xdc, 0x1c, 0xb8, 0x4a}; // for example
#endif
   
#ifdef _DHCP

#ifdef _USE_WIZ550io
    eth.init(); 
#else
    eth.init((uint8_t *)mac_addr); //Use DHCP
#endif    
    eth.connect();
    //printf("IP Address is %s\n\r", eth.getIPAddress());
    printf("Initialized, MAC: %s\n", eth.getMACAddress());
    printf("Connected, IP: %s, MASK: %s, GW: %s\n",
           eth.getIPAddress(), eth.getNetworkMask(), eth.getGateway());

#else
    // as your env. change to real IP address and so on.
#ifdef _USE_WIZ550io
    //int ret = eth.init("222.98.173.212", "255.255.255.192", "222.98.173.254");
    int ret = eth.init("192.168.77.10", "255.255.255.0", "192.168.77.1");
#else
    int ret = eth.init((uint8_t *)mac_addr, "192.168.77.10", "255.255.255.0", "192.168.77.1");
#endif    
    if (!ret) {
        printf("Initialized, MAC: %s\n", eth.getMACAddress());
        printf("Connected, IP: %s, MASK: %s, GW: %s\n",
               eth.getIPAddress(), eth.getNetworkMask(), eth.getGateway());
    } else {
        printf("Error eth.init() - ret = %d\n", ret);
        return -1;
    }

#endif

//    Websocket ws("ws://sockets.mbed.org:443/ws/demo/wo");
//    ws.connect();

    // this code from http://mbed.org/teams/mbed/code/Websocket_Ethernet_HelloWorld/file/bd0a76c1d9d0/main.cpp
    // view @ http://sockets.mbed.org/demo/viewer
    Websocket ws("ws://sockets.mbed.org:443/ws/demo/rw");
    ws.connect();

    char str[100];
    for(int i=0; i<0x10; ++i) {
        sprintf(str, "%d WebSocket for WIZnet W5500 Hello World over Ethernet : No Sensor", i);
        ws.send(str);

        // clear the buffer and wait a sec...
        memset(str, 0, 100);
        wait(0.5f);

        // websocket server should echo whatever we sent it
        if (ws.read(str)) {
            printf("rcv'd: %s\n", str);
        }
    }
    ws.close();
    eth.disconnect();

    while(1) {
        myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.2);
    }
}
