#include "mbed.h"
#include "EthernetInterface.h"
#include "Websocket.h"

DigitalOut myled(LED1);

int main()
{
    printf("Start Websocket Demo. \r\n");
    
#if defined(TARGET_LPC1114)
    SPI spi(dp2, dp1, dp6); // mosi, miso, sclk
    EthernetInterface eth(&spi, dp25, dp26); // spi, cs, reset

#elif defined(TARGET_LPC1768)
    SPI spi(p11, p12, p13); // mosi, miso, sclk
    EthernetInterface eth(&spi, p14, p15); // spi, cs, reset

#elif defined(TARGET_LPC11U68)
    SPI spi(P0_9, P0_8, P1_29); // mosi, miso, sclk
//WIZnetInterface eth(&spi, P0_2, P1_25); // spi, cs, reset
//SPI spi(p5, p6, p7); // mosi, miso, sclk
    EthernetInterface eth(&spi, P0_2, P1_28);//, nRESET(p9); // reset pin is dummy, don't affect any pin of WIZ550io
    spi.format(8,0); // 8bit, mode 0
    spi.frequency(7000000); // 7MHz
    wait(1); // 1 second for stable state

#endif

    eth.init(); //Use DHCP
    printf("Initialized, MAC: %s\r\n", eth.getMACAddress());
    eth.connect();
    //printf("IP Address is %s\n\r", eth.getIPAddress());
    printf("Connected, IP: %s, MASK: %s, GW: %s\r\n",eth.getIPAddress(), eth.getNetworkMask(), eth.getGateway());
/*
    // as your env. change to real IP address and so on.
    //int ret = eth.init(your IP, Subnet, Gateway);
    int ret = eth.init("xxx.xxx.xxx.xxx", "255.255.255.0", "yyy.yyy.yyy.yyy");
    if (!ret) {
        printf("Initialized, MAC: %s\r\n", eth.getMACAddress());
        printf("Connected, IP: %s, MASK: %s, GW: %s\r\n",
               eth.getIPAddress(), eth.getNetworkMask(), eth.getGateway());
    } else {
        printf("Error eth.init() - ret = %d\r\n", ret);
        return -1;
    }
*/

//    Websocket ws("ws://sockets.mbed.org:443/ws/demo/wo");
//    ws.connect();

    // this code from http://mbed.org/teams/mbed/code/Websocket_Ethernet_HelloWorld/file/bd0a76c1d9d0/main.cpp
    // view @ http://sockets.mbed.org/demo/viewer
    Websocket ws("ws://sockets.mbed.org:443/ws/demo/rw");
    ws.connect();

    char str[100];
 
    for(int i=0; i<0x10; ++i) {

        sprintf(str, "%dth WebSocket message for WIZnet W5500 Hello World over Ethernet.", i);
        ws.send(str);
        // clear the buffer and wait a sec...
        memset(str, 0, 100);
        wait(0.5f);

        // websocket server should echo whatever we sent it
        if (ws.read(str)) {
            printf("Recv : %s\r\n", str);
        }
    }
    ws.close();
    eth.disconnect();

    while(1) {
        myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.2);
    }
}
