#include "mbed.h"
#include "EthernetInterface.h"
#include "Websocket.h"
 
 
int main() {
    char recv[30];
 
//    EthernetInterface eth;
// change for W5500 interface.
#if defined(TARGET_LPC1114)
    SPI spi(dp2, dp1, dp6); // mosi, miso, sclk
    EthernetInterface eth(&spi, dp25, dp26); // spi, cs, reset

#elif defined(TARGET_LPC1768)
    SPI spi(p11, p12, p13); // mosi, miso, sclk
    EthernetInterface eth(&spi, p14, p15); // spi, cs, reset

#elif defined(TARGET_LPC11U68)
    SPI spi(P0_9, P0_8, P1_29); // mosi, miso, sclk
    EthernetInterface eth(&spi, P0_2, P1_28);//, nRESET(p9); // reset pin is dummy, don't affect any pin of WIZ550io
    spi.format(8,0); // 8bit, mode 0
    spi.frequency(7000000); // 7MHz
    wait(1); // 1 second for stable state
#endif
    
    eth.init(); //Use DHCP
    eth.connect();
    printf("IP Address is %s\n\r", eth.getIPAddress());
 
    Websocket ws("ws://sockets.mbed.org:443/ws/demo/wo");
    ws.connect();
 
    while (1) {
        ws.send("WebSocket Hello World over Ethernet");
        wait(1.0);
    }
}