#include "mbed.h"
#include "EthernetInterface.h"
#include <stdio.h>
#include <string.h>
#include "PPPoE.h"


/////////////////////////////////////////
// SOCKET NUMBER DEFINION for Examples //
/////////////////////////////////////////
#define SOCK_TCPS        1
#define SOCK_UDPS        2



////////////////////////////////////////////////
// Shared Buffer Definition for LOOPBACK TEST //
////////////////////////////////////////////////
#define DATA_BUF_SIZE   2048
uint8_t gDATABUF[DATA_BUF_SIZE];


///////////////////////////////////
// Default Network Configuration //
///////////////////////////////////
/*
wiz_NetInfo gWIZNETINFO = { .mac = {0x00, 0x08, 0xdc,0x00, 0xab, 0xcd},
                            .ip = {192, 168, 200, 123},
                            .sn = {255,255,255,0},
                            .gw = {192, 168, 200, 1},
                            .dns = {0,0,0,0},
                            .dhcp = NETINFO_STATIC };
*/

///////////////////////////////////////
// ID and Password for PAP for PPPoE //
///////////////////////////////////////
//TODO : fill these variables before start ppp_init
uint8_t pppoe_id[] = "wiznet";
uint8_t pppoe_id_len = 6;
uint8_t pppoe_pw[] = "wiz1206";
uint8_t pppoe_pw_len = 7;
uint8_t pppoe_ip[4] = {0,};
uint8_t pppoe_pdns[4] = {0,};
uint8_t pppoe_sdns[4] = {0,};
uint16_t pppoe_retry_count = 0;



int main() {
//    EthernetInterface eth;
// change for W5500 interface.
#if defined(TARGET_LPC1114)
    SPI spi(dp2, dp1, dp6); // mosi, miso, sclk
    EthernetInterface eth(&spi, dp25, dp26); // spi, cs, reset

#elif defined(TARGET_LPC1768)
    SPI spi(p11, p12, p13); // mosi, miso, sclk
    EthernetInterface eth(&spi, p14, p15); // spi, cs, reset
#elif defined(TARGET_LPC11U68)
    SPI spi(P0_9, P0_8, P1_29); // mosi, miso, sclk
    EthernetInterface eth(&spi, P0_2, P1_28);//, nRESET(p9); // reset pin is dummy, don't affect any pin of WIZ550io
    spi.format(8,0); // 8bit, mode 0
    spi.frequency(7000000); // 7MHz
    wait(1); // 1 second for stable state
#elif defined(TARGET_KL25Z)
    Serial pc(USBTX, USBRX);
    pc.baud(115200);
    printf("spi init\r\n");
    SPI spi(D11, D12, D13); // mosi, miso, sclk
    wait(1); // 1 second for stable state
    EthernetInterface eth(&spi, D10, D9);//scs(D10), nRESET(PTA20)
    printf("App Start\r\n");
    wait(1); // 1 second for stable state
    wait(1); // 1 second for stable state
#elif defined (TARGET_NUCLEO_F030R8)
    Serial pc(USBTX, USBRX);
    pc.baud(115200);
    SPI spi(SPI_MOSI, SPI_MISO, SPI_SCK); // mosi, miso, sclk
    EthernetInterface eth(&spi, PB_6, PA_9);//, nRESET(p9); // reset pin is dummy, don't affect any pin of WIZ550io
    spi.format(8,0); // 8bit, mode 0
    spi.frequency(7000000); // 7MHz
    wait(1); // 1 second for stable state
#elif defined (TARGET_NUCLEO_F334R8)
    Serial pc(USBTX, USBRX);
    pc.baud(115200);
    SPI spi(SPI_MOSI, SPI_MISO, SPI_SCK); // mosi, miso, sclk
    EthernetInterface eth(&spi, PB_6, PA_9);//, nRESET(p9); // reset pin is dummy, don't affect any pin of WIZ550io
    spi.format(8,0); // 8bit, mode 0
    spi.frequency(7000000); // 7MHz
    wait(1); // 1 second for stable state
#endif


    int8_t tmp = 0;
    uint8_t mac_addr[6] = {0x00, 0x08, 0xdc,0x00, 0xab, 0xcd};
    int32_t ret;
    uint8_t str[15];

    printf("platform init done\r\n");
    
    
    /* PHY link status check */

    do
    {
        if(eth.getPHYCFGR() & PHYCFGR_LNK_ON)
            tmp = PHY_LINK_ON;
        else
            tmp = PHY_LINK_OFF;
            
        if(tmp == -1)
            printf("Unknown PHY Link stauts.\r\n");
    }while(tmp == PHY_LINK_OFF);


    /* Network initialization */    
    eth.init((uint8_t *)mac_addr, "192.168.200.123", "255.255.255.0", "192.168.200.1");

    printf("\r\n====== MACRAW:PPPoE Start ======\r\n");


    PPPOEClient pppoe;

    while(1)
    {
        ret = pppoe.ppp_start(gDATABUF);//ppp start function
        if(ret == PPP_SUCCESS || pppoe_retry_count > PPP_MAX_RETRY_COUNT) break;    // PPPoE Connected or connect failed by over retry count

    }



    if(ret == PPP_SUCCESS)//1 : success
    {

        printf("\r\n<<<< PPPoE Success >>>>\r\n");
        printf("Assigned IP address : %.3u.%.3u.%.3u.%.3u\r\n", pppoe_ip[0], pppoe_ip[1], pppoe_ip[2], pppoe_ip[3]);

        printf( "\r\n==================================================\r\n");
        printf( "    AFTER PPPoE, Net Configuration Information        \r\n");
        printf( "==================================================\r\n");


        eth.getSHAR(str);
        printf( "MAC address  : %x:%x:%x:%x:%x:%x\r\n", str[0], str[1], str[2], str[3], str[4], str[5] );
        eth.getSUBR(str);
        printf( "SUBNET MASK  : %.3u.%.3u.%.3u.%.3u\r\n", str[0], str[1], str[2], str[3] );
        eth.getGAR(str);
        printf( "G/W IP ADDRESS : %.3u.%.3u.%.3u.%.3u\r\n",str[0], str[1], str[2], str[3]);
        eth.getSIPR(str);
        printf( "SOURCE IP ADDRESS : %.3u.%.3u.%.3u.%.3u\r\n\r\n", str[0], str[1], str[2], str[3]);


    }
    else//failed
    {
        printf("\r\n<<<< PPPoE Failed >>>>\r\n");
        eth.init((uint8_t *)mac_addr, "192.168.200.123", "255.255.255.0", "192.168.200.1");
    }



    /*******************************/
    /* WIZnet W5500 Code Examples  */
    /* TCPS/UDPS Loopback test     */
    /*******************************/
    /* Main loop */
    /*
    while(1)
    {
        // Loopback Test
        // TCP server loopback test
        if( (ret = loopback_tcps(SOCK_TCPS, gDATABUF, 5000)) < 0) {
            printf("SOCKET ERROR : %ld\r\n", ret);
        }

        // UDP server loopback test
        if( (ret = loopback_udps(SOCK_UDPS, gDATABUF, 3000)) < 0) {
            printf("SOCKET ERROR : %ld\r\n", ret);
        }
    } // end of Main loop
    */
} // end of main()



