#include "mbed.h"
#include "W5500Interface/EthernetInterface.h"
#include "xively.h"
#include "xi_err.h"

#define XI_FEED_ID YOUR-FEED-ID // set Xively Feed ID (numerical, no quoutes)
#define XI_API_KEY "Your API Key" // set Xively API key (double-quoted string)

//Serial pc(USBTX, USBRX);
DigitalOut myled(LED1);

#define _SENSOR_DS18B20

#ifdef _SENSOR_DS18B20 // if there is sensor.
#include "DS18B20.h"
#endif

#define _DHCP


int main()
{
#if defined(TARGET_LPC1114)
    SPI spi(dp2, dp1, dp6); // mosi, miso, sclk
    EthernetInterface eth(&spi, dp25, dp26); // spi, cs, reset
    DS18B20 sensor(D3, DS18B20::RES_12_BIT); // Dallas 1-wire
#elif defined(TARGET_LPC1768)
    SPI spi(p11, p12, p13); // mosi, miso, sclk
    EthernetInterface eth(&spi, p14, p15); // spi, cs, reset
#elif defined(TARGET_LPC11U68)
    SPI spi(P0_9, P0_8, P1_29); // mosi, miso, sclk
    EthernetInterface eth(&spi, P0_2, P1_28);//, nRESET(p9); // reset pin is dummy, don't affect any pin of WIZ550io
    spi.format(8,0); // 8bit, mode 0
    spi.frequency(7000000); // 7MHz
    wait(1); // 1 second for stable state
    DS18B20 sensor(P1_25, DS18B20::RES_12_BIT); // Dallas 1-wire
#elif defined(TARGET_KL25Z)
    Serial pc(USBTX, USBRX);
    pc.baud(115200);
    printf("spi init\r\n");
    SPI spi(D11, D12, D13); // mosi, miso, sclk
    wait(1); // 1 second for stable state
    EthernetInterface eth(&spi, D10, D9);//scs(D10), nRESET(PTA20)
    printf("App Start\r\n");
    wait(1); // 1 second for stable state
    DS18B20 sensor(D3, DS18B20::RES_12_BIT); // Dallas 1-wire
#elif defined(TARGET_NUCLEO_F030R8)    
    Serial pc(USBTX, USBRX);
    pc.baud(115200);
    printf("spi init\r\n");
    SPI spi(D11, D12, D13); // mosi, miso, sclk
    wait(1); // 1 second for stable state
    EthernetInterface eth(&spi, D10, D9);//scs(D10), nRESET(PTA20)
    printf("App Start\r\n");
    wait(1); // 1 second for stable state
#endif

#ifdef _DHCP // didn't test yet in DHCP
    eth.init(); //Use DHCP
    eth.connect();
    printf("Initialized, MAC: %s\n", eth.getMACAddress());
    printf("Connected, IP: %s, MASK: %s, GW: %s\n",
           eth.getIPAddress(), eth.getNetworkMask(), eth.getGateway());
#else
    // as your env. change to real IP address and so on.
    int ret = eth.init("222.98.173.211", "255.255.255.192", "222.98.173.254");
    if (!ret) {
        printf("Initialized, MAC: %s\n", eth.getMACAddress());
        printf("Connected, IP: %s, MASK: %s, GW: %s\n",
               eth.getIPAddress(), eth.getNetworkMask(), eth.getGateway());
    } else {
        printf("Error eth.init() - ret = %d\n", ret);
        return -1;
    }
#endif

// Sensor variables
#ifdef _SENSOR_DS18B20 // if there is sensor.
    char sensorBuf[25];

//Before using this sensor, should called sensor.count() once.
   printf("DS18B20 Configuration\n\r");
   DS18B20::ROM_Code_t ROM_Code;
   sensor.ReadROM(&ROM_Code);
   printf("Family code: 0x%X\n\r", ROM_Code.BYTES.familyCode);
   printf("Serial Number: ");
   for (unsigned i = 6; i != 0; --i) {
       printf("%02X%s", ROM_Code.BYTES.serialNo[i-1], (i != 1)?":":"\r\n");
   }
   printf("CRC: 0x%X\r\n", ROM_Code.BYTES.CRC);
/*
   printf("\n\rRunning temperature conversion...\n\r");
   while (1) {
       printf("Temperature is: %.4fC\n\r", sensor.GetTemperature());
       wait(10);
   }
*/    
#endif

    xi_feed_t feed;
    memset( &feed, NULL, sizeof( xi_feed_t ) );

    feed.feed_id = XI_FEED_ID;
    feed.datastream_count = 1;

    feed.datastreams[0].datapoint_count = 1;
    xi_datastream_t* orientation_datastream = &feed.datastreams[0];
    strcpy( orientation_datastream->datastream_id, "Channel_Test1" );
    xi_datapoint_t* current_orientation = &orientation_datastream->datapoints[0];

    // create the cosm library context
    xi_context_t* xi_context
    = xi_create_context( XI_HTTP, XI_API_KEY, feed.feed_id );

    // check if everything works
    if( xi_context == NULL ) {
        return -1;
    }

    while(1) {
#ifdef _SENSOR_DS18B20 // if there is sensor.
/*
        if (sensor_cnt) {
            result = sensor.startReading(true);     // start sensor readings and wait
            if (result == DS18X20_OK) {
                sensor.getReading(sensorBuf, 0);         // get result into buf
                xi_set_value_str( current_orientation, sensorBuf );
            }
            else
            {
                xi_set_value_str( current_orientation, "0" );
                }
            
        } else {
            printf("No Sensor");
        }
*/
        // use New library for DS18B20
        sprintf(sensorBuf,"%4.2f", sensor.GetTemperature());
        printf("Sensor Buf : %s\r\n",sensorBuf);
        xi_set_value_str( current_orientation, sensorBuf );
#else
        xi_set_value_str( current_orientation, "27" );
#endif

        printf( "update..." );
        // send to xively server
        xi_feed_update( xi_context, &feed );
        printf( "done...\r\n" );
        wait( 5.0 );
    }
}
