#include "mbed.h"
#include "EthernetInterface.h"
//#include "EthernetInterfaceW5500.h"
#include <stdio.h>
#include <string.h>

//#define PORT   80
#define PORT   888
#define _DHCP

// move to main().
//EthernetInterface eth;

// move to main().
//TCPSocketServer svr;
bool serverIsListened = false;

// move to main().
//TCPSocketConnection client;
bool clientIsConnected = false;
DigitalOut led1(LED1); //server listning status
DigitalOut led2(LED2); //socket connecting status

Ticker ledTick;

void ledTickfunc()
{
    if(serverIsListened)  {
        led1 = !led1;
    } else {
        led1 = false;
    }
}

int main (void)
{
#if defined(TARGET_LPC1114)
    SPI spi(dp2, dp1, dp6); // mosi, miso, sclk
    EthernetInterface eth(&spi, dp25, dp26); // spi, cs, reset

#elif defined(TARGET_LPC1768)
    SPI spi(p11, p12, p13); // mosi, miso, sclk
    EthernetInterface eth(&spi, p14, p15); // spi, cs, reset

#elif defined(TARGET_LPC11U68)
    SPI spi(P0_9, P0_8, P1_29); // mosi, miso, sclk
    EthernetInterface eth(&spi, P0_2, P1_28);//, nRESET(p9); // reset pin is dummy, don't affect any pin of WIZ550io
    spi.format(8,0); // 8bit, mode 0
    spi.frequency(7000000); // 7MHz
    wait(1); // 1 second for stable state
#elif defined (TARGET_NUCLEO_F030R8)
    SPI spi(SPI_MOSI, SPI_MISO, SPI_SCK); // mosi, miso, sclk
    EthernetInterface eth(&spi, PB_6, PA_9);//, nRESET(p9); // reset pin is dummy, don't affect any pin of WIZ550io
    spi.format(8,0); // 8bit, mode 0
    spi.frequency(7000000); // 7MHz
    wait(1); // 1 second for stable state

#endif

    // late binding 
    TCPSocketServer svr;
    TCPSocketConnection client;

    ledTick.attach(&ledTickfunc,0.5);

    /*
        //setup ethernet interface
        eth.init(); //Use DHCP
        eth.connect();
        printf("IP Address is %s\n\r", eth.getIPAddress());
    */

    printf("Board is on\r\n");
    
#ifdef _DHCP 
// didn't test yet in DHCP => TEST OK...

    printf("eth.init()\r\n");
    eth.init(); //Use DHCP
    printf("eth.connect()\r\n");
    eth.connect();
    //printf("IP Address is %s\n\r", eth.getIPAddress());
    printf("Initialized, MAC: %s\n", eth.getMACAddress());
    printf("Connected, IP: %s, MASK: %s, GW: %s\n",
           eth.getIPAddress(), eth.getNetworkMask(), eth.getGateway());

#else
    // as your env. change to real IP address and so on.
    int ret = eth.init("222.98.173.212", "255.255.255.192", "222.98.173.254");
    if (!ret) {
        printf("Initialized, MAC: %s\n", eth.getMACAddress());
        printf("Connected, IP: %s, MASK: %s, GW: %s\n",
               eth.getIPAddress(), eth.getNetworkMask(), eth.getGateway());
    } else {
        printf("Error eth.init() - ret = %d\n", ret);
        return -1;
    }
#endif

    //setup tcp socket
    if(svr.bind(PORT)< 0) {
        printf("tcp server bind failed.\n\r");
        return -1;
    } else {
        printf("tcp server bind successed.\n\r");
        serverIsListened = true;
    }

    if(svr.listen(1) < 0) {
        printf("tcp server listen failed.\n\r");
        return -1;
    } else {
        printf("tcp server is listening...\n\r");
    }

    //listening for http GET request
    while (serverIsListened) {
        //blocking mode(never timeout)
        if(svr.accept(client)<0) {
            printf("failed to accept connection.\n\r");
        } else {
            printf("connection success!\n\rIP: %s\n\r",client.get_address());
            clientIsConnected = true;
            led2 = true;

            while(clientIsConnected) {
                char buffer[1024] = {};
                switch(client.receive(buffer, 1023)) {
                    case 0:
                        printf("recieved buffer is empty.\n\r");
                        clientIsConnected = false;
                        break;
                    case -1:
                        printf("failed to read data from client.\n\r");
                        clientIsConnected = false;
                        break;
                    default:
                        printf("Recieved Data: %d\n\r\n\r%.*s\n\r",strlen(buffer),strlen(buffer),buffer);
                        if(buffer[0] == 'G' && buffer[1] == 'E' && buffer[2] == 'T' ) {
                            printf("GET request incomming.\n\r");
                            //setup http response header & data
                            char echoHeader[256] = {};
                            sprintf(echoHeader,"HTTP/1.1 200 OK\n\rContent-Length: %d\n\rContent-Type: text\n\rConnection: Close\n\r\n\r",strlen(buffer));
                            client.send(echoHeader,strlen(echoHeader));
                            client.send(buffer,strlen(buffer));
                            clientIsConnected = false;
                            printf("echo back done.\n\r");
                        }
                        break;
                }
            }
            printf("close connection.\n\rtcp server is listening...\n\r");
            client.close();
            led2 = false;
        }
    }
}
