#include "mbed.h"
#include "W5500Interface/EthernetInterface.h"
#include "HTTPClient.h"

 
int main() {
//    EthernetInterface eth;
// change for W5500 interface.
#if defined(TARGET_LPC1114)
    SPI spi(dp2, dp1, dp6); // mosi, miso, sclk
    EthernetInterface eth(&spi, dp25, dp26); // spi, cs, reset

#elif defined(TARGET_LPC1768)
    SPI spi(p11, p12, p13); // mosi, miso, sclk
    EthernetInterface eth(&spi, p14, p15); // spi, cs, reset
#elif defined(TARGET_LPC11U68)
    SPI spi(P0_9, P0_8, P1_29); // mosi, miso, sclk
    EthernetInterface eth(&spi, P0_2, P1_28);//, nRESET(p9); // reset pin is dummy, don't affect any pin of WIZ550io
    spi.format(8,0); // 8bit, mode 0
    spi.frequency(7000000); // 7MHz
    wait(1); // 1 second for stable state
#elif defined(TARGET_KL25Z)
    Serial pc(USBTX, USBRX);
    pc.baud(115200);
    printf("spi init\r\n");
    SPI spi(D11, D12, D13); // mosi, miso, sclk
    wait(1); // 1 second for stable state
    EthernetInterface eth(&spi, D10, D9);//scs(D10), nRESET(PTA20)
    printf("App Start\r\n");
    wait(1); // 1 second for stable state
#endif
    eth.init(); //Use DHCP
    eth.connect();

    printf("IP Address is %s\r\n", eth.getIPAddress());
    
    char str[512];
    char get_msg[512]= "http://api.openweathermap.org/data/2.5/weather?q=Seoul";
    HTTPClient http;
    
    printf("Send get Message to openeathermap.org\r\n");
    printf("msg : %s\r\n",get_msg);
    int ret = http.get(get_msg, str, sizeof(str));
    if(!ret)
    {
      printf("\r\nPage fetched successfully - read %d characters\r\n", strlen(str));
      printf("Result: %s\r\n", str);
    }
    else
    {
      printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
    }
   
}
