/*

 _______  ______ ______ _______ _______ _______ _       
(_______)/ _____|_____ (_______|_______|_______|_)      
 _____  ( (____  _____) )     _    _    _____   _       
|  ___)  \____ \|  ____/ |   | |  | |  |  ___) | |      
| |_____ _____) ) |    | |___| |  | |  | |_____| |_____ 
|_______|______/|_|     \_____/   |_|  |_______)_______)

    (C)2016 Espotel Oy/Etteplan Oyj
Description: Main code for LORA radio code template
License: Revised BSD License, see LICENSE.TXT file include in the project
Maintainer: Pasi Pulkkinen
Latest modifier: Teemu Koskinen
Version 1.0b (b represents Serial port driven branch/fork)
*/

#include "mbed.h"
#include "RadioHandler.h"
#include "Comissioning.h"

/* --- Important notes! --- */
/* Original comments */
// 1: USE_BAND_868 has been defined in LoRaMac-board.h
// 2: OVER_THE_AIR_ACTIVATION at Comissioning.h is enabled
// 3: LORAWAN_PUBLIC_NETWORK at Comissioning.h is true

/* Configurable parameters through serial port after ButtonPressed */
// 4: LORAWAN_DEVICE_EUI at Comissioning.h should be unique for each board
// 5: LORAWAN_APPLICATION_EUI at Comissioning.h should be unique for each conduit. Copy this to conduit network ID EUI
// 6: LORAWAN_APPLICATION_KEY at Comissioning.h ensures secure end to end communication. Copy this to conduit network key

/* I am currently using Conduit 1.2.2 and this bugfix is not necessary anymore */
// 7: dConduitBugs at LoRaMac.cpp patches a bug in Multitech Conduit Firmware 1.1.2 2016-01-13T09:59:04

/* Serial port communication expanded */
// 8: Up to 100 characters from Serial port are sent to gateway by presseing enter (\n)
// 9: Button pressed prints current setup values and possibility to congigure them.

/* -- Latest updates -- */
//Version 1.0b
//RadioHandler contains lot of new funtions
/* Some of these functions should not be here cause they are not about radio handling. Refactoring is recommended if this branch is continued */


DigitalOut Led1(LED1);
static bool ButtonPressed = false;

//ELMO Pushbutton interrupt
void ButtonHandler( void )
{
    ButtonPressed = true;
}

//Main application entry point.
int main( void )
{
    char XmitBuffer[100]; // Max 16 bytes in LoRa packet!
    char data[100];
    uint16_t index = 0;
    InterruptIn pushButton(USER_BUTTON);
    Serial debugPort(SERIAL_TX, SERIAL_RX);
    debugPort.baud(9600);
    debugPort.printf("\r\n\r\nELMO Debug Screen\r\n");
    pushButton.rise(&ButtonHandler);
    pushButton.enable_irq();
    RadioInit();

    while( 1 )
    {
        /* Device waits for ButtongPressed or readable input */ 
        /* If readable and enter (\n) given device will send given message */    
        if (debugPort.readable()) {
            data[index]=debugPort.getc();
            
            if (data[index]=='\n'){
                debugPort.printf("Your input was: %s\r\n", data);
                sprintf(XmitBuffer, "%s\r\n", data);
                Led1 = !Led1;
                RequestPacketTx(XmitBuffer, false);
                memset(data,' ', sizeof(data));
                index=0;
                }
            index++;
            if (index>100) {
                index=0;
                }
        }  
        /* ButtonPressed enters the config menu */                
        if (ButtonPressed)
        {        
            debugPort.printf("\r\nButton was pressed\r\n");
            RadioSetup();
            debugPort.printf("JOB DONE\r\n");
            Led1 = !Led1;
            //State/Status resets for next time
            ButtonPressed = false;
        }
        /* Scheduled communication */
        RadioHandler();
    }
}