/*

 _______  ______ ______ _______ _______ _______ _       
(_______)/ _____|_____ (_______|_______|_______|_)      
 _____  ( (____  _____) )     _    _    _____   _       
|  ___)  \____ \|  ____/ |   | |  | |  |  ___) | |      
| |_____ _____) ) |    | |___| |  | |  | |_____| |_____ 
|_______|______/|_|     \_____/   |_|  |_______)_______)

    (C)2016 Espotel Oy/Etteplan Oyj
Description: Main code for LORA radio code template
License: Revised BSD License, see LICENSE.TXT file include in the project
Maintainer: Pasi Pulkkinen
Version 1.0
*/

#include "mbed.h"
#include "RadioHandler.h"

// --- Important notes! ---
// USE_BAND_868 has been defined in LoRaMac-board.h
// OVER_THE_AIR_ACTIVATION at Comissioning.h is enabled
// LORAWAN_PUBLIC_NETWORK at Comissioning.h is true
// LORAWAN_DEVICE_EUI at Comissioning.h should be unique for each board
// LORAWAN_APPLICATION_EUI at Comissioning.h should be unique for each conduit. Copy this to conduit network ID EUI
// LORAWAN_APPLICATION_KEY at Comissioning.h ensures secure end to end communication. Copy this to conduit network key
// dConduitBugs at LoRaMac.cpp patches a bug in Multitech Conduit Firmware 1.1.2 2016-01-13T09:59:04

DigitalOut Led1(LED1);

/*
 * True if ELMO button was pressed
 */
static bool ButtonPressed = false;

/*
    ELMO Pushbutton interrupt
*/
void ButtonHandler( void )
{
    ButtonPressed = true;
}

/**
 * Main application entry point.
 */
int main( void )
{
    char XmitBuffer[100]; // Max 16 bytes in LoRa packet!
    uint16_t PacketCount = 0;
    InterruptIn pushButton(USER_BUTTON);
    Serial debugPort(SERIAL_TX, SERIAL_RX);

    debugPort.baud(9600);

    debugPort.printf("\r\n\r\nELMO Debug Screen\r\n");

    pushButton.rise(&ButtonHandler);
    pushButton.enable_irq();

    RadioInit();

    while( 1 )
    {
        // Show some debug stuff in case Elmo button is pressed. Request packet transmission
        if (ButtonPressed)
        {
            debugPort.printf("\r\nButton was pressed\r\n");
            Led1 = !Led1;
            sprintf(XmitBuffer, "Elmo calling %d", PacketCount);
            RequestPacketTx(XmitBuffer, true);  // true = enable periodic transmissions. False = send just one packet
            if(PacketCount < 99)
            {
                PacketCount++;
            }
            else
            {
                // Start from 1 when 99 is reached
                PacketCount = 1;
            }
            ButtonPressed = false;
        }

        RadioHandler();
    }
}