#include "mbed.h"
#include "sx1272-hal.h"
#include "Terminal.h"
#include "Settings.h"

#include "stdint.h"
#include "dbg.h"

#include "PingPongCmd.h"


Variable::ValueDescription frequencyValues[] =
        {{860000, "kHz"}, {1020000, 0}, {0,0} };
Variable::ValueDescription powerValues[] =
        {{-1, "dBm"}, {20, 0}, {0,0} };
Variable::ValueDescription bandwidthValues[] =
        {{0, "125 kHz"}, {1, "250 kHz"}, {2, "500 kHz"}, {0,0} };
Variable::ValueDescription dataRateValues[] =
        {{6, "64"}, {7, "128"}, {8, "256"}, {9, "512"}, {10, "1024"}, {11, "2048"}, {12, "4096"}, {0,0}};
Variable::ValueDescription codeRateValues[] =
        {{1, "4/5"}, {2, "4/6"}, {3, "4/7"}, {4, "4/8"}, {0,0}};
Variable::ValueDescription preambleLenValues[] =
        {{6, "symbols"}, {65535, 0}, {0,0}};
Variable::ValueDescription symbTimeoutValues[] =
        {{4, "symbols"}, {1023, 0}, {0,0}};
Variable::ValueDescription paBoostValues[] =
        {{0, "RFO pin"}, {1, "PA_BOOST pin"}, {0,0}};
Variable::ValueDescription TXdelayValues[] =
        {{0, "ms"}, {100000, 0}, {0,0} };

Variable variables[] =
    {   Variable("freq", "the frequency", 868000, frequencyValues)
    ,   Variable("power", "the output power", 14, powerValues)
    ,   Variable("bandwidth", "the bandwidth", 1, bandwidthValues)
    ,   Variable("dataRate", "the Datarate / spreading factor", 7, dataRateValues)
    ,   Variable("codeRate", "the coding rate", 1, codeRateValues)
    ,   Variable("preambleLen", "the Preamble length", 8, preambleLenValues)
    ,   Variable("symbTimeout", "the RxSingle timeout value", 5, symbTimeoutValues)
    ,   Variable("paBoost", "forces PA_BOOST output", 0, paBoostValues)
    ,   Variable("delay", "tx delay in ms", 100, TXdelayValues)
    ,   Variable()
    };

int main() 
{
    InterruptIn pushButton(USER_BUTTON);
    Serial debugPort(SERIAL_TX, SERIAL_RX);
    debugPort.baud(9600);

    Settings s(variables);

    Terminal terminal(&s, &debugPort, &pushButton);
    debugPort.printf("\r\n\r\nELMO Terminal\r\n");
    terminal.executeCmd("h");
    terminal.start();
}
