#ifndef LIBRARIES_TESTS_RADIO_SETTINGS_SETTINGS_H_
#define LIBRARIES_TESTS_RADIO_SETTINGS_SETTINGS_H_

#include "Variable.h"

class Settings
{
public:
    Settings(Variable* variables);

    std::string describe(std::string variable) const;

    int32_t get(std::string variable) const;

    int32_t aget(std::string variable) const;

    bool set(std::string variable, int32_t value);

    std::string help(std::string variable) const;

    std::string help() const;

    std::string values() const;

private:
    /** reference to variable
     *
     * @param variableName variable name
     *
     * @returns Variable (end guard if not found)
     */
    Variable& find(const std::string& variableName) const;

    Variable* variables_;
};
#endif /* LIBRARIES_TESTS_RADIO_SETTINGS_SETTINGS_H_ */
