#include "PingPongCmd.h"
#include "dbg.h"

const string PingPongCmd::PingMsg = "PING";
const string PingPongCmd::PongMsg = "PONG";

#define RX_TIMEOUT_VALUE                                3500000   // in us




PingPongCmd::PingPongCmd(Settings* radioSettings)
    : RadioCmd(radioSettings),
        #if( defined ( TARGET_KL25Z ) || defined ( TARGET_LPC11U6X ) )
        led(LED2)
        #else
        led(LED1)
        #endif
{
    isMaster = true;
    queryable_ = true;
    led = 0;
}

PingPongCmd::~PingPongCmd()
{
}

string PingPongCmd::cmd()
{
    return "pp";
}

string PingPongCmd::desc()
{
    return "ping pong test";
}

bool PingPongCmd::execute(list<string> args)
{
    debug( "Starting Ping-Pong loop\r\n" );
    getRadioContex()->radio().Rx( RX_TIMEOUT_VALUE );
    getRadioContex()->setState(LOWPOWER);
    return true;
}

Cmd::Status PingPongCmd::process()
{
    RadioContex* p = getRadioContex();
    Radio& Radio = p->radio();
    uint16_t& BufferSize = p->BufferSize;
    uint8_t* Buffer = p->Buffer;


    switch( p->getState() )
    {
    case RX:
        if( isMaster == true )
        {
            if( BufferSize > 0 )
            {
                if( strncmp( ( const char* )Buffer, PongMsg.c_str(), 4 ) == 0 )
                {
                    led = !led;
                    debug( "...Pong\r\n" );

                    p->Send(PingMsg);
                }
                else if( strncmp( ( const char* )Buffer, PingMsg.c_str(), 4 ) == 0 )
                { // A master already exists then become a slave
                    debug( "...Ping\r\n" );
                    led = !led;
                    isMaster = false;
                    p->Send(PongMsg);
                }
                else // valid reception but neither a PING or a PONG message
                {    // Set device as master ans start again
                    isMaster = true;
                    Radio.Rx( RX_TIMEOUT_VALUE );
                }
            }
        }
        else
        {
            if( BufferSize > 0 )
            {
                if( strncmp( ( const char* )Buffer, PingMsg.c_str(), 4 ) == 0 )
                {
                    led = !led;
                    debug( "...Ping\r\n" );
                    p->Send(PongMsg);
                }
                else // valid reception but not a PING as expected
                {    // Set device as master and start again
                    isMaster = true;
                    Radio.Rx( RX_TIMEOUT_VALUE );
                }
            }
        }
        p->setState(LOWPOWER);
        break;
    case TX:
        led = !led;
        if( isMaster == true )
        {
            debug( "Ping...\r\n" );
        }
        else
        {
            debug( "Pong...\r\n" );
        }
        Radio.Rx( RX_TIMEOUT_VALUE );
        p->setState(LOWPOWER);
        break;
    case RX_TIMEOUT:
        if( isMaster == true )
        {
            p->Send(PingMsg);
        }
        else
        {
            Radio.Rx( RX_TIMEOUT_VALUE );
        }
        p->setState(LOWPOWER);
        break;
    case RX_ERROR:
        // We have received a Packet with a CRC error, send reply as if packet was correct
        if( isMaster == true )
        {
            p->Send(PingMsg);
        }
        else
        {
            p->Send(PongMsg);
        }
        p->setState(LOWPOWER);
        break;
    case TX_TIMEOUT:
        Radio.Rx( RX_TIMEOUT_VALUE );
        p->setState(LOWPOWER);
        break;
    case LOWPOWER:
        break;
    default:
        p->setState(LOWPOWER);
        break;
    }
    return CONTINUE;
}

string PingPongCmd::getResponse(void)
{
    return "frequency cmd rulez!";
}

