#include <cstdlib>
#include "HelpCmd.h"
#include "dbg.h"
#include "Settings.h"

#include "CmdList.h"

HelpCmd::HelpCmd(Settings* settings)
    : Cmd()
    , settings_(settings)
{
}

HelpCmd::~HelpCmd()
{
}

string HelpCmd::cmd()
{
    return "h";
}

string HelpCmd::desc()
{
    return "shows help";
}

template <>
void HelpCmd::help<int>()
{
}

template <typename cmds>
void HelpCmd::help()
{
    typedef typename cmds::t T;

    printf(" %s: %s\r\n", T::cmd().c_str(), T::desc().c_str());

    help<typename cmds::tn>(); // tail call recursion - optimized out (-O2)
}

bool HelpCmd::execute(list<string> args)
{
    printf("Terminal commands:\r\n");
    help<CmdList>();
    printf("\r\nButton starts ping-pong.\r\n\n");
    return true;
}

string HelpCmd::getResponse(void)
{
    return "";
}

