#ifndef _CMD_H_
#define _CMD_H_

#include <list>
#include <string>
using namespace std;

/** Terminal Command
 */
class Cmd
{
    public:
        /** Process status
         *
         * Used to notify main loop if another pass is needed
         */
        enum Status
        {
            CONTINUE,
            EXIT
        };


        /** Construtor
         */
        Cmd();

        /** Destructor
         */
        virtual ~Cmd();

        /** Execute command
         *
         * @param args args from terminal (without cmd() part)
         *
         * @returns all ok
         *
         * Can be used for commands without process part (or as a preamble to process)
         */
        virtual bool execute(list<string> args) = 0;


        /** Main loop for command
         *
         * @returns CONTINUE - process will be called again, EXIT - forced exit
         *
         * Long commands can be interrupted outside of process.
         */
        virtual Status process();


        virtual string getResponse(void) = 0;
        bool queryable();



        /** Mnemonic
         *
         * @returns mnemonic
         *
         * @see CmdFactory
         * @see CmdHelp
         */
        static string cmd();

        /** Description
         *
         * @returns short description
         *
         * @see CmdHelp
         */
        static string desc();

    protected:
        
        bool queryable_;
};

#endif
