#ifndef LIBRARIES_TESTS_RADIO_SETTINGS_VARIABLE_H_
#define LIBRARIES_TESTS_RADIO_SETTINGS_VARIABLE_H_

#include "stdint.h"
#include <string>

class Variable
{
public:
    struct ValueDescription
    {
        const int32_t value;
        const char* description;

        bool isEndRange() const
        {
            return (description == 0) && !isEnd();
        }

        bool isEnd() const
        {
            return (description == 0) && (value == 0);
        }

        static ValueDescription end()
        {
            ValueDescription vd = {0,0};
            return vd;
        }
    };

    static ValueDescription none[];

    Variable();

    bool endGuard() const;

    static int32_t nonSetValue();

    Variable(const char* name, const char* description, int32_t value, const ValueDescription* const pValueDescriptions);

    std::string name() const;

    std::string help() const;

    std::string describe(int32_t value) const;

    bool set(int32_t value);

    int32_t get() const;

    std::string describe() const;

private:
    const char* name_;
    const char* description_;
    const ValueDescription* const pValueDescriptions_;
    int32_t value_;
};

#endif /* LIBRARIES_TESTS_RADIO_SETTINGS_VARIABLE_H_ */
