#include <cassert>
#include "Settings.h"

Settings::Settings(Variable* variables)
    : variables_(variables)
{
}

Variable& Settings::find(const std::string& variableName) const
{
    Variable* p  = variables_;
    for (;  !p->endGuard(); ++p)
    {
        if (p->name() == variableName)
        {
            return *p;
        }
    }
    return *p;
}

std::string Settings::describe(std::string variable) const
{
    const Variable& r = find(variable);

    std::string temp(r.name());
    temp.append(": ");
    temp.append(r.describe());

    return temp;
}

int32_t Settings::get(std::string variable) const
{
    return find(variable).get();
}

int32_t Settings::aget(std::string variable) const
{
    int32_t v = get(variable);
    assert (v!=Variable::nonSetValue());
    return v;
}


bool Settings::set(std::string variable, int32_t value)
{
    return find(variable).set(value);
}

std::string Settings::help(std::string variable) const
{
    return find(variable).help();
}

std::string Settings::help() const
{
    std::string temp;
    for (Variable* p  = variables_;  !p->endGuard(); ++p)
    {
        temp.append(p->name());
        temp.append(": ");
        temp.append(p->help());
        temp.append("\r\n");
    }
    return temp;
}

std::string Settings::values() const
{
    std::string temp;
    for (Variable* p  = variables_;  !p->endGuard(); ++p)
    {
        temp.append(p->name());
        temp.append(": ");
        temp.append(p->describe());
        temp.append("\r\n");
    }
    return temp;
}

